/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.ext.backup.impl.BackupError;
import org.exoplatform.services.jcr.ext.backup.impl.BackupMessage;
import org.exoplatform.services.log.ExoLogger;

public class BackupMessagesLog {
    public static final int MESSAGES_MAXSIZE = 250;
    protected Log log = ExoLogger.getLogger("ext.BackupMessagesLog");
    private final List<BackupMessage> messages = new ArrayList<BackupMessage>();
    private final int messagesMaxSize;

    public BackupMessagesLog() {
        this.messagesMaxSize = 250;
    }

    public BackupMessagesLog(int messagesMaxSize) {
        this.messagesMaxSize = messagesMaxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addError(String message, Throwable e) {
        List<BackupMessage> list = this.messages;
        synchronized (list) {
            this.messages.add(new BackupError(message, e));
            this.removeEldest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(String message) {
        List<BackupMessage> list = this.messages;
        synchronized (list) {
            this.messages.add(new BackupMessage(message));
            this.removeEldest();
        }
    }

    private void removeEldest() {
        if (this.messages.size() > this.messagesMaxSize) {
            Iterator<BackupMessage> i = this.messages.iterator();
            for (int curentSize = this.messages.size(); i.hasNext() && curentSize > this.messagesMaxSize; --curentSize) {
                i.next();
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackupMessage[] getMessages() {
        List<BackupMessage> list = this.messages;
        synchronized (list) {
            BackupMessage[] copy = new BackupMessage[this.messages.size()];
            for (int i = 0; i < this.messages.size(); ++i) {
                BackupMessage m = this.messages.get(i);
                copy[i] = m instanceof BackupError ? new BackupError(((BackupError)m).getMessage(), ((BackupError)m).stackTraces) : new BackupMessage(m.getMessage());
            }
            return copy;
        }
    }

    public void clear() {
        this.messages.clear();
    }
}

