/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;

public class ChangesSaveErrorLog {
    private static final Log LOG = ExoLogger.getLogger("jcr.ChangesSaveErrorLog");
    private static final String ERROR_FILENAME_SUFFIX = "errors";
    private final String serviceDir;
    private final String repositoryName;
    private final String workcspaceName;

    public ChangesSaveErrorLog(String serviceDir, String repositoryName, String workspaceName) {
        this.serviceDir = serviceDir;
        this.repositoryName = repositoryName;
        this.workcspaceName = workspaceName;
    }

    public String[] getErrors() throws IOException {
        String s;
        File err = new File(this.serviceDir, this.getErrorFileName());
        if (!err.exists()) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(err), "UTF-8"));
        while ((s = br.readLine()) != null) {
            list.add(s);
        }
        br.close();
        return list.toArray(new String[list.size()]);
    }

    public String getErrorLog() {
        return new File(this.serviceDir, this.getErrorFileName()).getAbsolutePath();
    }

    public void reportError(Throwable t) {
        try {
            File errorFile = new File(this.serviceDir + File.separator + this.getErrorFileName());
            if (!errorFile.exists()) {
                errorFile.createNewFile();
            }
            BufferedWriter errorOut = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(errorFile, true), "UTF-8"));
            errorOut.write(t.getMessage() + "\n");
            errorOut.flush();
            errorOut.close();
        }
        catch (IOException ex) {
            LOG.error("Exception on write to error in file: ", ex);
        }
    }

    private String getErrorFileName() {
        return this.repositoryName + "_" + this.workcspaceName + "." + ERROR_FILENAME_SUFFIX;
    }
}

