/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.ext.replication.async.MergeDataManagerException;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExportException;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExporter;
import org.exoplatform.services.jcr.ext.replication.async.merge.AddMerger;
import org.exoplatform.services.jcr.ext.replication.async.merge.DeleteMerger;
import org.exoplatform.services.jcr.ext.replication.async.merge.MixinMerger;
import org.exoplatform.services.jcr.ext.replication.async.merge.RenameMerger;
import org.exoplatform.services.jcr.ext.replication.async.merge.UpdateMerger;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.CompositeItemStatesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.Member;
import org.exoplatform.services.jcr.ext.replication.async.storage.MemberChangesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.ResourcesHolder;
import org.exoplatform.services.jcr.ext.replication.async.storage.StorageRuntimeException;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeDataManager {
    protected final RemoteExporter exporter;
    protected final DataManager dataManager;
    protected final NodeTypeDataManager ntManager;
    protected final ResourcesHolder resHolder = new ResourcesHolder();
    private volatile boolean run = true;
    private final String storageDir;
    private Member localMember = null;
    protected static final Log LOG = ExoLogger.getLogger("jcr.MergerDataManager");

    MergeDataManager(RemoteExporter exporter, DataManager dataManager, NodeTypeDataManager ntManager, String storageDir) {
        this.exporter = exporter;
        this.dataManager = dataManager;
        this.ntManager = ntManager;
        this.storageDir = storageDir;
    }

    public void setLocalMember(Member localMember) {
        this.localMember = localMember;
    }

    private File makePath(Member first, Member second) {
        File dir = new File(this.storageDir, first.getPriority() + "-" + second.getPriority());
        dir.mkdirs();
        return dir;
    }

    private File makePath(String dirName) {
        File dir = new File(this.storageDir, dirName);
        dir.mkdirs();
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangesStorage<ItemState> merge(Iterator<MemberChangesStorage<ItemState>> membersChanges) throws RepositoryException, RemoteExportException, IOException, ClassCastException, ClassNotFoundException, MergeDataManagerException, StorageRuntimeException {
        try {
            MemberChangesStorage<ItemState> first = membersChanges.next();
            CompositeItemStatesStorage<ItemState> accumulated = new CompositeItemStatesStorage<ItemState>(this.makePath("accumulated-" + first.getMember().getPriority()), first.getMember(), this.resHolder);
            CompositeItemStatesStorage<ItemState> result = new CompositeItemStatesStorage<ItemState>(this.makePath("result"), this.localMember, this.resHolder);
            if (this.localMember.getPriority() == first.getMember().getPriority()) {
                accumulated.addAll(first);
            }
            while (membersChanges.hasNext() && this.run) {
                MemberChangesStorage<ItemState> local;
                MemberChangesStorage<ItemState> income;
                boolean isLocalPriority;
                MemberChangesStorage<ItemState> second = membersChanges.next();
                ArrayList<QPath> skippedList = new ArrayList<QPath>();
                ArrayList<QPath> restoredOrder = new ArrayList<QPath>();
                boolean bl = isLocalPriority = this.localMember.getPriority() >= second.getMember().getPriority();
                if (isLocalPriority) {
                    income = first;
                    local = second;
                } else {
                    income = second;
                    local = first;
                }
                LOG.info("Merge changes (local=" + isLocalPriority + ") from " + first.getMember().getPriority() + " (" + first.getMember().getAddress() + ") and " + second.getMember().getPriority() + " (" + second.getMember().getAddress() + ") members");
                CompositeItemStatesStorage<ItemState> iteration = new CompositeItemStatesStorage<ItemState>(this.makePath(first.getMember(), second.getMember()), second.getMember(), this.resHolder);
                this.exporter.setRemoteMember(second.getMember().getAddress());
                AddMerger addMerger = new AddMerger(isLocalPriority, this.exporter, this.dataManager, this.ntManager, this.resHolder);
                DeleteMerger deleteMerger = new DeleteMerger(isLocalPriority, this.exporter, this.dataManager, this.ntManager, this.resHolder);
                UpdateMerger udpateMerger = new UpdateMerger(isLocalPriority, this.exporter, this.dataManager, this.ntManager, this.resHolder);
                RenameMerger renameMerger = new RenameMerger(isLocalPriority, this.exporter, this.dataManager, this.ntManager, this.resHolder);
                MixinMerger mixinMerger = new MixinMerger(isLocalPriority, this.exporter, this.dataManager, this.ntManager, this.resHolder);
                if (!this.run) continue;
                Iterator changes = income.getChanges();
                if (changes.hasNext()) {
                    block10: while (changes.hasNext() && this.run) {
                        ItemState incomeChange = (ItemState)changes.next();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("\t\tMerging income item " + ItemState.nameFromValue(incomeChange.getState()) + " " + incomeChange.getData().getQPath().getAsString());
                        }
                        if (iteration.hasState(incomeChange)) {
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug("\t\tSkip income item " + ItemState.nameFromValue(incomeChange.getState()) + " " + incomeChange.getData().getQPath().getAsString());
                            continue;
                        }
                        for (int i = 0; i < skippedList.size(); ++i) {
                            if (!incomeChange.getData().getQPath().equals(skippedList.get(i)) && !incomeChange.getData().getQPath().isDescendantOf((QPath)skippedList.get(i))) continue;
                            if (!LOG.isDebugEnabled()) continue block10;
                            LOG.debug("\t\tMerging income item " + ItemState.nameFromValue(incomeChange.getState()) + " " + incomeChange.getData().getQPath().getAsString());
                            continue block10;
                        }
                        if (!incomeChange.getData().isNode() && (incomeChange.getData().getQPath().getName().equals(Constants.JCR_LOCKISDEEP) || incomeChange.getData().getQPath().getName().equals(Constants.JCR_LOCKOWNER))) continue;
                        switch (incomeChange.getState()) {
                            case 1: {
                                iteration.addAll(addMerger.merge(incomeChange, income, local, this.storageDir, skippedList, restoredOrder));
                                break;
                            }
                            case 4: {
                                if (incomeChange.isPersisted()) {
                                    iteration.addAll(deleteMerger.merge(incomeChange, income, local, this.storageDir, skippedList, restoredOrder));
                                    break;
                                }
                                Object nextIncomeChange = income.findNextState(incomeChange, incomeChange.getData().getIdentifier());
                                if (nextIncomeChange != null && ((ItemState)nextIncomeChange).getState() == 32) {
                                    if (iteration.hasState(((ItemState)nextIncomeChange).getData().getIdentifier(), ((ItemState)nextIncomeChange).getData().getQPath(), 1)) break;
                                    iteration.addAll(renameMerger.merge(incomeChange, income, local, this.storageDir, skippedList, restoredOrder));
                                    break;
                                }
                                if (nextIncomeChange != null && ((ItemState)nextIncomeChange).getState() == 2) {
                                    iteration.addAll(udpateMerger.merge(incomeChange, income, local, this.storageDir, skippedList, restoredOrder));
                                    break;
                                }
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("Income changes log: " + income.dump());
                                }
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("Local changes log: " + local.dump());
                                }
                                throw new MergeDataManagerException("Can not resolve merge. Unknown DELETE sequence.[path=" + incomeChange.getData().getQPath().getAsString() + "][identifier=" + incomeChange.getData().getIdentifier() + "][parentIdentifier=" + incomeChange.getData().getParentIdentifier() + "]");
                            }
                            case 2: {
                                if (incomeChange.getData().isNode()) break;
                                iteration.addAll(udpateMerger.merge(incomeChange, income, local, this.storageDir, skippedList, restoredOrder));
                                break;
                            }
                            case 16: {
                                iteration.addAll(mixinMerger.merge(incomeChange, income, local, this.storageDir, skippedList, restoredOrder));
                            }
                        }
                    }
                }
                if (isLocalPriority) {
                    accumulated.delete();
                    accumulated = new CompositeItemStatesStorage(this.makePath("accumulated-" + second.getMember().getPriority()), second.getMember(), this.resHolder);
                    accumulated.addAll(second);
                    accumulated.addAll(iteration);
                    if (this.localMember.getPriority() == second.getMember().getPriority()) {
                        result.addAll(iteration);
                    }
                } else {
                    accumulated.addAll(iteration);
                    result.addAll(iteration);
                }
                first = accumulated;
            }
            CompositeItemStatesStorage<ItemState> compositeItemStatesStorage = result;
            return compositeItemStatesStorage;
        }
        finally {
            this.run = true;
        }
    }

    public void cancel() {
        this.run = false;
    }

    public void cleanup() {
        this.run = false;
        try {
            this.resHolder.close();
        }
        catch (IOException e) {
            LOG.error("Cannot close merge data streams " + e, e);
        }
        File dir = new File(this.storageDir);
        if (dir.exists()) {
            File[] files;
            for (File f : files = dir.listFiles()) {
                this.deleteStorage(f);
            }
        }
    }

    private void deleteStorage(File file) {
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                this.deleteStorage(f);
            }
        }
        if (!file.delete()) {
            LOG.warn("Cannot delete file " + file.getAbsolutePath());
        }
    }
}

