/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.recovery;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.ext.replication.FixupStream;
import org.exoplatform.services.jcr.ext.replication.PendingChangesLog;
import org.exoplatform.services.jcr.ext.replication.recovery.AbstractFSAccess;
import org.exoplatform.services.jcr.ext.replication.recovery.FileNameFactory;
import org.exoplatform.services.jcr.ext.replication.recovery.FileRemover;
import org.exoplatform.services.jcr.ext.replication.recovery.PendingConfirmationChengesLog;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecoveryWriter
extends AbstractFSAccess {
    private static Log log = ExoLogger.getLogger("ext.RecoveryWriter");
    private static final long REMOVER_TIMEOUT = 0x6DDD00L;
    private final FileCleaner fileCleaner;
    private FileNameFactory fileNameFactory;
    private File recoveryDir;
    private File recoveryDirDate;
    private FileRemover fileRemover;

    public RecoveryWriter(File recoveryDir, FileNameFactory fileNameFactory, FileCleaner fileCleaner, String ownName) throws IOException {
        this.fileCleaner = fileCleaner;
        this.recoveryDir = recoveryDir;
        this.fileNameFactory = fileNameFactory;
        this.recoveryDirDate = new File(this.recoveryDir.getCanonicalPath() + File.separator + "data");
        if (!this.recoveryDirDate.exists()) {
            this.recoveryDirDate.mkdirs();
        }
        this.fileRemover = new FileRemover(0x6DDD00L, recoveryDir, fileCleaner, ownName);
        this.fileRemover.start();
    }

    public String save(PendingConfirmationChengesLog confirmationChengesLog) throws IOException {
        if (confirmationChengesLog.getNotConfirmationList().size() > 0) {
            String fileName = this.fileNameFactory.getTimeStampName(confirmationChengesLog.getTimeStamp()) + "_" + confirmationChengesLog.getIdentifier();
            File dir = new File(this.recoveryDirDate.getCanonicalPath() + File.separator + this.fileNameFactory.getRandomSubPath());
            dir.mkdirs();
            File f = new File(dir.getCanonicalPath() + File.separator + File.separator + fileName);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(f));
            this.writeExternal(objectOutputStream, (TransactionChangesLog)confirmationChengesLog.getChangesLog());
            objectOutputStream.flush();
            objectOutputStream.close();
            if (log.isDebugEnabled()) {
                log.debug("Write info : " + f.getAbsolutePath());
            }
            this.writeNotConfirmationInfo(f, confirmationChengesLog.getNotConfirmationList());
            return f.getName();
        }
        return null;
    }

    public String save(File f, TransactionChangesLog changesLog) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(f));
        this.writeExternal(objectOutputStream, changesLog);
        objectOutputStream.flush();
        objectOutputStream.close();
        return f.getName();
    }

    private synchronized void writeNotConfirmationInfo(File dataFile, List<String> participantsClusterList) throws IOException {
        for (String name : participantsClusterList) {
            File metaDataFile = new File(this.recoveryDir.getCanonicalPath() + File.separator + name);
            if (!metaDataFile.exists()) {
                metaDataFile.createNewFile();
            }
            RandomAccessFile raf = new RandomAccessFile(metaDataFile, "rw");
            raf.seek(metaDataFile.length());
            raf.write((dataFile.getCanonicalPath() + "\n").getBytes());
            raf.close();
        }
    }

    private void writeExternal(ObjectOutputStream out, TransactionChangesLog changesLog) throws IOException {
        PendingChangesLog pendingChangesLog = new PendingChangesLog(changesLog, this.fileCleaner);
        if (pendingChangesLog.getConteinerType() == 2) {
            out.writeInt(2);
            out.writeObject(changesLog);
            List<FixupStream> listfs = pendingChangesLog.getFixupStreams();
            out.writeInt(listfs.size());
            for (int i = 0; i < listfs.size(); ++i) {
                out.writeObject(listfs.get(i));
            }
            List<InputStream> listInputList = pendingChangesLog.getInputStreams();
            out.writeInt(listInputList.size());
            for (int i = 0; i < listInputList.size(); ++i) {
                File tempFile = this.getAsFile(listInputList.get(i));
                FileInputStream fis = new FileInputStream(tempFile);
                out.writeLong(tempFile.length());
                this.writeContent(fis, out);
                fis.close();
                this.fileCleaner.addFile(tempFile);
            }
        } else {
            out.writeInt(1);
            out.writeObject(changesLog);
        }
        out.flush();
    }

    private void writeContent(InputStream is, ObjectOutputStream oos) throws IOException {
        int len;
        byte[] buf = new byte[8192];
        int size = 0;
        while ((len = is.read(buf)) > 0) {
            oos.write(buf, 0, len);
            size += len;
        }
        oos.flush();
    }

    public synchronized void removeChangesLog(String identifier, String ownerName) throws IOException {
        String fileName;
        File metaDataFile = new File(this.recoveryDir.getAbsolutePath() + File.separator + ownerName);
        RandomAccessFile raf = new RandomAccessFile(metaDataFile, "rw");
        while ((fileName = raf.readLine()) != null) {
            if (fileName.indexOf(identifier) == -1) continue;
            raf.seek(raf.getFilePointer() - (long)(fileName.length() + 1));
            String s = new String(fileName);
            s = s.replaceAll(".", "-");
            raf.writeBytes(s);
            if (log.isDebugEnabled()) {
                log.debug("remove metadata : " + fileName);
                log.debug("remove changes log form fs : " + identifier);
            }
            this.saveRemoveChangesLog(new File(fileName).getName());
            break;
        }
        raf.close();
    }

    public long removeChangesLog(List<String> fileNameList, String ownerName) throws IOException {
        String fName;
        long removeCounter = 0L;
        File metaDataFile = new File(this.recoveryDir.getAbsolutePath() + File.separator + ownerName);
        RandomAccessFile raf = new RandomAccessFile(metaDataFile, "rw");
        HashMap<String, String> fileNameMap = new HashMap<String, String>();
        for (String fileName : fileNameList) {
            fileNameMap.put(fileName, fileName);
        }
        while ((fName = raf.readLine()) != null) {
            File f;
            if (fName.startsWith("---") || !fileNameMap.containsKey((f = new File(fName)).getName())) continue;
            raf.seek(raf.getFilePointer() - (long)(fName.length() + 1));
            String s = new String(fName);
            s = s.replaceAll(".", "-");
            raf.writeBytes(s);
            ++removeCounter;
            if (!log.isDebugEnabled()) continue;
            log.debug("remove metadata : " + fName);
            log.debug("remove changeslogs form fs : " + fileNameList.size());
        }
        raf.close();
        this.saveRemoveChangesLog(fileNameList, ownerName);
        return removeCounter;
    }

    public void saveRemoveChangesLog(String fileName) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Seve removable changeslogs form fs : " + fileName);
        }
        File removeDataFile = new File(this.recoveryDir.getAbsolutePath() + File.separator + "data" + File.separator + IdGenerator.generate() + ".remove");
        removeDataFile.createNewFile();
        BufferedWriter bw = new BufferedWriter(new FileWriter(removeDataFile));
        if (log.isDebugEnabled()) {
            log.debug("remove  : " + fileName);
        }
        bw.write(fileName + "\n");
        bw.flush();
        bw.close();
    }

    private void saveRemoveChangesLog(List<String> fileNameList, String ownerName) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Seve removable changeslogs form fs : " + fileNameList.size());
        }
        File removeDataFile = new File(this.recoveryDir.getAbsolutePath() + File.separator + "data" + File.separator + IdGenerator.generate() + ".remove");
        removeDataFile.createNewFile();
        BufferedWriter bw = new BufferedWriter(new FileWriter(removeDataFile));
        for (String fileName : fileNameList) {
            if (log.isDebugEnabled()) {
                log.debug("remove  : " + fileName);
            }
            bw.write(fileName + "\n");
        }
        bw.flush();
        bw.close();
    }
}

