/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.recovery.backup;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.replication.recovery.FileNameFactory;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.log.ExoLogger;

public class BackupCreator
implements Runnable {
    private static Log log = ExoLogger.getLogger("ext.BackupCreator");
    private Thread backupCreatorThread;
    private long delayTime;
    private String workspaceName;
    private File backupDir;
    private ManageableRepository manageableRepository;
    private FileNameFactory fileNameFactory;

    public BackupCreator(long delayTime, String workspaceName, File backupDir, ManageableRepository manageableRepository) {
        this.delayTime = delayTime;
        this.workspaceName = workspaceName;
        this.backupDir = backupDir;
        this.manageableRepository = manageableRepository;
        this.fileNameFactory = new FileNameFactory();
        this.backupCreatorThread = new Thread((Runnable)this, "BackupCreatorThread@" + manageableRepository.getConfiguration().getName() + ":" + workspaceName);
        this.backupCreatorThread.start();
    }

    public void run() {
        try {
            Thread.yield();
            Thread.sleep(this.delayTime);
            log.info("The backup has been started : " + this.manageableRepository.getConfiguration().getName() + "@" + this.workspaceName);
            SessionImpl session = (SessionImpl)this.manageableRepository.getSystemSession(this.workspaceName);
            Calendar backupTime = Calendar.getInstance();
            String fileName = this.manageableRepository.getConfiguration().getName() + "_" + this.workspaceName + "_" + this.fileNameFactory.getStrDate(backupTime) + "_" + this.fileNameFactory.getStrTime(backupTime) + ".xml";
            File backupFile = new File(this.backupDir.getCanonicalPath() + File.separator + fileName);
            if (!backupFile.createNewFile()) {
                throw new IOException("Can't create file : " + backupFile.getCanonicalPath());
            }
            session.exportWorkspaceSystemView(new FileOutputStream(backupFile), false, false);
            log.info("The backup has been finished : " + this.manageableRepository.getConfiguration().getName() + "@" + this.workspaceName);
        }
        catch (InterruptedException ie) {
            log.error("The InterruptedExeption", ie);
        }
        catch (RepositoryException e) {
            log.error("The RepositoryException", e);
        }
        catch (IOException e) {
            log.error("The IOException", e);
        }
    }
}

