/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionDatas;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.log.ExoLogger;

public class ItemDefinitionDataHolder {
    private static Log LOG = ExoLogger.getLogger("jcr.ItemDefinitionDataHolder");
    private final HashMap<ChildNodeDefKey, NodeDefinitionData> nodeDefinitions = new HashMap();
    private final HashMap<PropertyDefKey, PropertyDefinitionData> propertyDefinitions = new HashMap();
    private final HashMap<DefaultNodeDefKey, NodeDefinitionData> defNodeDefinitions = new HashMap();

    public NodeDefinitionData getChildNodeDefinition(InternalQName parentNodeType, InternalQName childName, InternalQName childNodeType) {
        NodeDefinitionData def = this.getNodeDefinitionFromThisOrSupertypes(parentNodeType, childName, childNodeType);
        return def;
    }

    private NodeDefinitionData getNodeDefinitionFromThisOrSupertypes(InternalQName parentNodeType, InternalQName childName, InternalQName childNodeType) {
        NodeDefinitionData def = this.nodeDefinitions.get(new ChildNodeDefKey(parentNodeType, childName, childNodeType));
        if (def != null) {
            return def;
        }
        return def;
    }

    public NodeDefinitionData getDefaultChildNodeDefinition(InternalQName childName, InternalQName ... nodeTypes) {
        NodeDefinitionData def;
        for (InternalQName parentNodeType : nodeTypes) {
            def = this.defNodeDefinitions.get(new DefaultNodeDefKey(parentNodeType, childName));
            if (def == null) continue;
            return def;
        }
        for (InternalQName parentNodeType : nodeTypes) {
            def = this.defNodeDefinitions.get(new DefaultNodeDefKey(parentNodeType, Constants.JCR_ANY_NAME));
            if (def == null) continue;
            return def;
        }
        return null;
    }

    public PropertyDefinitionDatas getPropertyDefinitions(InternalQName propertyName, InternalQName ... nodeTypes) {
        PropertyDefinitionDatas pdefs = new PropertyDefinitionDatas();
        for (InternalQName nt : nodeTypes) {
            PropertyDefinitionData def = this.propertyDefinitions.get(new PropertyDefKey(nt, propertyName, false));
            if (def != null && pdefs.getDefinition(def.isMultiple()) == null) {
                pdefs.setDefinition(def);
            }
            if ((def = this.propertyDefinitions.get(new PropertyDefKey(nt, propertyName, true))) == null || pdefs.getDefinition(def.isMultiple()) != null) continue;
            pdefs.setDefinition(def);
        }
        return pdefs.getAnyDefinition() != null ? pdefs : null;
    }

    public PropertyDefinitionData getPropertyDefinition(InternalQName childName, boolean multiValued, InternalQName parentNodeType) {
        PropertyDefKey key = new PropertyDefKey(parentNodeType, childName, multiValued);
        PropertyDefinitionData def = this.propertyDefinitions.get(key);
        if (def == null) {
            return this.propertyDefinitions.get(new PropertyDefKey(parentNodeType, Constants.JCR_ANY_NAME, multiValued));
        }
        return def;
    }

    void putDefinitions(InternalQName name, NodeTypeData nodeType) {
        PropertyDefinitionData[] propDefs;
        NodeDefinitionData[] nodeDefs;
        for (NodeDefinitionData nodeDef : nodeDefs = nodeType.getDeclaredChildNodeDefinitions()) {
            for (InternalQName rnt : nodeDef.getRequiredPrimaryTypes()) {
                ChildNodeDefKey nodeDefKey = new ChildNodeDefKey(name, nodeDef.getName(), rnt);
                this.nodeDefinitions.put(nodeDefKey, nodeDef);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("NodeDef added: parent NT: " + name.getAsString() + " child nodeName: " + nodeDef.getName().getAsString() + " childNT: " + rnt.getAsString() + " hash: " + nodeDefKey.hashCode());
            }
            DefaultNodeDefKey defNodeDefKey = new DefaultNodeDefKey(name, nodeDef.getName());
            this.defNodeDefinitions.put(defNodeDefKey, nodeDef);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Default NodeDef added: parent NT: " + name.getAsString() + " child nodeName: " + nodeDef.getName() + " hash: " + defNodeDefKey.hashCode());
        }
        for (PropertyDefinitionData propDef : propDefs = nodeType.getDeclaredPropertyDefinitions()) {
            PropertyDefKey propDefKey = new PropertyDefKey(name, propDef.getName(), propDef.isMultiple());
            this.propertyDefinitions.put(propDefKey, propDef);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("PropDef added: parent NT: " + name.getAsString() + " child propName: " + propDef.getName().getAsString() + " isMultiple: " + propDef.isMultiple() + " hash: " + propDefKey.hashCode());
        }
    }

    void removeDefinitions(InternalQName name, NodeTypeData nodeType) {
        PropertyDefinitionData[] propDefs;
        NodeDefinitionData[] nodeDefs;
        for (NodeDefinitionData nodeDef : nodeDefs = nodeType.getDeclaredChildNodeDefinitions()) {
            for (InternalQName rnt : nodeDef.getRequiredPrimaryTypes()) {
                ChildNodeDefKey nodeDefKey = new ChildNodeDefKey(name, nodeDef.getName(), rnt);
                this.nodeDefinitions.remove(nodeDefKey);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("NodeDef removed: parent NT: " + name.getAsString() + " child nodeName: " + nodeDef.getName().getAsString() + " childNT: " + rnt.getAsString() + " hash: " + nodeDefKey.hashCode());
            }
            DefaultNodeDefKey defNodeDefKey = new DefaultNodeDefKey(name, nodeDef.getName());
            this.defNodeDefinitions.remove(defNodeDefKey);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Default NodeDef removed: parent NT: " + name.getAsString() + " child nodeName: " + nodeDef.getName() + " hash: " + defNodeDefKey.hashCode());
        }
        for (PropertyDefinitionData propDef : propDefs = nodeType.getDeclaredPropertyDefinitions()) {
            PropertyDefKey propDefKey = new PropertyDefKey(name, propDef.getName(), propDef.isMultiple());
            this.propertyDefinitions.remove(propDefKey);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("PropDef remode: parent NT: " + name.getAsString() + " child propName: " + propDef.getName().getAsString() + " isMultiple: " + propDef.isMultiple() + " hash: " + propDefKey.hashCode());
        }
    }

    private class PropertyDefKey
    extends ItemDefKey {
        private PropertyDefKey(InternalQName parentNodeType, InternalQName childName, boolean multiValued) {
            super(parentNodeType, childName);
            this.hashCode = 31 * this.hashCode + (multiValued ? 1 : 0);
        }
    }

    private class DefaultNodeDefKey
    extends ItemDefKey {
        private DefaultNodeDefKey(InternalQName parentNodeType, InternalQName childName) {
            super(parentNodeType, childName);
        }
    }

    private class ChildNodeDefKey
    extends ItemDefKey {
        private ChildNodeDefKey(InternalQName parentNodeType, InternalQName childName, InternalQName childNodeType) {
            super(parentNodeType, childName);
            this.hashCode = 31 * this.hashCode + (null == childNodeType ? 0 : childNodeType.hashCode());
        }
    }

    private abstract class ItemDefKey {
        protected int hashCode = 7;

        protected ItemDefKey(InternalQName parentNodeType, InternalQName childName) {
            this.hashCode = 31 * this.hashCode + (null == parentNodeType ? 0 : parentNodeType.hashCode());
            this.hashCode = 31 * this.hashCode + (null == childName ? 0 : childName.hashCode());
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ItemDefKey test = (ItemDefKey)obj;
            return this.hashCode == test.hashCode();
        }
    }
}

