/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype;

import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.services.jcr.impl.core.nodetype.ItemDefinitionImpl;

public class PropertyDefinitionImpl
extends ItemDefinitionImpl
implements PropertyDefinition {
    private final int requiredType;
    private String[] valueConstraints;
    private Value[] defaultValues;
    private final boolean multiple;

    public PropertyDefinitionImpl(String name, NodeType declaringNodeType, int requiredType, String[] valueConstraints, Value[] defaultValues, boolean autoCreate, boolean mandatory, int onVersion, boolean readOnly, boolean multiple) {
        super(name, declaringNodeType, autoCreate, onVersion, readOnly, mandatory);
        this.requiredType = requiredType;
        this.valueConstraints = valueConstraints;
        this.defaultValues = defaultValues;
        this.multiple = multiple;
        int hk = 31 * this.hashCode + requiredType;
        hk = 31 * hk + valueConstraints.hashCode();
        hk = 31 * hk + defaultValues.hashCode();
        this.hashCode = 31 * hk + (multiple ? 0 : 1);
    }

    public int getRequiredType() {
        return this.requiredType;
    }

    public String[] getValueConstraints() {
        return this.valueConstraints;
    }

    public Value[] getDefaultValues() {
        if (this.defaultValues != null && this.defaultValues.length > 0) {
            return this.defaultValues;
        }
        return null;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void setDefaultValues(Value[] defaultValues) {
        this.defaultValues = defaultValues;
    }

    public void setValueConstraints(String[] valueConstraints) {
        this.valueConstraints = valueConstraints;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof PropertyDefinitionImpl) {
            return obj.hashCode() == this.hashCode;
        }
        return false;
    }
}

