/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype.registration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.core.ExtendedPropertyType;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionData;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeDataManagerImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.AbstractDefinitionComparator;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.RelatedDefinition;
import org.exoplatform.services.jcr.impl.core.value.ValueConstraintsMatcher;
import org.exoplatform.services.jcr.impl.dataflow.AbstractValueData;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyDefinitionComparator
extends AbstractDefinitionComparator<PropertyDefinitionData> {
    private static final Log LOG = ExoLogger.getLogger(PropertyDefinitionComparator.class);
    private final LocationFactory locationFactory;

    public PropertyDefinitionComparator(NodeTypeDataManagerImpl nodeTypeDataManager, DataManager persister, LocationFactory locationFactory) {
        super(nodeTypeDataManager, persister);
        this.locationFactory = locationFactory;
    }

    public PlainChangesLog compare(NodeTypeData registeredNodeType, PropertyDefinitionData[] ancestorDefinition, PropertyDefinitionData[] recipientDefinition) throws RepositoryException {
        ArrayList sameDefinitionData = new ArrayList();
        ArrayList<RelatedDefinition<PropertyDefinitionData>> changedDefinitionData = new ArrayList<RelatedDefinition<PropertyDefinitionData>>();
        ArrayList<PropertyDefinitionData> newDefinitionData = new ArrayList<PropertyDefinitionData>();
        ArrayList<PropertyDefinitionData> removedDefinitionData = new ArrayList<PropertyDefinitionData>();
        this.init(ancestorDefinition, recipientDefinition, sameDefinitionData, changedDefinitionData, newDefinitionData, removedDefinitionData);
        PlainChangesLogImpl changesLog = new PlainChangesLogImpl();
        this.validateRemoved(registeredNodeType, removedDefinitionData, recipientDefinition);
        this.validateAdded(registeredNodeType, newDefinitionData, recipientDefinition);
        Set<String> nodes = this.nodeTypeDataManager.getNodes(registeredNodeType.getName());
        this.validateChanged(registeredNodeType, changedDefinitionData, nodes, recipientDefinition);
        this.doAdd(newDefinitionData, changesLog, nodes, registeredNodeType);
        return changesLog;
    }

    private void checkIsMultiple(NodeTypeData registeredNodeType, PropertyDefinitionData recipientDefinitionData, PropertyDefinitionData[] allRecipientDefinition) throws RepositoryException, ConstraintViolationException {
        Set<String> nodes2 = Constants.JCR_ANY_NAME.equals(recipientDefinitionData.getName()) ? this.nodeTypeDataManager.getNodes(registeredNodeType.getName()) : this.nodeTypeDataManager.getNodes(registeredNodeType.getName(), new InternalQName[]{recipientDefinitionData.getName()}, new InternalQName[0]);
        for (String uuid : nodes2) {
            NodeData nodeData = (NodeData)this.persister.getItemData(uuid);
            if (Constants.JCR_ANY_NAME.equals(recipientDefinitionData.getName())) {
                List<PropertyData> propertyDatas = this.persister.getChildPropertiesData(nodeData);
                for (PropertyData propertyData : propertyDatas) {
                    if (!this.isResidualMatch(propertyData.getQPath().getName(), allRecipientDefinition) || propertyData.getValues().size() <= 1) continue;
                    throw new ConstraintViolationException("Can't change property definition " + recipientDefinitionData.getName().getAsString() + " to isMultiple = false because property " + propertyData.getQPath().getAsString() + " contains more then one value");
                }
                continue;
            }
            PropertyData propertyData = (PropertyData)this.persister.getItemData(nodeData, new QPathEntry(recipientDefinitionData.getName(), 0));
            if (propertyData.getValues().size() <= 1) continue;
            throw new ConstraintViolationException("Can't change property definition " + recipientDefinitionData.getName().getAsString() + " to isMultiple = false because property " + propertyData.getQPath().getAsString() + " contains more then one value");
        }
    }

    private void checkMandatory(NodeTypeData registeredNodeType, Set<String> nodes, PropertyDefinitionData recipientDefinitionData) throws RepositoryException {
        if (Constants.JCR_ANY_NAME.equals(recipientDefinitionData.getName()) && recipientDefinitionData.isMandatory()) {
            throw new ConstraintViolationException("Invalid property definition " + recipientDefinitionData.getName() + ". Residual definition can't be mandatory");
        }
        Set<String> nodes2 = this.nodeTypeDataManager.getNodes(registeredNodeType.getName(), new InternalQName[0], new InternalQName[]{recipientDefinitionData.getName()});
        if (nodes2.size() > 0) {
            String message = "Can not change " + recipientDefinitionData.getName().getAsString() + " property definition from mandatory=false to mandatory = true , because " + " the following nodes ";
            for (String uuids : nodes) {
                message = message + uuids + " ";
            }
            message = message + "  doesn't have these properties ";
            throw new ConstraintViolationException(message);
        }
    }

    private void checkProtected(NodeTypeData registeredNodeType, Set<String> nodes, PropertyDefinitionData recipientDefinitionData) throws RepositoryException {
        if (Constants.JCR_ANY_NAME.equals(recipientDefinitionData.getName()) && recipientDefinitionData.isMandatory()) {
            throw new ConstraintViolationException("Invalid property definition " + recipientDefinitionData.getName() + ". Residual definition can't be protected");
        }
        Set<String> nodes2 = this.nodeTypeDataManager.getNodes(registeredNodeType.getName(), new InternalQName[0], new InternalQName[]{recipientDefinitionData.getName()});
        if (nodes2.size() > 0) {
            String message = "Can not change " + recipientDefinitionData.getName().getAsString() + " property definition from Protected=false to Protected = true , because " + " the following nodes ";
            for (String uuids : nodes) {
                message = message + uuids + " ";
            }
            message = message + "  doesn't have these properties ";
            throw new ConstraintViolationException(message);
        }
    }

    private void checkRequiredType(NodeTypeData registeredNodeType, PropertyDefinitionData recipientDefinitionData, PropertyDefinitionData[] allRecipientDefinition) throws RepositoryException {
        Set<String> nodes2 = Constants.JCR_ANY_NAME.equals(recipientDefinitionData.getName()) ? this.nodeTypeDataManager.getNodes(registeredNodeType.getName()) : this.nodeTypeDataManager.getNodes(registeredNodeType.getName(), new InternalQName[]{recipientDefinitionData.getName()}, new InternalQName[0]);
        for (String uuid : nodes2) {
            NodeData nodeData = (NodeData)this.persister.getItemData(uuid);
            if (Constants.JCR_ANY_NAME.equals(recipientDefinitionData.getName())) {
                List<PropertyData> propertyDatas = this.persister.getChildPropertiesData(nodeData);
                for (PropertyData propertyData : propertyDatas) {
                    if (!this.isResidualMatch(propertyData.getQPath().getName(), allRecipientDefinition) || propertyData.getType() == recipientDefinitionData.getRequiredType()) continue;
                    throw new RepositoryException("Can not change  requiredType to " + ExtendedPropertyType.nameFromValue(recipientDefinitionData.getRequiredType()) + " in " + recipientDefinitionData.getName().getAsString() + "  because " + propertyData.getQPath().getAsString() + " have " + ExtendedPropertyType.nameFromValue(propertyData.getType()));
                }
                continue;
            }
            PropertyData propertyData = (PropertyData)this.persister.getItemData(nodeData, new QPathEntry(recipientDefinitionData.getName(), 0));
            if (propertyData.getType() == recipientDefinitionData.getRequiredType()) continue;
            throw new ConstraintViolationException("Can not change  requiredType to " + ExtendedPropertyType.nameFromValue(recipientDefinitionData.getRequiredType()) + " in " + recipientDefinitionData.getName().getAsString() + "  because " + propertyData.getQPath().getAsString() + " have " + ExtendedPropertyType.nameFromValue(propertyData.getType()));
        }
    }

    private void checkValueConstraints(NodeTypeData registeredNodeType, PropertyDefinitionData recipientDefinitionData, PropertyDefinitionData[] allRecipientDefinition) throws RepositoryException, ConstraintViolationException {
        Set<String> nodes2 = Constants.JCR_ANY_NAME.equals(recipientDefinitionData.getName()) ? this.nodeTypeDataManager.getNodes(registeredNodeType.getName()) : this.nodeTypeDataManager.getNodes(registeredNodeType.getName(), new InternalQName[]{recipientDefinitionData.getName()}, new InternalQName[0]);
        for (String uuid : nodes2) {
            NodeData nodeData = (NodeData)this.persister.getItemData(uuid);
            if (Constants.JCR_ANY_NAME.equals(recipientDefinitionData.getName())) {
                List<PropertyData> propertyDatas = this.persister.getChildPropertiesData(nodeData);
                for (PropertyData propertyData : propertyDatas) {
                    if (!this.isResidualMatch(propertyData.getQPath().getName(), allRecipientDefinition)) continue;
                    this.checkValueConstraints(recipientDefinitionData, propertyData);
                }
                continue;
            }
            PropertyData propertyData = (PropertyData)this.persister.getItemData(nodeData, new QPathEntry(recipientDefinitionData.getName(), 0));
            this.checkValueConstraints(recipientDefinitionData, propertyData);
        }
    }

    private void checkValueConstraints(PropertyDefinitionData def, PropertyData propertyData) throws ConstraintViolationException, RepositoryException {
        ValueConstraintsMatcher constraints = new ValueConstraintsMatcher(def.getValueConstraints(), this.locationFactory, this.persister, this.nodeTypeDataManager);
        for (ValueData value : propertyData.getValues()) {
            if (constraints.match(((AbstractValueData)value).createTransientCopy(), propertyData.getType())) continue;
            String strVal = null;
            try {
                strVal = propertyData.getType() != 2 ? new String(value.getAsByteArray()) : "PropertyType.BINARY";
            }
            catch (Throwable e) {
                LOG.error("Error of value read: " + e.getMessage(), e);
            }
            throw new ConstraintViolationException("Value " + strVal + " for property " + propertyData.getQPath().getAsString() + " doesn't match new constraint ");
        }
    }

    private void doAdd(List<PropertyDefinitionData> toAddList, PlainChangesLog changesLog, Set<String> nodes, NodeTypeData registeredNodeType) throws RepositoryException {
        for (String uuid : nodes) {
            NodeData nodeData = (NodeData)this.persister.getItemData(uuid);
            for (PropertyDefinitionData newPropertyDefinitionData : toAddList) {
                if (newPropertyDefinitionData.getName().equals(Constants.JCR_ANY_NAME) || !newPropertyDefinitionData.isAutoCreated()) continue;
                changesLog.addAll(this.nodeTypeDataManager.makeAutoCreatedProperties(nodeData, registeredNodeType.getName(), new PropertyDefinitionData[]{newPropertyDefinitionData}, this.persister, nodeData.getACL().getOwner()).getAllStates());
            }
        }
    }

    private void validateAdded(NodeTypeData registeredNodeType, List<PropertyDefinitionData> newDefinitionData, PropertyDefinitionData[] allRecipientDefinition) throws RepositoryException {
        if (newDefinitionData.size() > 0) {
            for (PropertyDefinitionData propertyDefinitionData : newDefinitionData) {
                if (propertyDefinitionData.getName().equals(Constants.JCR_ANY_NAME)) {
                    this.checkRequiredType(registeredNodeType, propertyDefinitionData, allRecipientDefinition);
                    this.checkValueConstraints(registeredNodeType, propertyDefinitionData, allRecipientDefinition);
                    this.checkIsMultiple(registeredNodeType, propertyDefinitionData, allRecipientDefinition);
                    continue;
                }
                if (!propertyDefinitionData.isAutoCreated() || propertyDefinitionData.getDefaultValues().length != 0) continue;
                throw new ConstraintViolationException("No default values defined for " + propertyDefinitionData.getName().getAsString());
            }
        }
    }

    private void validateChanged(NodeTypeData registeredNodeType, List<RelatedDefinition<PropertyDefinitionData>> changedDefinitionData, Set<String> nodes, PropertyDefinitionData[] allRecipientDefinition) throws RepositoryException {
        for (RelatedDefinition<PropertyDefinitionData> relatedDefinitions : changedDefinitionData) {
            PropertyDefinitionData ancestorDefinitionData = relatedDefinitions.getAncestorDefinition();
            PropertyDefinitionData recipientDefinitionData = relatedDefinitions.getRecepientDefinition();
            if (!ancestorDefinitionData.isMandatory() && recipientDefinitionData.isMandatory()) {
                this.checkMandatory(registeredNodeType, nodes, recipientDefinitionData);
            }
            if (!ancestorDefinitionData.isProtected() && recipientDefinitionData.isProtected()) {
                this.checkProtected(registeredNodeType, nodes, recipientDefinitionData);
            }
            if (ancestorDefinitionData.getRequiredType() != recipientDefinitionData.getRequiredType() && recipientDefinitionData.getRequiredType() != 0) {
                this.checkRequiredType(registeredNodeType, recipientDefinitionData, allRecipientDefinition);
            }
            if (!Arrays.deepEquals(ancestorDefinitionData.getValueConstraints(), recipientDefinitionData.getValueConstraints())) {
                this.checkValueConstraints(registeredNodeType, recipientDefinitionData, allRecipientDefinition);
            }
            if (!ancestorDefinitionData.isMultiple() || recipientDefinitionData.isMultiple()) continue;
            this.checkIsMultiple(registeredNodeType, recipientDefinitionData, allRecipientDefinition);
        }
    }

    private void validateRemoved(NodeTypeData registeredNodeType, List<PropertyDefinitionData> removedDefinitionData, PropertyDefinitionData[] recipientDefinition) throws RepositoryException {
        for (PropertyDefinitionData removePropertyDefinitionData : removedDefinitionData) {
            Set<String> nodes;
            if (removePropertyDefinitionData.getName().equals(Constants.JCR_ANY_NAME)) {
                nodes = this.nodeTypeDataManager.getNodes(registeredNodeType.getName());
                for (String uuid : nodes) {
                    NodeData nodeData = (NodeData)this.persister.getItemData(uuid);
                    List<PropertyData> childs = this.persister.getChildPropertiesData(nodeData);
                    for (PropertyData propertyData : childs) {
                        if (this.isNonResidualMatch(propertyData.getQPath().getName(), recipientDefinition)) continue;
                        throw new ConstraintViolationException("Can't remove residual property definition for " + registeredNodeType.getName().getAsString() + " node type, because node " + nodeData.getQPath().getAsString() + " contains property " + propertyData.getQPath().getName().getAsString());
                    }
                }
                continue;
            }
            if (this.isResidualMatch(removePropertyDefinitionData.getName(), recipientDefinition) || (nodes = this.nodeTypeDataManager.getNodes(registeredNodeType.getName(), new InternalQName[]{removePropertyDefinitionData.getName()}, new InternalQName[0])).size() <= 0) continue;
            String message = "Can not remove " + removePropertyDefinitionData.getName().getAsString() + " PropertyDefinitionData, because the following nodes have these properties: ";
            for (String uuids : nodes) {
                message = message + uuids + " ";
            }
            throw new ConstraintViolationException(message);
        }
    }
}

