/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.exoplatform.services.jcr.impl.core.query.lucene.AbstractIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.DocNumberCache;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexListener;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexingQueue;
import org.exoplatform.services.jcr.impl.core.query.lucene.ReadOnlyIndexReader;

class PersistentIndex
extends AbstractIndex {
    private final String name;
    private IndexListener listener;

    PersistentIndex(String name, File indexDir, Analyzer analyzer, DocNumberCache cache, IndexingQueue indexingQueue) throws IOException {
        super(analyzer, FSDirectory.getDirectory(indexDir, (LockFactory)new NativeFSLockFactory(indexDir)), cache, indexingQueue);
        this.name = name;
    }

    int removeDocument(Term idTerm) throws IOException {
        int num = super.removeDocument(idTerm);
        if (num > 0 && this.listener != null) {
            this.listener.documentDeleted(idTerm);
        }
        return num;
    }

    void mergeIndex(AbstractIndex index) throws IOException {
        index.commit();
        this.getIndexWriter().addIndexes(new Directory[]{index.getDirectory()});
        this.invalidateSharedReader();
    }

    void addIndexes(IndexReader[] readers) throws IOException {
        this.getIndexWriter().addIndexes(readers);
        this.getIndexWriter().optimize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyIndex(AbstractIndex index) throws IOException {
        index.commit(true);
        byte[] buffer = new byte[1024];
        Directory dir = index.getDirectory();
        Directory dest = this.getDirectory();
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            Object var15_12;
            IndexInput in = dir.openInput(files[i]);
            try {
                Object var13_11;
                IndexOutput out = dest.createOutput(files[i]);
                try {
                    int num;
                    for (long remaining = in.length(); remaining > 0L; remaining -= (long)num) {
                        num = (int)Math.min(remaining, (long)buffer.length);
                        in.readBytes(buffer, 0, num);
                        out.writeBytes(buffer, num);
                    }
                    var13_11 = null;
                }
                catch (Throwable throwable) {
                    var13_11 = null;
                    out.close();
                    throw throwable;
                }
                out.close();
                var15_12 = null;
            }
            catch (Throwable throwable) {
                var15_12 = null;
                in.close();
                throw throwable;
            }
            in.close();
        }
    }

    synchronized ReadOnlyIndexReader getReadOnlyIndexReader(IndexListener listener) throws IOException {
        ReadOnlyIndexReader reader = this.getReadOnlyIndexReader();
        this.listener = listener;
        return reader;
    }

    synchronized void resetListener() {
        this.listener = null;
    }

    int getNumDocuments() throws IOException {
        return this.getIndexReader().numDocs();
    }

    String getName() {
        return this.name;
    }
}

