/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.dataflow.TransientItemData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SessionChangesLog
extends PlainChangesLogImpl {
    protected Map<Object, ItemState> index = new HashMap<Object, ItemState>();

    public SessionChangesLog(String sessionId) {
        super(sessionId);
    }

    public SessionChangesLog(List<ItemState> items, String sessionId) {
        super(items, sessionId);
        for (ItemState change : items) {
            this.index.put(change.getData().getIdentifier(), change);
            this.index.put(change.getData().getQPath(), change);
        }
    }

    @Override
    public PlainChangesLog add(ItemState change) {
        super.add(change);
        this.index.put(change.getData().getIdentifier(), change);
        this.index.put(change.getData().getQPath(), change);
        return this;
    }

    @Override
    public PlainChangesLog addAll(List<ItemState> changes) {
        super.addAll(changes);
        for (ItemState change : changes) {
            this.index.put(change.getData().getIdentifier(), change);
            this.index.put(change.getData().getQPath(), change);
        }
        return this;
    }

    @Override
    public void clear() {
        super.clear();
        this.index.clear();
    }

    public void remove(QPath rootPath) {
        ArrayList<ItemState> removedList = new ArrayList<ItemState>();
        for (ItemState item : this.items) {
            QPath qPath = item.getData().getQPath();
            if (!qPath.isDescendantOf(rootPath) && !item.getAncestorToSave().isDescendantOf(rootPath) && !item.getAncestorToSave().equals(rootPath) && !qPath.equals(rootPath)) continue;
            removedList.add(item);
        }
        for (ItemState item : removedList) {
            this.items.remove(item);
            this.index.remove(item.getData().getIdentifier());
            this.index.remove(item.getData().getQPath());
        }
    }

    public List<ItemState> getDescendantsChanges(String rootIdentifier) {
        ArrayList<ItemState> changesList = new ArrayList<ItemState>();
        this.traverseChangesByIdentifier(rootIdentifier, changesList);
        return changesList;
    }

    private void traverseChangesByIdentifier(String identifier, List<ItemState> changesList) {
        for (ItemState item : this.items) {
            if (item.getData().getIdentifier().equals(identifier)) {
                changesList.add(item);
                continue;
            }
            if (!item.getData().getParentIdentifier().equals(identifier)) continue;
            this.traverseChangesByIdentifier(item.getData().getIdentifier(), changesList);
        }
    }

    public void eraseEventFire(String identifier) {
        for (ItemState item : this.items) {
            if (item.getData().getIdentifier().equals(identifier)) {
                item.eraseEventFire();
                continue;
            }
            if (!item.getData().getParentIdentifier().equals(identifier)) continue;
            this.eraseEventFire(item.getData().getIdentifier());
        }
    }

    public List<ItemState> getDescendantsChanges(QPath rootPath) {
        ArrayList<ItemState> list = new ArrayList<ItemState>();
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((ItemState)this.items.get(i)).isDescendantOf(rootPath)) continue;
            list.add((ItemState)this.items.get(i));
        }
        return list;
    }

    public List<ItemState> getItemStates(String itemIdentifier) {
        ArrayList<ItemState> states = new ArrayList<ItemState>();
        for (ItemState state : this.getAllStates()) {
            if (!state.getData().getIdentifier().equals(itemIdentifier)) continue;
            states.add(state);
        }
        return states;
    }

    public PlainChangesLog pushLog(QPath rootPath) {
        PlainChangesLogImpl cLog = new PlainChangesLogImpl(this.sessionId);
        cLog.addAll(this.getDescendantsChanges(rootPath));
        this.remove(rootPath);
        return cLog;
    }

    public ItemState getItemState(NodeData parentData, QPathEntry name) throws IllegalPathException {
        List<ItemState> allStates = this.getAllStates();
        for (int i = allStates.size() - 1; i >= 0; --i) {
            ItemState state = allStates.get(i);
            if (!state.getData().getParentIdentifier().equals(parentData.getIdentifier()) || !state.getData().getQPath().getEntries()[state.getData().getQPath().getEntries().length - 1].isSame(name)) continue;
            return state;
        }
        return null;
    }

    public ItemState getItemState(String itemIdentifier) {
        return this.index.get(itemIdentifier);
    }

    public ItemState getItemState(QPath itemPath) {
        return this.index.get(itemPath);
    }

    public List<ItemState> getChildrenChanges(String rootIdentifier) {
        ArrayList<ItemState> list = new ArrayList<ItemState>();
        for (int i = 0; i < this.items.size(); ++i) {
            ItemData item = ((ItemState)this.items.get(i)).getData();
            if (!item.getParentIdentifier().equals(rootIdentifier) && !item.getIdentifier().equals(rootIdentifier)) continue;
            list.add((ItemState)this.items.get(i));
        }
        return list;
    }

    public Collection<ItemState> getLastChildrenStates(ItemData rootData, boolean forNodes) {
        HashMap<String, ItemState> children = new HashMap<String, ItemState>();
        List<ItemState> changes = this.getChildrenChanges(rootData.getIdentifier());
        for (ItemState child : changes) {
            ItemData data = child.getData();
            if (data.isNode() != forNodes || data.equals(rootData)) continue;
            children.put(data.getIdentifier(), child);
        }
        return children.values();
    }

    public Collection<ItemState> getLastModifyStates(NodeData rootData) {
        HashMap changes = new HashMap();
        for (int i = 0; i < this.items.size(); ++i) {
            TransientItemData item = (TransientItemData)((ItemState)this.items.get(i)).getData();
            if (item.getIdentifier().equals(rootData.getIdentifier())) {
                if (((ItemState)this.items.get(i)).isAdded()) {
                    return new ArrayList<ItemState>();
                }
                if (((ItemState)this.items.get(i)).isDeleted()) continue;
                changes.put(item.getIdentifier(), this.items.get(i));
                continue;
            }
            if (!item.getParentIdentifier().equals(rootData.getIdentifier())) continue;
            changes.put(item.getIdentifier(), this.items.get(i));
        }
        return changes.values();
    }

    public ItemState[] findRenamed(QPath deletedPath) throws IllegalPathException {
        List<ItemState> allStates = this.getAllStates();
        for (int i = allStates.size() - 1; i >= 0; --i) {
            ItemState state = allStates.get(i);
            if (state.getState() != 4 || state.isPersisted() || !deletedPath.isDescendantOf(state.getData().getQPath()) && !deletedPath.equals(state.getData().getQPath())) continue;
            try {
                ItemState delete = state;
                ItemState rename = allStates.get(i + 1);
                if (rename.getState() != 32 || !rename.isPersisted() || !rename.getData().getIdentifier().equals(delete.getData().getIdentifier())) continue;
                for (int bi = allStates.size() - 1; bi >= i + 2; --bi) {
                    state = allStates.get(bi);
                    if (state.getState() != 32 || !state.isPersisted() || !state.getData().getIdentifier().equals(rename.getData().getIdentifier())) continue;
                    rename = state;
                    delete = allStates.get(i - 1);
                    if (!delete.getData().getIdentifier().equals(rename.getData().getIdentifier())) continue;
                    return new ItemState[]{delete, rename};
                }
                return new ItemState[]{delete, rename};
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
        return null;
    }

    public ItemState findItemState(QPath rootPath, Boolean isPersisted, Boolean orAncestor, int ... states) throws IllegalPathException {
        List<ItemState> allStates = this.getAllStates();
        for (int i = allStates.size() - 1; i >= 0; --i) {
            ItemState istate = allStates.get(i);
            boolean byState = false;
            if (states != null) {
                for (int state : states) {
                    if (istate.getState() != state) continue;
                    byState = true;
                    break;
                }
            } else {
                byState = true;
            }
            if (!byState || isPersisted != null && istate.isPersisted() != isPersisted.booleanValue() || orAncestor != null && orAncestor.booleanValue() && !rootPath.isDescendantOf(istate.getData().getQPath()) && !rootPath.equals(istate.getData().getQPath())) continue;
            return istate;
        }
        return null;
    }

    public ItemState findItemState(String id, Boolean isPersisted, int ... states) throws IllegalPathException {
        List<ItemState> allStates = this.getAllStates();
        for (int i = allStates.size() - 1; i >= 0; --i) {
            ItemState istate = allStates.get(i);
            boolean byState = false;
            if (states != null) {
                for (int state : states) {
                    if (istate.getState() != state) continue;
                    byState = true;
                    break;
                }
            } else {
                byState = true;
            }
            if (!byState || isPersisted != null && istate.isPersisted() != isPersisted.booleanValue() || !istate.getData().getIdentifier().equals(id)) continue;
            return istate;
        }
        return null;
    }
}

