/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.jndi;

import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.commons.collections.map.ReferenceMap;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.StandaloneContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;

public class BindableRepositoryFactory
implements ObjectFactory {
    static final String REPOSITORYNAME_ADDRTYPE = "repositoryName";
    static final String CONTAINERCONFIG_ADDRTYPE = "containerConfig";
    private static Map cache = new ReferenceMap(0, 1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        if (obj instanceof Reference) {
            Reference ref = (Reference)obj;
            Map map = cache;
            synchronized (map) {
                if (cache.containsKey(ref)) {
                    return cache.get(ref);
                }
                RefAddr containerConfig = ref.get(CONTAINERCONFIG_ADDRTYPE);
                String repositoryName = (String)ref.get(REPOSITORYNAME_ADDRTYPE).getContent();
                ExoContainer container = ExoContainerContext.getCurrentContainerIfPresent();
                if (containerConfig != null && container == null) {
                    StandaloneContainer.setConfigurationURL((String)containerConfig.getContent());
                    container = StandaloneContainer.getInstance();
                }
                ManageableRepository rep = ((RepositoryService)container.getComponentInstanceOfType(RepositoryService.class)).getRepository(repositoryName);
                cache.put(ref, rep);
                return rep;
            }
        }
        return null;
    }
}

