/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import javax.jcr.RepositoryException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.storage.WorkspaceDataContainerBase;
import org.exoplatform.services.jcr.impl.storage.jdbc.DBConstants;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCStorageConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.GenericConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.MySQLConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.OracleConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.DBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.DBInitializerException;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.IngresSQLDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.OracleDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.PgSQLDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.update.StorageUpdateManager;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.picocontainer.Startable;

public class JDBCWorkspaceDataContainer
extends WorkspaceDataContainerBase
implements Startable {
    protected static final Log LOG = ExoLogger.getLogger("jcr.JDBCWorkspaceDataContainer");
    public static final String DB_DIALECT = "dialect";
    public static final String DB_DRIVER = "driverClassName";
    public static final String DB_URL = "url";
    public static final String DB_USERNAME = "username";
    public static final String DB_PASSWORD = "password";
    protected final String containerName;
    protected final String dbSourceName;
    protected final boolean multiDb;
    protected final String dbDriver;
    protected final String dbDialect;
    protected final String dbUrl;
    protected final String dbUserName;
    protected final String dbPassword;
    protected final ValueStoragePluginProvider valueStorageProvider;
    protected String storageVersion;
    protected int maxBufferSize;
    protected File swapDirectory;
    protected FileCleaner swapCleaner;
    protected GenericConnectionFactory connFactory;

    public JDBCWorkspaceDataContainer(WorkspaceEntry wsConfig, RepositoryEntry repConfig, InitialContextInitializer contextInit, ValueStoragePluginProvider valueStorageProvider) throws RepositoryConfigurationException, NamingException, RepositoryException, IOException {
        boolean enableStorageUpdate;
        block17: {
            this.checkIntegrity(wsConfig, repConfig);
            this.containerName = wsConfig.getName();
            this.multiDb = Boolean.parseBoolean(wsConfig.getContainer().getParameterValue("multi-db"));
            this.valueStorageProvider = valueStorageProvider;
            String pDbDialect = null;
            try {
                pDbDialect = this.detectDialect(wsConfig.getContainer().getParameterValue(DB_DIALECT));
                LOG.info("Using a dialect '" + pDbDialect + "'");
            }
            catch (RepositoryConfigurationException e) {
                LOG.info("Using a default dialect '" + DBConstants.DB_DIALECT_GENERIC + "'");
                pDbDialect = DBConstants.DB_DIALECT_GENERIC;
            }
            this.dbDialect = pDbDialect;
            String pDbDriver = null;
            String pDbUrl = null;
            String pDbUserName = null;
            String pDbPassword = null;
            try {
                pDbDriver = wsConfig.getContainer().getParameterValue(DB_DRIVER);
                try {
                    pDbUserName = wsConfig.getContainer().getParameterValue(DB_USERNAME);
                    pDbPassword = wsConfig.getContainer().getParameterValue(DB_PASSWORD);
                }
                catch (RepositoryConfigurationException e) {
                    pDbPassword = null;
                    pDbUserName = null;
                }
                pDbUrl = wsConfig.getContainer().getParameterValue(DB_URL);
            }
            catch (RepositoryConfigurationException e) {
                // empty catch block
            }
            if (pDbUrl != null) {
                this.dbDriver = pDbDriver;
                this.dbUrl = pDbUrl;
                this.dbUserName = pDbUserName;
                this.dbPassword = pDbPassword;
                this.dbSourceName = null;
                LOG.info("Connect to JCR database as user '" + this.dbUserName + "'");
            } else {
                String sn;
                this.dbDriver = null;
                this.dbUrl = null;
                this.dbUserName = null;
                this.dbPassword = null;
                try {
                    sn = wsConfig.getContainer().getParameterValue("source-name");
                }
                catch (RepositoryConfigurationException e) {
                    sn = wsConfig.getContainer().getParameterValue("sourceName");
                }
                this.dbSourceName = sn;
            }
            try {
                this.maxBufferSize = wsConfig.getContainer().getParameterInteger("max-buffer-size");
            }
            catch (RepositoryConfigurationException e) {
                this.maxBufferSize = 204800;
            }
            try {
                String sdParam = wsConfig.getContainer().getParameterValue("swap-directory");
                this.swapDirectory = new File(sdParam);
            }
            catch (RepositoryConfigurationException e1) {
                this.swapDirectory = new File(DEF_SWAPDIR);
            }
            if (!this.swapDirectory.exists()) {
                this.swapDirectory.mkdirs();
            }
            this.swapCleaner = new FileCleaner(false);
            this.initDatabase();
            String suParam = null;
            enableStorageUpdate = false;
            try {
                suParam = wsConfig.getContainer().getParameterValue("update-storage");
                enableStorageUpdate = Boolean.parseBoolean(suParam);
            }
            catch (RepositoryConfigurationException e) {
                if (!LOG.isDebugEnabled()) break block17;
                LOG.debug("update-storage parameter is not set " + this.dbSourceName);
            }
        }
        this.storageVersion = StorageUpdateManager.checkVersion(this.dbSourceName, this.connFactory.getJdbcConnection(), this.multiDb, enableStorageUpdate);
        LOG.info(this.getInfo());
    }

    protected GenericConnectionFactory defaultConnectionFactory() throws NamingException, RepositoryException {
        if (this.dbSourceName != null) {
            DataSource ds = (DataSource)new InitialContext().lookup(this.dbSourceName);
            if (ds != null) {
                return new GenericConnectionFactory(ds, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            }
            throw new RepositoryException("Datasource '" + this.dbSourceName + "' is not bound in this context.");
        }
        return new GenericConnectionFactory(this.dbDriver, this.dbUrl, this.dbUserName, this.dbPassword, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
    }

    protected DBInitializer defaultDBInitializer(String sqlPath) throws NamingException, RepositoryException, IOException {
        return new DBInitializer(this.containerName, this.connFactory.getJdbcConnection(), sqlPath, this.multiDb);
    }

    protected void checkIntegrity(WorkspaceEntry wsConfig, RepositoryEntry repConfig) throws RepositoryConfigurationException {
        for (WorkspaceEntry wsEntry : repConfig.getWorkspaceEntries()) {
            if (wsEntry.getName().equals(wsConfig.getName()) || !wsEntry.getContainer().getType().equals(wsConfig.getContainer().getType()) || !wsEntry.getContainer().getType().equals(this.getClass().getName())) continue;
            if (!wsEntry.getContainer().getParameterValue("multi-db").equals(wsConfig.getContainer().getParameterValue("multi-db"))) {
                throw new RepositoryConfigurationException("All workspaces must be multi-db or single-db. But " + wsEntry.getName() + "- multi-db=" + wsEntry.getContainer().getParameterValue("multi-db") + " and " + wsConfig.getName() + "- multi-db=" + wsConfig.getContainer().getParameterValue("multi-db"));
            }
            boolean isMulti = Boolean.parseBoolean(wsConfig.getContainer().getParameterValue("multi-db"));
            String wsSourceName = null;
            String newWsSourceName = null;
            try {
                wsSourceName = wsEntry.getContainer().getParameterValue("sourceName");
                newWsSourceName = wsConfig.getContainer().getParameterValue("sourceName");
            }
            catch (RepositoryConfigurationException e) {
                // empty catch block
            }
            if (wsSourceName != null && newWsSourceName != null) {
                if (isMulti) {
                    if (!wsSourceName.equals(newWsSourceName)) continue;
                    throw new RepositoryConfigurationException("SourceName " + wsSourceName + " alredy in use in " + wsEntry.getName() + ". SourceName must be different in " + "multi-db" + ". Check configuration for " + wsConfig.getName());
                }
                if (wsSourceName.equals(newWsSourceName)) continue;
                throw new RepositoryConfigurationException("SourceName must be equals in single-db repository. Check " + wsEntry.getName() + " and " + wsConfig.getName());
            }
            String wsUri = null;
            String newWsUri = null;
            try {
                wsUri = wsEntry.getContainer().getParameterValue("db-url");
                newWsUri = wsConfig.getContainer().getParameterValue("db-url");
            }
            catch (RepositoryConfigurationException e) {
                // empty catch block
            }
            if (wsUri == null || newWsUri == null) continue;
            if (isMulti) {
                if (!wsUri.equals(newWsUri)) continue;
                throw new RepositoryConfigurationException("db-url  " + wsUri + " alredy in use in " + wsEntry.getName() + ". db-url must be different in " + "multi-db" + ". Check configuration for " + wsConfig.getName());
            }
            if (wsUri.equals(newWsUri)) continue;
            throw new RepositoryConfigurationException("db-url must be equals in single-db repository. Check " + wsEntry.getName() + " and " + wsConfig.getName());
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initDatabase() throws NamingException, RepositoryException, IOException {
        DataSource ds;
        Object var1_1 = null;
        String sqlPath = null;
        if (this.dbDialect == DBConstants.DB_DIALECT_ORACLEOCI) {
            LOG.warn(DBConstants.DB_DIALECT_ORACLEOCI + " dialect is experimental!");
            this.connFactory = this.dbSourceName != null ? this.defaultConnectionFactory() : new OracleConnectionFactory(this.dbDriver, this.dbUrl, this.dbUserName, this.dbPassword, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.ora.sql";
            OracleDBInitializer oracleDBInitializer = new OracleDBInitializer(this.containerName, this.connFactory.getJdbcConnection(), sqlPath, this.multiDb);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_ORACLE) {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.ora.sql";
            OracleDBInitializer oracleDBInitializer = new OracleDBInitializer(this.containerName, this.connFactory.getJdbcConnection(), sqlPath, this.multiDb);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_PGSQL) {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.pgsql.sql";
            PgSQLDBInitializer pgSQLDBInitializer = new PgSQLDBInitializer(this.containerName, this.connFactory.getJdbcConnection(), sqlPath, this.multiDb);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_MYSQL) {
            if (this.dbSourceName != null) {
                ds = (DataSource)new InitialContext().lookup(this.dbSourceName);
                if (ds == null) throw new RepositoryException("Datasource '" + this.dbSourceName + "' is not bound in this context.");
                this.connFactory = new MySQLConnectionFactory(ds, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            } else {
                this.connFactory = new MySQLConnectionFactory(this.dbDriver, this.dbUrl, this.dbUserName, this.dbPassword, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            }
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.mysql.sql";
            DBInitializer dBInitializer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_MYSQL_UTF8) {
            if (this.dbSourceName != null) {
                ds = (DataSource)new InitialContext().lookup(this.dbSourceName);
                if (ds == null) throw new RepositoryException("Datasource '" + this.dbSourceName + "' is not bound in this context.");
                this.connFactory = new MySQLConnectionFactory(ds, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            } else {
                this.connFactory = new MySQLConnectionFactory(this.dbDriver, this.dbUrl, this.dbUserName, this.dbPassword, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            }
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.mysql-utf8.sql";
            DBInitializer dBInitializer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_MSSQL) {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.mssql.sql";
            DBInitializer dBInitializer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_DERBY) {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.derby.sql";
            DBInitializer dBInitializer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_DB2) {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.db2.sql";
            DBInitializer dBInitializer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_DB2V8) {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.db2v8.sql";
            DBInitializer dBInitializer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_SYBASE) {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.sybase.sql";
            DBInitializer dBInitializer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_INGRES) {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.ingres.sql";
            IngresSQLDBInitializer ingresSQLDBInitializer = new IngresSQLDBInitializer(this.containerName, this.connFactory.getJdbcConnection(), sqlPath, this.multiDb);
        } else {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.sql";
            DBInitializer dBInitializer = this.defaultDBInitializer(sqlPath);
        }
        try {
            void var1_14;
            var1_14.init();
            return;
        }
        catch (DBInitializerException e) {
            LOG.error("Error of init db " + e, e);
        }
    }

    protected GenericConnectionFactory getConnectionFactory() {
        return this.connFactory;
    }

    protected String detectDialect(String confParam) {
        for (String dbType : DBConstants.DB_DIALECTS) {
            if (!dbType.equalsIgnoreCase(confParam)) continue;
            return dbType;
        }
        return DBConstants.DB_DIALECT_GENERIC;
    }

    public WorkspaceStorageConnection openConnection() throws RepositoryException {
        return this.connFactory.openConnection();
    }

    public WorkspaceStorageConnection reuseConnection(WorkspaceStorageConnection original) throws RepositoryException {
        if (original instanceof JDBCStorageConnection) {
            SharedConnectionFactory cFactory = new SharedConnectionFactory(((JDBCStorageConnection)original).getJdbcConnection(), this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            return cFactory.openConnection();
        }
        return this.openConnection();
    }

    public String getName() {
        return this.containerName;
    }

    public String getInfo() {
        String str = "JDBC based JCR Workspace Data container \ncontainer name: " + this.containerName + " \n" + "data source JNDI name: " + this.dbSourceName + "\n" + "is multi database: " + this.multiDb + "\n" + "storage version: " + this.storageVersion + "\n" + "value storage provider: " + this.valueStorageProvider + "\n" + "max buffer size (bytes): " + this.maxBufferSize + "\n" + "swap directory path: " + this.swapDirectory.getAbsolutePath();
        return str;
    }

    public String getStorageVersion() {
        return this.storageVersion;
    }

    public void start() {
        this.swapCleaner.start();
    }

    public void stop() {
        this.swapCleaner.halt();
        this.swapCleaner.interrupt();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JDBCWorkspaceDataContainer) {
            JDBCWorkspaceDataContainer another = (JDBCWorkspaceDataContainer)obj;
            if (this.getDbSourceName() != null) {
                return this.getDbSourceName().equals(another.getDbSourceName());
            }
            return this.getDbDriver().equals(another.getDbDriver()) && this.getDbUrl().equals(another.getDbUrl()) && this.getDbUserName().equals(another.getDbUserName());
        }
        return false;
    }

    protected String getDbSourceName() {
        return this.dbSourceName;
    }

    protected String getDbDriver() {
        return this.dbDriver;
    }

    protected String getDbUrl() {
        return this.dbUrl;
    }

    protected String getDbUserName() {
        return this.dbUserName;
    }

    class SharedConnectionFactory
    extends GenericConnectionFactory {
        private final Connection connection;

        SharedConnectionFactory(Connection connection, String containerName, boolean multiDb, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner) {
            super(null, null, null, null, null, containerName, multiDb, valueStorageProvider, maxBufferSize, swapDirectory, swapCleaner);
            this.connection = connection;
        }

        public Connection getJdbcConnection() throws RepositoryException {
            return this.connection;
        }
    }
}

