/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ByteArrayPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.FileStreamPersistedValueData;
import org.exoplatform.services.jcr.impl.storage.value.ValueFile;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.value.ValueIOChannel;
import org.exoplatform.services.log.ExoLogger;

public abstract class FileIOChannel
implements ValueIOChannel {
    private static Log log = ExoLogger.getLogger("jcr.FileIOChannel");
    public static final int IOBUFFER_SIZE = 32768;
    protected final File rootDir;
    protected final FileCleaner cleaner;
    protected String storageId;

    public FileIOChannel(File rootDir, FileCleaner cleaner, String storageId) {
        this.rootDir = rootDir;
        this.cleaner = cleaner;
        this.storageId = storageId;
    }

    public boolean delete(String propertyId) throws IOException {
        boolean result = true;
        for (File valueFile : this.getFiles(propertyId)) {
            if (valueFile.delete()) continue;
            result = false;
            this.cleaner.addFile(valueFile);
        }
        return result;
    }

    public void close() {
    }

    public ValueData read(String propertyId, int orderNumber, int maxBufferSize) throws IOException {
        return this.readValue(this.getFile(propertyId, orderNumber), orderNumber, maxBufferSize, false);
    }

    public ValueFile write(String propertyId, ValueData value) throws IOException {
        File f = this.getFile(propertyId, value.getOrderNumber());
        this.writeValue(f, value);
        return new ValueFileImpl(f, this.cleaner);
    }

    protected abstract String makeFilePath(String var1, int var2);

    protected abstract File getFile(String var1, int var2) throws IOException;

    protected abstract File[] getFiles(String var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ValueData readValue(File file, int orderNum, int maxBufferSize, boolean temp) throws IOException {
        int size;
        FileChannel channel;
        FileInputStream is;
        block3: {
            FileStreamPersistedValueData fileStreamPersistedValueData;
            is = new FileInputStream(file);
            channel = is.getChannel();
            try {
                size = (int)channel.size();
                if (size <= maxBufferSize) break block3;
                fileStreamPersistedValueData = new FileStreamPersistedValueData(file, orderNum, temp);
                Object var13_10 = null;
            }
            catch (Throwable throwable) {
                Object var13_12 = null;
                channel.close();
                is.close();
                throw throwable;
            }
            channel.close();
            is.close();
            return fileStreamPersistedValueData;
        }
        ByteBuffer buf = ByteBuffer.allocate(size);
        int numRead = channel.read(buf);
        byte[] arr = new byte[numRead];
        buf.rewind();
        buf.get(arr);
        ByteArrayPersistedValueData byteArrayPersistedValueData = new ByteArrayPersistedValueData(arr, orderNum);
        Object var13_11 = null;
        channel.close();
        is.close();
        return byteArrayPersistedValueData;
    }

    protected void writeValue(File file, ValueData value) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        this.writeOutput(out, value);
        ((OutputStream)out).close();
    }

    protected void writeOutput(OutputStream out, ValueData value) throws IOException {
        if (value.isByteArray()) {
            byte[] buff = value.getAsByteArray();
            out.write(buff);
        } else {
            int len;
            byte[] buffer = new byte[32768];
            InputStream in = value.getAsStream();
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }
    }

    public String getStorageId() {
        return this.storageId;
    }

    class ValueFileImpl
    implements ValueFile {
        private File file;
        private FileCleaner cleaner;

        ValueFileImpl(File f, FileCleaner cleaner) {
            this.file = f;
            this.cleaner = cleaner;
        }

        public void rollback() {
            if (this.file.exists() && !this.file.delete()) {
                this.cleaner.addFile(this.file);
            }
        }
    }
}

