/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.auth;

import java.util.Collection;
import java.util.HashSet;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Credential;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.security.PasswordCredential;
import org.exoplatform.services.security.PasswordEncrypter;
import org.exoplatform.services.security.RolesExtractor;
import org.exoplatform.services.security.UsernameCredential;

public class OrganizationAuthenticatorImpl
implements Authenticator {
    protected static Log log = ExoLogger.getLogger("org.exoplatform.services.organization.auth.OrganizationUserRegistry");
    private final OrganizationService orgService;
    private final PasswordEncrypter encrypter;
    private final RolesExtractor rolesExtractor;

    public OrganizationAuthenticatorImpl(OrganizationService orgService, RolesExtractor rolesExtractor, PasswordEncrypter encrypter) {
        this.orgService = orgService;
        this.encrypter = encrypter;
        this.rolesExtractor = rolesExtractor;
    }

    public OrganizationAuthenticatorImpl(OrganizationService orgService, RolesExtractor rolesExtractor) {
        this(orgService, rolesExtractor, null);
    }

    public OrganizationAuthenticatorImpl(OrganizationService orgService) {
        this(orgService, null, null);
    }

    public OrganizationService getOrganizationService() {
        return this.orgService;
    }

    public Identity createIdentity(String userId) throws Exception {
        HashSet<MembershipEntry> entries = new HashSet<MembershipEntry>();
        Collection memberships = this.orgService.getMembershipHandler().findMembershipsByUser(userId);
        if (memberships != null) {
            for (Membership membership : memberships) {
                entries.add(new MembershipEntry(membership.getGroupId(), membership.getMembershipType()));
            }
        }
        if (this.rolesExtractor == null) {
            return new Identity(userId, entries);
        }
        return new Identity(userId, entries, this.rolesExtractor.extractRoles(userId, entries));
    }

    public String validateUser(Credential[] credentials) throws LoginException, Exception {
        String user = null;
        String password = null;
        for (Credential cred : credentials) {
            if (cred instanceof UsernameCredential) {
                user = ((UsernameCredential)cred).getUsername();
            }
            if (!(cred instanceof PasswordCredential)) continue;
            password = ((PasswordCredential)cred).getPassword();
        }
        if (user == null || password == null) {
            throw new LoginException("Username or Password is not defined");
        }
        if (this.encrypter != null) {
            password = new String(this.encrypter.encrypt(password.getBytes()));
        }
        if (!this.orgService.getUserHandler().authenticate(user, password)) {
            throw new LoginException("Login failed for " + user);
        }
        return user;
    }
}

