/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.services.rest.GenericContainerRequest;
import org.exoplatform.services.rest.GenericContainerResponse;
import org.exoplatform.services.rest.RequestHandler;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.rest.impl.uri.UriComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationContext
implements UriInfo {
    private static ThreadLocal<ApplicationContext> current = new ThreadLocal();
    private List<String> parameterValues = new ArrayList<String>();
    private List<Object> matchedResources = new ArrayList<Object>();
    private List<String> encodedMatchedURIs = new ArrayList<String>();
    private List<String> matchedURIs = new ArrayList<String>();
    protected GenericContainerRequest request;
    protected GenericContainerResponse response;
    protected RequestHandler requestHandler;
    private Map<String, Object> attributes;
    private URI absolutePath;
    private String path;
    private String encodedPath;
    private MultivaluedMap<String, String> encodedPathParameters;
    private MultivaluedMap<String, String> pathParameters;
    private List<PathSegment> encodedPathSegments;
    private List<PathSegment> pathSegments;
    private MultivaluedMap<String, String> encodedQueryParameters;
    private MultivaluedMap<String, String> queryParameters;

    public static void setCurrent(ApplicationContext context) {
        current.set(context);
    }

    public static ApplicationContext getCurrent() {
        return current.get();
    }

    public ApplicationContext(RequestHandler requestHandler, GenericContainerRequest request, GenericContainerResponse response) {
        this.requestHandler = requestHandler;
        this.request = request;
        this.response = response;
    }

    public List<String> getParameterValues() {
        return this.parameterValues;
    }

    public void setParameterNames(List<String> parameterNames) {
        if (this.encodedPathParameters == null) {
            this.encodedPathParameters = new MultivaluedMapImpl();
        }
        for (int i = 0; i < parameterNames.size(); ++i) {
            this.encodedPathParameters.add(parameterNames.get(i), this.parameterValues.get(i));
        }
    }

    public void addMatchedResource(Object resource) {
        this.matchedResources.add(0, resource);
    }

    public void addMatchedURI(String uri) {
        this.encodedMatchedURIs.add(0, uri);
        this.matchedURIs.add(0, UriComponent.decode(uri, 4));
    }

    public Map<String, Object> getAttributes() {
        return this.attributes == null ? (this.attributes = new HashMap<String, Object>()) : this.attributes;
    }

    public Request getRequest() {
        return this.request;
    }

    public HttpHeaders getHttpHeaders() {
        return this.request;
    }

    public SecurityContext getSecurityContext() {
        return this.request;
    }

    public GenericContainerRequest getContainerRequest() {
        return this.request;
    }

    public RequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    public UriInfo getUriInfo() {
        return this;
    }

    public GenericContainerResponse getContainerResponse() {
        return this.response;
    }

    @Override
    public URI getAbsolutePath() {
        if (this.absolutePath != null) {
            return this.absolutePath;
        }
        this.absolutePath = this.getRequestUriBuilder().replaceQuery(null).fragment(null).build(new Object[0]);
        return this.absolutePath;
    }

    @Override
    public UriBuilder getAbsolutePathBuilder() {
        return UriBuilder.fromUri(this.getAbsolutePath());
    }

    @Override
    public List<Object> getMatchedResources() {
        return this.matchedResources;
    }

    @Override
    public List<String> getMatchedURIs() {
        return this.getMatchedURIs(true);
    }

    @Override
    public List<String> getMatchedURIs(boolean decode) {
        return decode ? this.matchedURIs : this.encodedMatchedURIs;
    }

    @Override
    public URI getBaseUri() {
        return this.request.getBaseUri();
    }

    @Override
    public UriBuilder getBaseUriBuilder() {
        return UriBuilder.fromUri(this.getBaseUri());
    }

    public String getConnegExtension() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPath() {
        return this.getPath(true);
    }

    @Override
    public String getPath(boolean decode) {
        if (this.encodedPath == null) {
            this.encodedPath = this.getAbsolutePath().getRawPath().substring(this.getBaseUri().getRawPath().length());
        }
        if (decode) {
            if (this.path != null) {
                return this.path;
            }
            this.path = UriComponent.decode(this.encodedPath, 5);
            return this.path;
        }
        return this.encodedPath;
    }

    @Override
    public MultivaluedMap<String, String> getPathParameters() {
        return this.getPathParameters(true);
    }

    @Override
    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        if (this.encodedPathParameters == null) {
            throw new IllegalStateException("Path template variables not initialized yet.");
        }
        if (decode) {
            if (this.pathParameters != null) {
                return this.pathParameters;
            }
            this.pathParameters = new MultivaluedMapImpl();
            for (String key : this.encodedPathParameters.keySet()) {
                this.pathParameters.putSingle(UriComponent.decode(key, 4), UriComponent.decode(this.encodedPathParameters.getFirst(key), 5));
            }
            return this.pathParameters;
        }
        return this.encodedPathParameters;
    }

    @Override
    public List<PathSegment> getPathSegments() {
        return this.getPathSegments(true);
    }

    @Override
    public List<PathSegment> getPathSegments(boolean decode) {
        if (decode) {
            return this.pathSegments != null ? this.pathSegments : (this.pathSegments = UriComponent.parsePathSegments(this.getPath(), true));
        }
        return this.encodedPathSegments != null ? this.encodedPathSegments : (this.encodedPathSegments = UriComponent.parsePathSegments(this.getPath(), false));
    }

    @Override
    public MultivaluedMap<String, String> getQueryParameters() {
        return this.getQueryParameters(true);
    }

    @Override
    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        if (decode) {
            return this.queryParameters != null ? this.queryParameters : (this.queryParameters = UriComponent.parseQueryString(this.getRequestUri().getRawQuery(), true));
        }
        return this.encodedQueryParameters != null ? this.encodedQueryParameters : (this.encodedQueryParameters = UriComponent.parseQueryString(this.getRequestUri().getRawQuery(), false));
    }

    @Override
    public URI getRequestUri() {
        return this.request.getRequestUri();
    }

    @Override
    public UriBuilder getRequestUriBuilder() {
        return UriBuilder.fromUri(this.getRequestUri());
    }
}

