/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.GenericContainerRequest;
import org.exoplatform.services.rest.GenericContainerResponse;
import org.exoplatform.services.rest.impl.ApplicationContext;
import org.exoplatform.services.rest.impl.ResourceBinder;
import org.exoplatform.services.rest.impl.header.HeaderHelper;
import org.exoplatform.services.rest.impl.header.MediaTypeHelper;
import org.exoplatform.services.rest.impl.resource.ResourceClass;
import org.exoplatform.services.rest.impl.resource.ResourceDescriptorFactory;
import org.exoplatform.services.rest.impl.resource.ResourceMethodMap;
import org.exoplatform.services.rest.impl.resource.SubResourceLocatorMap;
import org.exoplatform.services.rest.impl.resource.SubResourceMethodMap;
import org.exoplatform.services.rest.impl.uri.UriPattern;
import org.exoplatform.services.rest.method.MethodInvoker;
import org.exoplatform.services.rest.resource.ResourceMethodDescriptor;
import org.exoplatform.services.rest.resource.SubResourceLocatorDescriptor;
import org.exoplatform.services.rest.resource.SubResourceMethodDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RequestDispatcher {
    private static final Log LOG = ExoLogger.getLogger(RequestDispatcher.class.getName());
    private final ResourceBinder resourceBinder;

    public RequestDispatcher(ResourceBinder resourceBinder) {
        this.resourceBinder = resourceBinder;
    }

    public void dispatch(GenericContainerRequest request, GenericContainerResponse response) {
        List<String> parameterValues;
        ApplicationContext context = ApplicationContext.getCurrent();
        String requestPath = context.getPath(false);
        ResourceClass resourceClass = this.processResourceClass(requestPath, parameterValues = context.getParameterValues());
        if (resourceClass == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Root resource not found for " + requestPath);
            }
            throw new WebApplicationException(Response.status(Response.Status.NOT_FOUND).build());
        }
        Object resource = resourceClass.getResource();
        String newRequestPath = RequestDispatcher.getPathTail(parameterValues);
        context.addMatchedURI(requestPath.substring(0, requestPath.lastIndexOf(newRequestPath)));
        context.setParameterNames(resourceClass.getUriPattern().getParameterNames());
        this.dispatch(request, response, context, resourceClass, resource, newRequestPath);
    }

    private static String getPathTail(List<String> parameterValues) {
        int i = parameterValues.size() - 1;
        return parameterValues.get(i) != null ? parameterValues.get(i) : "";
    }

    private void dispatch(GenericContainerRequest request, GenericContainerResponse response, ApplicationContext context, ResourceClass resourceClass, Object resource, String requestPath) {
        int len;
        List<String> parameterValues = context.getParameterValues();
        if ((parameterValues.get((len = parameterValues.size()) - 1) == null || "/".equals(parameterValues.get(len - 1))) && resourceClass.getResourceMethods().size() > 0) {
            ArrayList<ResourceMethodDescriptor> methods = new ArrayList<ResourceMethodDescriptor>();
            boolean match = RequestDispatcher.processResourceMethod(resourceClass.getResourceMethods(), request, response, methods);
            if (!match) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Not found resource method for method " + request.getMethod());
                }
                return;
            }
            this.invokeResourceMethod((ResourceMethodDescriptor)methods.get(0), resource, context, request, response);
        } else {
            ArrayList<SubResourceMethodDescriptor> methods = new ArrayList<SubResourceMethodDescriptor>();
            boolean match = RequestDispatcher.processSubResourceMethod(resourceClass.getSubResourceMethods(), requestPath, request, response, parameterValues, methods);
            ArrayList<SubResourceLocatorDescriptor> locators = new ArrayList<SubResourceLocatorDescriptor>();
            boolean hasAcceptableLocator = RequestDispatcher.processSubResourceLocator(resourceClass.getSubResourceLocators(), requestPath, parameterValues, locators);
            if (!match && !hasAcceptableLocator) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Not found sub-resource methods nor sub-resource locators for path " + requestPath + " and method " + request.getMethod());
                }
                return;
            }
            if (!hasAcceptableLocator && match || hasAcceptableLocator && match && this.compareSubResources((SubResourceMethodDescriptor)methods.get(0), (SubResourceLocatorDescriptor)locators.get(0)) < 0) {
                this.invokeSubResourceMethod(requestPath, (SubResourceMethodDescriptor)methods.get(0), resource, context, request, response);
            } else if (hasAcceptableLocator && !match || hasAcceptableLocator && match && this.compareSubResources((SubResourceMethodDescriptor)methods.get(0), (SubResourceLocatorDescriptor)locators.get(0)) > 0) {
                this.invokeSuResourceLocator(requestPath, (SubResourceLocatorDescriptor)locators.get(0), resource, context, request, response);
            }
        }
    }

    private void invokeResourceMethod(ResourceMethodDescriptor rmd, Object resource, ApplicationContext context, GenericContainerRequest request, GenericContainerResponse response) {
        context.addMatchedResource(resource);
        Class<?> returnType = rmd.getResponseType();
        MethodInvoker invoker = rmd.getMethodInvoker();
        Object o = invoker.invokeMethod(resource, rmd, context);
        RequestDispatcher.processResponse(o, returnType, request, response, rmd.produces());
    }

    private void invokeSubResourceMethod(String requestPath, SubResourceMethodDescriptor srmd, Object resource, ApplicationContext context, GenericContainerRequest request, GenericContainerResponse response) {
        context.addMatchedResource(resource);
        context.addMatchedURI(requestPath);
        context.setParameterNames(srmd.getUriPattern().getParameterNames());
        Class<?> returnType = srmd.getResponseType();
        MethodInvoker invoker = srmd.getMethodInvoker();
        Object o = invoker.invokeMethod(resource, srmd, context);
        RequestDispatcher.processResponse(o, returnType, request, response, srmd.produces());
    }

    private void invokeSuResourceLocator(String requestPath, SubResourceLocatorDescriptor srld, Object resource, ApplicationContext context, GenericContainerRequest request, GenericContainerResponse response) {
        context.addMatchedResource(resource);
        String newRequestPath = RequestDispatcher.getPathTail(context.getParameterValues());
        context.addMatchedURI(requestPath.substring(0, requestPath.lastIndexOf(newRequestPath)));
        context.setParameterNames(srld.getUriPattern().getParameterNames());
        MethodInvoker invoker = srld.getMethodInvoker();
        resource = invoker.invokeMethod(resource, srld, context);
        ResourceClass resourceClass = new ResourceClass(ResourceDescriptorFactory.createAbstractResourceDescriptor(resource.getClass()), resource);
        this.dispatch(request, response, context, resourceClass, resource, newRequestPath);
    }

    private int compareSubResources(SubResourceMethodDescriptor srmd, SubResourceLocatorDescriptor srld) {
        int r = UriPattern.URIPATTERN_COMPARATOR.compare(srmd.getUriPattern(), srld.getUriPattern());
        if (r == 0) {
            return -1;
        }
        return r;
    }

    private static void processResponse(Object o, Class<?> returnType, GenericContainerRequest request, GenericContainerResponse response, List<MediaType> produces) {
        MediaType contentType = request.getAcceptableMediaType(produces);
        if (returnType == Void.TYPE || o == null) {
            response.setResponse(Response.noContent().build());
        } else if (Response.class.isAssignableFrom(returnType)) {
            Response r = (Response)o;
            if (r.getMetadata().getFirst("Content-Type") == null && r.getEntity() != null) {
                r.getMetadata().putSingle("Content-Type", contentType);
            }
            response.setResponse(r);
        } else if (GenericEntity.class.isAssignableFrom(returnType)) {
            response.setResponse(Response.ok(o, contentType).build());
        } else {
            response.setResponse(Response.ok(o, contentType).build());
        }
    }

    private ResourceClass processResourceClass(String path, List<String> capturingValues) {
        for (ResourceClass rc : this.resourceBinder.getRootResources()) {
            int len;
            if (!rc.getUriPattern().match(path, capturingValues) || capturingValues.get((len = capturingValues.size()) - 1) != null && !capturingValues.get(len - 1).equals("/") && rc.getSubResourceMethods().size() + rc.getSubResourceLocators().size() == 0) continue;
            return rc;
        }
        return null;
    }

    private static boolean processResourceMethod(ResourceMethodMap rmm, GenericContainerRequest request, GenericContainerResponse response, List<ResourceMethodDescriptor> methods) {
        List rmds = (List)rmm.get(request.getMethod());
        if (rmds == null) {
            response.setResponse(Response.status(405).header("Allow", HeaderHelper.convertToString(rmm.getAllow())).build());
            return false;
        }
        MediaType contentType = request.getMediaType();
        if (contentType == null) {
            methods.addAll(rmds);
        } else {
            for (ResourceMethodDescriptor rmd : rmds) {
                if (!MediaTypeHelper.isConsume(rmd.consumes(), contentType)) continue;
                methods.add(rmd);
            }
        }
        if (methods.isEmpty()) {
            response.setResponse(Response.status(Response.Status.UNSUPPORTED_MEDIA_TYPE).build());
            return false;
        }
        List<MediaType> acceptable = request.getAcceptableMediaTypes();
        float previousQValue = 0.0f;
        int n = 0;
        int p = 0;
        ListIterator<ResourceMethodDescriptor> i = methods.listIterator();
        while (i.hasNext()) {
            n = i.nextIndex();
            ResourceMethodDescriptor rmd = i.next();
            float qValue = MediaTypeHelper.processQuality(acceptable, rmd.produces());
            if (qValue > previousQValue) {
                previousQValue = qValue;
                p = n;
                continue;
            }
            i.remove();
        }
        if (!methods.isEmpty()) {
            if (methods.size() > 1) {
                n = 0;
                i = methods.listIterator();
                while (i.hasNext()) {
                    i.next();
                    if (n == p) break;
                    i.remove();
                    ++n;
                }
            }
            return true;
        }
        response.setResponse(Response.status(Response.Status.NOT_ACCEPTABLE).build());
        return false;
    }

    private static boolean processSubResourceMethod(SubResourceMethodMap srmm, String requestedPath, GenericContainerRequest request, GenericContainerResponse response, List<String> capturingValues, List<SubResourceMethodDescriptor> methods) {
        ResourceMethodMap rmm = null;
        for (Map.Entry e : srmm.entrySet()) {
            int len;
            if (!((UriPattern)e.getKey()).match(requestedPath, capturingValues) || capturingValues.get((len = capturingValues.size()) - 1) != null && !"/".equals(capturingValues.get(len - 1))) continue;
            rmm = (ResourceMethodMap)e.getValue();
            break;
        }
        if (rmm == null) {
            response.setResponse(Response.status(Response.Status.NOT_FOUND).build());
            return false;
        }
        ArrayList<ResourceMethodDescriptor> l = new ArrayList<ResourceMethodDescriptor>();
        boolean match = RequestDispatcher.processResourceMethod(rmm, request, response, l);
        if (match) {
            Iterator i = l.iterator();
            while (i.hasNext()) {
                methods.add((SubResourceMethodDescriptor)i.next());
            }
        }
        return match;
    }

    private static boolean processSubResourceLocator(SubResourceLocatorMap srlm, String requestedPath, List<String> capturingValues, List<SubResourceLocatorDescriptor> locators) {
        for (Map.Entry e : srlm.entrySet()) {
            if (!((UriPattern)e.getKey()).match(requestedPath, capturingValues)) continue;
            locators.add((SubResourceLocatorDescriptor)e.getValue());
        }
        return !locators.isEmpty();
    }
}

