/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.rest.impl.resource.ResourceClass;
import org.exoplatform.services.rest.impl.resource.ResourceDescriptorFactory;
import org.exoplatform.services.rest.impl.resource.ResourceDescriptorValidator;
import org.exoplatform.services.rest.impl.uri.UriPattern;
import org.exoplatform.services.rest.resource.AbstractResourceDescriptor;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.rest.resource.ResourceMethodDescriptor;
import org.exoplatform.services.rest.resource.SubResourceLocatorDescriptor;
import org.exoplatform.services.rest.resource.SubResourceMethodDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceBinder {
    private static final Log LOG = ExoLogger.getLogger("ws.rest.core.ResourceBinder");
    private List<ResourceClass> rootResources = new ArrayList<ResourceClass>();
    private static final Comparator<ResourceClass> COMPARATOR = new Comparator<ResourceClass>(){

        @Override
        public int compare(ResourceClass o1, ResourceClass o2) {
            return UriPattern.URIPATTERN_COMPARATOR.compare(o1.getUriPattern(), o2.getUriPattern());
        }
    };

    public ResourceBinder(ExoContainerContext containerContext) throws Exception {
        RuntimeDelegate.setInstance(new RuntimeDelegateImpl());
        this.init(containerContext.getContainer());
    }

    public synchronized boolean bind(Object resource) {
        AbstractResourceDescriptor ard = ResourceDescriptorFactory.createAbstractResourceDescriptor(resource.getClass());
        ResourceBinder.validate(ard);
        if (ard.isRootResource()) {
            ResourceClass rc = new ResourceClass(ard, resource);
            for (ResourceClass r : this.getRootResources()) {
                if (!r.getUriPattern().equals(rc.getUriPattern())) continue;
                LOG.warn("Ignore resource container " + rc.getClass().getName() + " the same pattern " + rc.getUriPattern() + " already registered.");
                return false;
            }
            this.rootResources.add(rc);
            Collections.sort(this.rootResources, COMPARATOR);
            LOG.info("Bind new resource " + rc.getUriPattern().getRegex() + " : " + rc.getResourceClass());
            return true;
        }
        LOG.warn("Ignore resource container " + ard.getResourceClass().getClass().getName() + " it is not root resource. Path annotation javax.ws.rs.Path is not specified for this class.");
        return false;
    }

    private static void validate(AbstractResourceDescriptor ard) {
        ResourceDescriptorValidator rdv = new ResourceDescriptorValidator();
        ard.accept(rdv);
        for (ResourceMethodDescriptor rmd : ard.getResourceMethodDescriptors()) {
            rmd.accept(rdv);
        }
        for (SubResourceMethodDescriptor srmd : ard.getSubResourceMethodDescriptors()) {
            srmd.accept(rdv);
        }
        for (SubResourceLocatorDescriptor srld : ard.getSubResourceLocatorDescriptors()) {
            srld.accept(rdv);
        }
    }

    public synchronized boolean unbind(Class clazz) {
        Iterator<ResourceClass> i = this.rootResources.iterator();
        while (i.hasNext()) {
            ResourceClass rc = i.next();
            Class c = rc.getResourceClass();
            if (!clazz.equals(c)) continue;
            i.remove();
            LOG.info("Remove ResourceContainer " + rc.getUriPattern().getRegex() + " : " + c);
            return true;
        }
        return false;
    }

    public void clear() {
        this.rootResources.clear();
    }

    public List<ResourceClass> getRootResources() {
        return this.rootResources;
    }

    private void init(ExoContainer container) {
        List l = container.getComponentInstancesOfType(ResourceContainer.class);
        for (ResourceContainer c : l) {
            this.bind(c);
        }
    }
}

