/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariantListBuilderImpl
extends Variant.VariantListBuilder {
    private List<Locale> languages = new ArrayList<Locale>();
    private List<String> encodings = new ArrayList<String>();
    private List<MediaType> mediatypes = new ArrayList<MediaType>();
    private List<Variant> variants;

    @Override
    public Variant.VariantListBuilder add() {
        if (this.variants == null) {
            this.variants = new ArrayList<Variant>();
        }
        Iterator<MediaType> mediatypesIterator = this.mediatypes.iterator();
        do {
            MediaType mediaType = mediatypesIterator.hasNext() ? mediatypesIterator.next() : null;
            Iterator<Locale> languagesIterator = this.languages.iterator();
            do {
                Locale language = languagesIterator.hasNext() ? languagesIterator.next() : null;
                Iterator<String> encodingsIterator = this.encodings.iterator();
                do {
                    String encoding = encodingsIterator.hasNext() ? encodingsIterator.next() : null;
                    this.variants.add(new Variant(mediaType, language, encoding));
                } while (encodingsIterator.hasNext());
            } while (languagesIterator.hasNext());
        } while (mediatypesIterator.hasNext());
        this.clearAll();
        return this;
    }

    @Override
    public List<Variant> build() {
        return this.variants == null ? (this.variants = new ArrayList<Variant>()) : this.variants;
    }

    @Override
    public Variant.VariantListBuilder encodings(String ... encs) {
        for (String enc : encs) {
            this.encodings.add(enc);
        }
        return this;
    }

    @Override
    public Variant.VariantListBuilder languages(Locale ... langs) {
        for (Locale lang : langs) {
            this.languages.add(lang);
        }
        return this;
    }

    @Override
    public Variant.VariantListBuilder mediaTypes(MediaType ... mediaTypes) {
        for (MediaType mediaType : mediaTypes) {
            this.mediatypes.add(mediaType);
        }
        return this;
    }

    private void clearAll() {
        this.mediatypes.clear();
        this.languages.clear();
        this.encodings.clear();
    }
}

