/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.provider;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.util.ByteArrayDataSource;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.exoplatform.services.rest.impl.provider.IOHelper;
import org.exoplatform.services.rest.provider.EntityProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceEntityProvider
implements EntityProvider<DataSource> {
    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == DataSource.class;
    }

    @Override
    public DataSource readFrom(Class<DataSource> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        String m = mediaType != null ? mediaType.toString() : null;
        return DataSourceEntityProvider.createDataSource(entityStream, m);
    }

    @Override
    public long getSize(DataSource t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return DataSource.class.isAssignableFrom(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(DataSource t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        InputStream in = t.getInputStream();
        try {
            IOHelper.write(in, entityStream);
        }
        finally {
            in.close();
        }
    }

    private static DataSource createDataSource(InputStream entityStream, String mimeType) throws IOException {
        boolean overflow = false;
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream bout = new ByteArrayOutputStream(IOHelper.getMaxBufferSize());
        int bytes = -1;
        while ((bytes = entityStream.read(buffer)) != -1) {
            bout.write(buffer, 0, bytes);
            if (bout.size() <= IOHelper.getMaxBufferSize()) continue;
            overflow = true;
            break;
        }
        if (!overflow) {
            return new ByteArrayDataSource(bout.toByteArray(), mimeType);
        }
        File file = File.createTempFile("ws_rs", "tmp");
        FileOutputStream fout = new FileOutputStream(file);
        bout.writeTo(fout);
        while ((bytes = entityStream.read(buffer)) != -1) {
            ((OutputStream)fout).write(buffer, 0, bytes);
        }
        ((OutputStream)fout).close();
        return new MimeFileDataSource(file, mimeType);
    }

    static class MimeFileDataSource
    extends FileDataSource {
        private final String mimeType;

        public MimeFileDataSource(File file, String mimeType) {
            super(file);
            this.mimeType = mimeType;
        }

        protected void finalize() throws Throwable {
            super.finalize();
            File file = this.getFile();
            if (file.exists()) {
                file.delete();
            }
        }

        public String getContentType() {
            return this.mimeType;
        }
    }
}

