/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.resource;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.rest.impl.resource.PathValue;
import org.exoplatform.services.rest.impl.uri.UriPattern;
import org.exoplatform.services.rest.resource.AbstractResourceDescriptor;
import org.exoplatform.services.rest.resource.ResourceDescriptorVisitor;
import org.exoplatform.services.rest.resource.ResourceMethodDescriptor;
import org.exoplatform.services.rest.resource.SubResourceLocatorDescriptor;
import org.exoplatform.services.rest.resource.SubResourceMethodDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractResourceDescriptorImpl
implements AbstractResourceDescriptor {
    private final PathValue path;
    private final UriPattern uriPattern;
    private final Class<?> resourceClazz;
    private final List<SubResourceMethodDescriptor> subResourceMethods;
    private final List<SubResourceLocatorDescriptor> subResourceLocators;
    private final List<ResourceMethodDescriptor> resourceMethods;

    public AbstractResourceDescriptorImpl(PathValue path, Class<?> resourceClazz) {
        this.path = path;
        this.uriPattern = path != null ? new UriPattern(path.getPath()) : null;
        this.resourceClazz = resourceClazz;
        this.subResourceMethods = new ArrayList<SubResourceMethodDescriptor>();
        this.subResourceLocators = new ArrayList<SubResourceLocatorDescriptor>();
        this.resourceMethods = new ArrayList<ResourceMethodDescriptor>();
    }

    public AbstractResourceDescriptorImpl(Class<?> resourceClazz) {
        this(null, resourceClazz);
    }

    @Override
    public void accept(ResourceDescriptorVisitor visitor) {
        visitor.visitAbstractResourceDescriptor(this);
    }

    @Override
    public PathValue getPath() {
        return this.path;
    }

    @Override
    public UriPattern getUriPattern() {
        return this.uriPattern;
    }

    @Override
    public boolean isRootResource() {
        return this.path != null;
    }

    @Override
    public Class<?> getResourceClass() {
        return this.resourceClazz;
    }

    @Override
    public List<ResourceMethodDescriptor> getResourceMethodDescriptors() {
        return this.resourceMethods;
    }

    @Override
    public List<SubResourceLocatorDescriptor> getSubResourceLocatorDescriptors() {
        return this.subResourceLocators;
    }

    @Override
    public List<SubResourceMethodDescriptor> getSubResourceMethodDescriptors() {
        return this.subResourceMethods;
    }
}

