/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.resource;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.FormParam;
import javax.ws.rs.core.MultivaluedMap;
import org.exoplatform.services.rest.impl.method.MethodParameter;
import org.exoplatform.services.rest.resource.AbstractResourceDescriptor;
import org.exoplatform.services.rest.resource.ResourceDescriptorVisitor;
import org.exoplatform.services.rest.resource.ResourceMethodDescriptor;
import org.exoplatform.services.rest.resource.SubResourceLocatorDescriptor;
import org.exoplatform.services.rest.resource.SubResourceMethodDescriptor;

public class ResourceDescriptorValidator
implements ResourceDescriptorVisitor {
    public void visitAbstractResourceDescriptor(AbstractResourceDescriptor ard) {
        if (ard.getResourceMethodDescriptors().size() == 0 && ard.getSubResourceMethodDescriptors().size() == 0 && ard.getSubResourceLocatorDescriptors().size() == 0) {
            throw new IllegalArgumentException("Not found any resource methods, sub-resource methods or sub-resource locators in " + ard.getResourceClass().getName());
        }
        if (ard.isRootResource() && ard.getPath().getPath().length() == 0) {
            throw new IllegalArgumentException("Resource class " + ard.getResourceClass() + " is root resource but path value is null or empty," + " see javax.ws.rs.Path#value()");
        }
    }

    public void visitResourceMethodDescriptor(ResourceMethodDescriptor rmd) {
        ResourceDescriptorValidator.checkMethodParameters(rmd);
    }

    public void visitSubResourceLocatorDescriptor(SubResourceLocatorDescriptor srld) {
        if (srld.getPathValue().getPath() == null || srld.getPathValue().getPath().length() == 0) {
            throw new IllegalArgumentException("Path value is null or empty for method " + srld.getMethod().getName() + " in resource class " + srld.getParentResource().getResourceClass() + ", see javax.ws.rs.Path#value()");
        }
        ResourceDescriptorValidator.checkMethodParameters(srld);
    }

    public void visitSubResourceMethodDescriptor(SubResourceMethodDescriptor srmd) {
        if (srmd.getPathValue().getPath().length() == 0) {
            throw new IllegalArgumentException("Path value is null or empty for method " + srmd.getMethod().getName() + " in resource class " + srmd.getParentResource().getResourceClass() + ", see javax.ws.rs.Path#value()");
        }
        ResourceDescriptorValidator.checkMethodParameters(srmd);
    }

    private static void checkMethodParameters(ResourceMethodDescriptor rmd) {
        List<MethodParameter> l = rmd.getMethodParameters();
        boolean entity = false;
        boolean form = false;
        for (int i = 0; i < l.size(); ++i) {
            MethodParameter mp = l.get(i);
            if (mp.getAnnotation() == null) {
                if (!entity) {
                    entity = true;
                    if (!form) continue;
                    ResourceDescriptorValidator.checkFormParam(mp.getParameterClass(), mp.getParameterType());
                    continue;
                }
                throw new IllegalArgumentException("Wrong or absent annotation at parameter with index " + i + " at " + rmd.getParentResource().getResourceClass() + "#" + rmd.getMethod().getName());
            }
            if (mp.getAnnotation().annotationType() != FormParam.class) continue;
            form = true;
            if (!entity) continue;
            ResourceDescriptorValidator.checkFormParam(mp.getParameterClass(), mp.getParameterType());
        }
    }

    private static void checkMethodParameters(SubResourceLocatorDescriptor srld) {
        List<MethodParameter> l = srld.getMethodParameters();
        for (int i = 0; i < l.size(); ++i) {
            MethodParameter mp = l.get(i);
            if (mp.getAnnotation() != null) continue;
            throw new IllegalArgumentException("Wrong or absent annotation at parameter with index " + i + " at " + srld.getParentResource().getResourceClass() + "#" + srld.getMethod().getName());
        }
    }

    private static void checkFormParam(Class clazz, Type type) {
        if (MultivaluedMap.class != clazz || !ResourceDescriptorValidator.checkGenericType(type)) {
            throw new IllegalArgumentException("If a any method parameter is annotated with FormParam then type of entity parameter MUST be MultivalueMap<String, String> or FormEntity");
        }
    }

    private static boolean checkGenericType(Type type) {
        ParameterizedType parameterizedType;
        Type[] genericTypes;
        if (type instanceof ParameterizedType && (genericTypes = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()).length == 2) {
            try {
                return String.class == (Class)genericTypes[0] && String.class == (Class)genericTypes[1];
            }
            catch (ClassCastException e) {
                throw new RuntimeException("Unsupported type");
            }
        }
        return false;
    }
}

