/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.uri;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import org.exoplatform.services.rest.impl.uri.UriComponent;
import org.exoplatform.services.rest.impl.uri.UriPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriBuilderImpl
extends UriBuilder {
    private String schema;
    private String userInfo;
    private String host;
    private int port = -1;
    private StringBuffer path = new StringBuffer();
    private StringBuffer query = new StringBuffer();
    private String fragment;

    public UriBuilderImpl() {
    }

    @Override
    public URI buildFromMap(Map<String, ? extends Object> values) {
        this.encode();
        String uri = UriPattern.createUriWithValues(this.schema, this.userInfo, this.host, this.port, this.path.toString(), this.query.toString(), this.fragment, values, true);
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new UriBuilderException(e);
        }
    }

    @Override
    public URI buildFromEncodedMap(Map<String, ? extends Object> values) {
        this.encode();
        String uri = UriPattern.createUriWithValues(this.schema, this.userInfo, this.host, this.port, this.path.toString(), this.query.toString(), this.fragment, values, false);
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new UriBuilderException(e);
        }
    }

    @Override
    public URI build(Object ... values) {
        this.encode();
        String uri = UriPattern.createUriWithValues(this.schema, this.userInfo, this.host, this.port, this.path.toString(), this.query.toString(), this.fragment, values, true);
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new UriBuilderException(e);
        }
    }

    @Override
    public URI buildFromEncoded(Object ... values) {
        this.encode();
        String uri = UriPattern.createUriWithValues(this.schema, this.userInfo, this.host, this.port, this.path.toString(), this.query.toString(), this.fragment, values, false);
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new UriBuilderException(e);
        }
    }

    private void encode() {
        this.encodePath();
        this.encodeQuery();
        this.encodeFragment();
    }

    private void encodePath() {
        if (this.path.length() == 0) {
            return;
        }
        String t = this.path.toString();
        this.path.setLength(0);
        this.path.append(UriComponent.recognizeEncode(t, 5, true));
    }

    private void encodeQuery() {
        if (this.query.length() == 0) {
            return;
        }
        String str = this.query.toString();
        this.query.setLength(0);
        int p = 0;
        int n = 0;
        while (p < str.length()) {
            if (str.charAt(p) == '=') {
                throw new UriBuilderException("Query parameter length is 0");
            }
            n = str.indexOf(38, p);
            if (n < 0) {
                n = str.length();
            }
            if (n > p) {
                String pair = str.substring(p, n);
                if (this.query.length() > 0) {
                    this.query.append('&');
                }
                if (pair.charAt(pair.length() - 1) == '=') {
                    pair = pair.substring(0, pair.length() - 1);
                }
                this.query.append(UriComponent.recognizeEncode(pair, 6, true));
            }
            p = n + 1;
        }
    }

    private void encodeFragment() {
        if (this.fragment == null || this.fragment.length() == 0) {
            return;
        }
        this.fragment = UriComponent.recognizeEncode(this.fragment, 7, true);
    }

    @Override
    public UriBuilder clone() {
        return new UriBuilderImpl(this);
    }

    private UriBuilderImpl(UriBuilderImpl cloned) {
        this.schema = cloned.schema;
        this.userInfo = cloned.userInfo;
        this.host = cloned.host;
        this.port = cloned.port;
        this.path = new StringBuffer().append(cloned.path);
        this.query = new StringBuffer().append(cloned.query);
        this.fragment = cloned.fragment;
    }

    @Override
    public UriBuilder fragment(String fragment) {
        if (fragment == null) {
            this.fragment = null;
            return this;
        }
        this.fragment = UriComponent.encode(fragment, 7, true);
        return this;
    }

    @Override
    public UriBuilder host(String host) {
        this.host = host != null ? UriComponent.recognizeEncode(host, 2, true) : null;
        return this;
    }

    @Override
    public UriBuilder matrixParam(String name, Object ... values) {
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        if (values == null) {
            throw new IllegalArgumentException("Values are null");
        }
        if (this.path.length() > 0) {
            this.path.append(';');
        }
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            Object o = values[i];
            if (o == null) {
                throw new IllegalArgumentException("Value is null");
            }
            String value = o.toString();
            this.path.append(name).append('=');
            if (value.length() > 0) {
                this.path.append(value);
            }
            if (i >= length - 1) continue;
            this.path.append(';');
        }
        return this;
    }

    @Override
    public UriBuilder path(String p) {
        boolean startSlash;
        if (this.path == null) {
            throw new IllegalArgumentException("Path segments are null");
        }
        if (p.length() == 0) {
            return this;
        }
        p = UriComponent.recognizeEncode(p, 5, true);
        boolean finalSlash = this.path.length() > 0 && this.path.charAt(this.path.length() - 1) == '/';
        boolean bl = startSlash = p.charAt(0) == '/';
        if (finalSlash && startSlash) {
            if (p.length() > 1) {
                this.path.append(p.substring(1));
            }
        } else if (this.path.length() > 0 && !finalSlash && !startSlash) {
            this.path.append('/').append(p);
        } else {
            this.path.append(p);
        }
        return this;
    }

    @Override
    public UriBuilder path(Class resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Resource is null");
        }
        if (resource.getAnnotation(Path.class) == null) {
            throw new IllegalArgumentException("Resource is not annotated with javax.ws.rs.Path");
        }
        Path p = resource.getAnnotation(Path.class);
        return this.path(p.value());
    }

    @Override
    public UriBuilder path(Method method) {
        if (method == null) {
            throw new IllegalArgumentException("Methods are null");
        }
        Path p = method.getAnnotation(Path.class);
        if (p == null) {
            throw new IllegalArgumentException("Method " + method.getName() + " is not annotated with javax.ws.rs.Path");
        }
        this.path(p.value());
        return this;
    }

    @Override
    public UriBuilder path(Class resource, String method) {
        Method[] methods;
        if (resource == null) {
            throw new IllegalArgumentException("Resource is null");
        }
        if (method == null) {
            throw new IllegalArgumentException("Method name is null");
        }
        this.path(resource);
        boolean found = false;
        for (Method m : methods = resource.getMethods()) {
            if (found && m.getName().equals(method)) {
                throw new IllegalArgumentException("More then one method with name " + method + " found");
            }
            if (!m.getName().equals(method)) continue;
            this.path(m);
            found = true;
        }
        if (!found) {
            throw new IllegalArgumentException("Method " + method + " not found at resource class " + resource.getName());
        }
        return this;
    }

    @Override
    public UriBuilder port(int port) {
        if (port < -1) {
            throw new IllegalArgumentException();
        }
        this.port = port;
        return this;
    }

    @Override
    public UriBuilder queryParam(String name, Object ... values) {
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        if (values == null) {
            throw new IllegalArgumentException("Values are null");
        }
        if (this.query.length() > 0) {
            this.query.append('&');
        }
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            Object o = values[i];
            if (o == null) {
                throw new IllegalArgumentException("Value is null");
            }
            String s = o.toString();
            this.query.append(name).append('=');
            if (s.length() > 0) {
                this.query.append(s);
            }
            if (i >= length - 1) continue;
            this.query.append('&');
        }
        return this;
    }

    @Override
    public UriBuilder replaceMatrixParam(String name, Object ... values) {
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        if (this.path.length() > 0) {
            int p = this.path.lastIndexOf("/");
            if (p == -1) {
                p = 0;
            }
            p = this.path.indexOf(";", p);
            while ((p = this.path.indexOf(name, p)) > 0) {
                int n = this.path.indexOf(";", p);
                if (n == -1) {
                    n = this.path.length();
                }
                p = p > 0 ? p - 1 : 0;
                this.path.replace(p, n, "");
            }
        }
        if (values != null && values.length > 0) {
            this.matrixParam(name, values);
        }
        return this;
    }

    @Override
    public UriBuilder replaceMatrix(String matrix) {
        if (this.path.length() > 0) {
            int p = this.path.lastIndexOf("/");
            if (p == -1) {
                p = 0;
            }
            p = this.path.indexOf(";", p);
            this.path.setLength(p + 1);
        }
        if (matrix != null && matrix.length() > 0) {
            this.path.append(matrix);
        }
        return this;
    }

    @Override
    public UriBuilder replacePath(String p) {
        this.path.setLength(0);
        this.path(p);
        return this;
    }

    @Override
    public UriBuilder replaceQueryParam(String name, Object ... values) {
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        int p = 0;
        while ((p = this.query.indexOf(name, p)) >= 0) {
            int n = this.query.indexOf("&", p);
            if (n < 0) {
                n = this.query.length();
            }
            p = p > 0 ? p - 1 : 0;
            this.query.replace(p, n, "");
            if (this.query.charAt(0) != '&') continue;
            this.query.deleteCharAt(0);
        }
        if (values != null && values.length > 0) {
            this.queryParam(name, values);
        }
        return this;
    }

    @Override
    public UriBuilder replaceQuery(String queryString) {
        this.query.setLength(0);
        if (queryString != null && queryString.length() > 0) {
            this.query.append(queryString);
        }
        return this;
    }

    @Override
    public UriBuilder scheme(String schema) {
        this.schema = schema != null ? UriComponent.validate(schema, 0, true) : null;
        return this;
    }

    @Override
    public UriBuilder schemeSpecificPart(String ssp) {
        URI uri;
        if (ssp == null) {
            throw new IllegalArgumentException("Scheme specific part (ssp) is null");
        }
        StringBuffer sb = new StringBuffer();
        if (this.schema != null) {
            sb.append(this.schema).append(':').append(UriComponent.recognizeEncode(ssp, 8, true));
        }
        if (this.fragment != null && this.fragment.length() > 0) {
            sb.append('#').append(this.fragment);
        }
        try {
            uri = new URI(sb.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        this.userInfo = uri.getRawUserInfo();
        this.host = uri.getHost();
        this.port = uri.getPort();
        this.path.setLength(0);
        this.path.append(uri.getRawPath());
        this.query.setLength(0);
        this.query.append(uri.getRawQuery() != null ? uri.getRawQuery() : "");
        return this;
    }

    @Override
    public UriBuilder segment(String ... segments) {
        if (segments == null) {
            throw new IllegalArgumentException("Path segments is null");
        }
        for (String p : segments) {
            this.path(p);
        }
        return this;
    }

    @Override
    public UriBuilder uri(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI is null");
        }
        if (uri.getScheme() != null) {
            this.schema = uri.getScheme();
        }
        if (uri.getRawUserInfo() != null) {
            this.userInfo = uri.getRawUserInfo();
        }
        if (uri.getHost() != null) {
            this.host = uri.getHost();
        }
        if (uri.getPort() != -1) {
            this.port = uri.getPort();
        }
        if (uri.getRawPath() != null && uri.getRawPath().length() > 0) {
            this.path.setLength(0);
            this.path.append(uri.getRawPath());
        }
        if (uri.getRawQuery() != null && uri.getRawQuery().length() > 0) {
            this.query.setLength(0);
            this.query.append(uri.getRawQuery());
        }
        if (uri.getRawFragment() != null) {
            this.fragment = uri.getRawFragment();
        }
        return this;
    }

    @Override
    public UriBuilder userInfo(String userInfo) {
        this.userInfo = userInfo != null ? UriComponent.recognizeEncode(userInfo, 1, true) : null;
        return this;
    }
}

