/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.Principal;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import org.exoplatform.services.rest.impl.ContainerRequest;
import org.exoplatform.services.rest.impl.InputHeadersMap;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServletContainerRequest
extends ContainerRequest {
    private HttpServletRequest servletRequest;

    public ServletContainerRequest(HttpServletRequest servletRequest) {
        super(ServletContainerRequest.getMethod(servletRequest), ServletContainerRequest.getRequestUri(servletRequest), ServletContainerRequest.getBaseUri(servletRequest), ServletContainerRequest.getEntityStream(servletRequest), ServletContainerRequest.getHeader(servletRequest));
        this.servletRequest = servletRequest;
    }

    @Override
    public String getAuthenticationScheme() {
        return this.servletRequest.getAuthType();
    }

    @Override
    public Principal getUserPrincipal() {
        return this.servletRequest.getUserPrincipal();
    }

    @Override
    public boolean isSecure() {
        return this.servletRequest.isSecure();
    }

    @Override
    public boolean isUserInRole(String role) {
        return this.servletRequest.isUserInRole(role);
    }

    public HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    private static String getMethod(HttpServletRequest servletRequest) {
        return servletRequest.getMethod();
    }

    private static URI getRequestUri(HttpServletRequest servletRequest) {
        UriBuilder baseBuilder = UriBuilder.fromUri(ServletContainerRequest.getBaseUri(servletRequest));
        return baseBuilder.replacePath(servletRequest.getRequestURI()).replaceQuery(servletRequest.getQueryString()).build(new Object[0]);
    }

    private static URI getBaseUri(HttpServletRequest servletRequest) {
        String server = servletRequest.getScheme() + "://" + servletRequest.getServerName();
        UriBuilder builder = UriBuilder.fromUri(server);
        int port = servletRequest.getServerPort();
        if (port != 80) {
            builder.port(port);
        }
        builder.path(servletRequest.getContextPath() + servletRequest.getServletPath());
        return builder.build(new Object[0]);
    }

    private static MultivaluedMap<String, String> getHeader(HttpServletRequest servletRequest) {
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        Enumeration temp = servletRequest.getHeaderNames();
        while (temp.hasMoreElements()) {
            String k = (String)temp.nextElement();
            Enumeration e = servletRequest.getHeaders(k);
            while (e.hasMoreElements()) {
                h.add(k, (String)e.nextElement());
            }
        }
        return new InputHeadersMap(h);
    }

    private static InputStream getEntityStream(HttpServletRequest servletRequest) {
        try {
            return servletRequest.getInputStream();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

