/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.jaas;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Credential;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.PasswordCredential;
import org.exoplatform.services.security.UsernameCredential;

public class DefaultLoginModule
implements LoginModule {
    private static final String OPTION_PORTAL_CONTAINER_NAME = "portalContainerName";
    private static final String DEFAULT_PORTAL_CONTAINER_NAME = "portal";
    protected Log log = ExoLogger.getLogger("core.DefaultLoginModule");
    protected Subject subject;
    private CallbackHandler callbackHandler;
    protected Identity identity;
    protected Map sharedState;
    private String portalContainerName;
    protected boolean singleLogin = false;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.portalContainerName = this.getPortalContainerName(options);
        String sl = (String)options.get("singleLogin");
        if (sl != null && (sl.equalsIgnoreCase("yes") || sl.equalsIgnoreCase("true"))) {
            this.singleLogin = true;
        }
    }

    public boolean login() throws LoginException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("In login of DefaultLoginModule.");
        }
        Callback[] callbacks = new Callback[]{new NameCallback("Username"), new PasswordCallback("Password", false)};
        try {
            this.callbackHandler.handle(callbacks);
            String username = ((NameCallback)callbacks[0]).getName();
            String password = new String(((PasswordCallback)callbacks[1]).getPassword());
            ((PasswordCallback)callbacks[1]).clearPassword();
            if (username == null || password == null) {
                return false;
            }
            Authenticator authenticator = (Authenticator)this.getContainer().getComponentInstanceOfType(Authenticator.class);
            if (authenticator == null) {
                throw new LoginException("No Authenticator component found, check your configuration");
            }
            Credential[] credentials = new Credential[]{new UsernameCredential(username), new PasswordCredential(password)};
            String userId = authenticator.validateUser(credentials);
            this.identity = authenticator.createIdentity(userId);
            this.sharedState.put("javax.security.auth.login.name", userId);
            this.subject.getPrivateCredentials().add(password);
            this.subject.getPublicCredentials().add(new UsernameCredential(username));
            return true;
        }
        catch (Throwable e) {
            this.log.error(e.getLocalizedMessage());
            throw new LoginException(e.getMessage());
        }
    }

    public boolean commit() throws LoginException {
        try {
            IdentityRegistry identityRegistry = (IdentityRegistry)this.getContainer().getComponentInstanceOfType(IdentityRegistry.class);
            if (this.singleLogin && identityRegistry.getIdentity(this.identity.getUserId()) != null) {
                throw new LoginException("User " + this.identity.getUserId() + " already logined.");
            }
            this.identity.setSubject(this.subject);
            identityRegistry.register(this.identity);
        }
        catch (Throwable e) {
            this.log.error(e.getLocalizedMessage());
            throw new LoginException(e.getMessage());
        }
        return true;
    }

    public boolean abort() throws LoginException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("In abort of DefaultLoginModule.");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("In logout of DefaultLoginModule.");
        }
        return true;
    }

    protected ExoContainer getContainer() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (container instanceof RootContainer) {
            container = RootContainer.getInstance().getPortalContainer(this.portalContainerName);
        }
        return container;
    }

    private String getPortalContainerName(Map options) {
        String optionValue;
        if (options != null && (optionValue = (String)options.get(OPTION_PORTAL_CONTAINER_NAME)) != null && optionValue.length() > 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("The DefaultLoginModule will use the portal container " + optionValue);
            }
            return optionValue;
        }
        return DEFAULT_PORTAL_CONTAINER_NAME;
    }
}

