/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.json.impl;

import java.util.Stack;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.value.JsonValue;
import org.exoplatform.ws.frameworks.json.value.impl.ArrayValue;
import org.exoplatform.ws.frameworks.json.value.impl.BooleanValue;
import org.exoplatform.ws.frameworks.json.value.impl.DoubleValue;
import org.exoplatform.ws.frameworks.json.value.impl.LongValue;
import org.exoplatform.ws.frameworks.json.value.impl.NullValue;
import org.exoplatform.ws.frameworks.json.value.impl.ObjectValue;
import org.exoplatform.ws.frameworks.json.value.impl.StringValue;

public class JsonDefaultHandler
implements JsonHandler {
    private String key;
    private JsonValue current;
    private Stack<JsonValue> values = new Stack();

    public void characters(char[] characters) {
        if (this.current.isObject()) {
            this.current.addElement(this.key, this.parseCharacters(characters));
        } else if (this.current.isArray()) {
            this.current.addElement(this.parseCharacters(characters));
        }
    }

    public void endArray() {
        this.current = this.values.pop();
    }

    public void endObject() {
        this.current = this.values.pop();
    }

    public void key(String key) {
        this.key = key;
    }

    public void startArray() {
        ArrayValue o = new ArrayValue();
        if (this.current.isObject()) {
            this.current.addElement(this.key, o);
        } else if (this.current.isArray()) {
            this.current.addElement(o);
        }
        this.values.push(this.current);
        this.current = o;
    }

    public void startObject() {
        if (this.current == null) {
            this.current = new ObjectValue();
            this.values.push(this.current);
            return;
        }
        ObjectValue o = new ObjectValue();
        if (this.current.isObject()) {
            this.current.addElement(this.key, o);
        } else if (this.current.isArray()) {
            this.current.addElement(o);
        }
        this.values.push(this.current);
        this.current = o;
    }

    public JsonValue getJsonObject() {
        return this.current;
    }

    private JsonValue parseCharacters(char[] characters) {
        String s;
        block18: {
            s = new String(characters);
            if (characters[0] == '\"' && characters[characters.length - 1] == '\"') {
                return new StringValue(s.substring(1, s.length() - 1));
            }
            if ("true".equalsIgnoreCase(new String(characters)) || "false".equalsIgnoreCase(s)) {
                return new BooleanValue(Boolean.parseBoolean(new String(characters)));
            }
            if ("null".equalsIgnoreCase(new String(characters))) {
                return new NullValue();
            }
            char c = characters[0];
            if (c >= '0' && c <= '9' || c == '.' || c == '-' || c == '+') {
                if (c == '0') {
                    if (s.length() > 2 && (s.charAt(1) == 'x' || s.charAt(1) == 'X')) {
                        try {
                            return new LongValue(Long.parseLong(s.substring(2), 16));
                        }
                        catch (NumberFormatException e) {
                            break block18;
                        }
                    }
                    try {
                        return new LongValue(Long.parseLong(s.substring(1), 8));
                    }
                    catch (NumberFormatException e) {
                        try {
                            return new LongValue(Long.parseLong(s));
                        }
                        catch (NumberFormatException l) {
                            try {
                                return new DoubleValue(Double.parseDouble(s));
                            }
                            catch (NumberFormatException d) {
                                break block18;
                            }
                        }
                    }
                }
                try {
                    return new LongValue(Long.parseLong(s));
                }
                catch (NumberFormatException l) {
                    try {
                        return new DoubleValue(Double.parseDouble(s));
                    }
                    catch (NumberFormatException d) {
                        // empty catch block
                    }
                }
            }
        }
        return new StringValue(s);
    }
}

