/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;

public final class EntityKey
implements Serializable {
    private final Serializable identifier;
    private final Serializable rootEntityName;
    private final String entityName;
    private final Type identifierType;
    private final boolean isBatchLoadable;
    private final SessionFactoryImplementor factory;
    private final int hashCode;
    private final EntityMode entityMode;

    public EntityKey(Serializable id, EntityPersister persister, EntityMode entityMode) {
        if (id == null) {
            throw new AssertionFailure("null identifier");
        }
        this.identifier = id;
        this.entityMode = entityMode;
        this.rootEntityName = persister.getRootEntityName();
        this.entityName = persister.getEntityName();
        this.identifierType = persister.getIdentifierType();
        this.isBatchLoadable = persister.isBatchLoadable();
        this.factory = persister.getFactory();
        this.hashCode = this.getHashCode();
    }

    public boolean isBatchLoadable() {
        return this.isBatchLoadable;
    }

    public Serializable getIdentifier() {
        return this.identifier;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public boolean equals(Object other) {
        EntityKey otherKey = (EntityKey)other;
        return otherKey.rootEntityName.equals(this.rootEntityName) && this.identifierType.isEqual(otherKey.identifier, this.identifier, this.entityMode, this.factory);
    }

    private int getHashCode() {
        int result = 17;
        result = 37 * result + this.rootEntityName.hashCode();
        result = 37 * result + this.identifierType.getHashCode(this.identifier, this.entityMode, this.factory);
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "EntityKey" + MessageHelper.infoString(this.factory.getEntityPersister(this.entityName), this.identifier, this.factory);
    }
}

