/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.StaleStateException;
import org.hibernate.jdbc.AbstractBatcher;
import org.hibernate.jdbc.ConnectionManager;

public class BatchingBatcher
extends AbstractBatcher {
    private int batchSize;
    private int[] expectedRowCounts = new int[this.getFactory().getSettings().getJdbcBatchSize()];

    public BatchingBatcher(ConnectionManager connectionManager, Interceptor interceptor) {
        super(connectionManager, interceptor);
    }

    public void addToBatch(int expectedRowCount) throws SQLException, HibernateException {
        log.trace("Adding to batch");
        PreparedStatement batchUpdate = this.getStatement();
        batchUpdate.addBatch();
        this.expectedRowCounts[this.batchSize++] = expectedRowCount;
        if (this.batchSize == this.getFactory().getSettings().getJdbcBatchSize()) {
            this.doExecuteBatch(batchUpdate);
        }
    }

    protected void doExecuteBatch(PreparedStatement ps) throws SQLException, HibernateException {
        if (this.batchSize == 0) {
            log.debug("no batched statements to execute");
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Executing batch size: " + this.batchSize);
            }
            try {
                this.checkRowCounts(ps.executeBatch());
            }
            catch (RuntimeException re) {
                log.error("Exception executing batch: ", re);
                throw re;
            }
            finally {
                this.batchSize = 0;
            }
        }
    }

    private void checkRowCounts(int[] rowCounts) {
        int rowCountLength = rowCounts.length;
        if (rowCountLength != this.batchSize) {
            log.warn("JDBC driver did not return the expected number of row counts");
        }
        for (int i = 0; i < rowCountLength; ++i) {
            this.checkRowCount(rowCounts[i], this.expectedRowCounts[i], i);
        }
    }

    private void checkRowCount(int rowCount, int expectedRowCount, int i) {
        if (rowCount == -2) {
            if (log.isDebugEnabled()) {
                log.debug("success of batch update unknown: " + i);
            }
        } else {
            if (rowCount == -3) {
                throw new HibernateException("Batch update failed: " + i);
            }
            if (expectedRowCount >= 0) {
                if (rowCount < expectedRowCount) {
                    throw new StaleStateException("Batch update returned unexpected row count from update: " + i + " actual row count: " + rowCount + " expected: " + expectedRowCount);
                }
                if (rowCount > expectedRowCount) {
                    throw new HibernateException("Batch update returned unexpected row count from update: " + i + " actual row count: " + rowCount + " expected: " + expectedRowCount);
                }
            }
        }
    }
}

