/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.PropertyAccessorFactory;
import org.hibernate.property.Setter;
import org.hibernate.proxy.MapProxyFactory;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.tuple.AbstractEntityTuplizer;
import org.hibernate.tuple.DynamicMapInstantiator;
import org.hibernate.tuple.EntityMetamodel;
import org.hibernate.tuple.Instantiator;

public class DynamicMapEntityTuplizer
extends AbstractEntityTuplizer {
    static final Log log = LogFactory.getLog(DynamicMapEntityTuplizer.class);

    DynamicMapEntityTuplizer(EntityMetamodel entityMetamodel, PersistentClass mappedEntity) {
        super(entityMetamodel, mappedEntity);
    }

    public EntityMode getEntityMode() {
        return EntityMode.MAP;
    }

    private PropertyAccessor buildPropertyAccessor(Property mappedProperty) {
        if (mappedProperty.isBackRef()) {
            return mappedProperty.getPropertyAccessor(null);
        }
        return PropertyAccessorFactory.getDynamicMapPropertyAccessor();
    }

    protected Getter buildPropertyGetter(Property mappedProperty, PersistentClass mappedEntity) {
        return this.buildPropertyAccessor(mappedProperty).getGetter(null, mappedProperty.getName());
    }

    protected Setter buildPropertySetter(Property mappedProperty, PersistentClass mappedEntity) {
        return this.buildPropertyAccessor(mappedProperty).getSetter(null, mappedProperty.getName());
    }

    protected Instantiator buildInstantiator(PersistentClass mappingInfo) {
        return new DynamicMapInstantiator(mappingInfo);
    }

    protected ProxyFactory buildProxyFactory(PersistentClass mappingInfo, Getter idGetter, Setter idSetter) {
        MapProxyFactory pf = new MapProxyFactory();
        try {
            pf.postInstantiate(this.getEntityName(), null, null, null, null, null);
        }
        catch (HibernateException he) {
            log.warn("could not create proxy factory for:" + this.getEntityName(), he);
            pf = null;
        }
        return pf;
    }

    public Class getMappedClass() {
        return Map.class;
    }

    public Class getConcreteProxyClass() {
        return Map.class;
    }

    public boolean isInstrumented() {
        return false;
    }
}

