/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.model;

import org.jibx.binding.model.ElementBase;
import org.jibx.runtime.ITrackSource;
import org.jibx.runtime.ValidationException;

public class ValidationProblem {
    public static final int WARNING_LEVEL = 0;
    public static final int ERROR_LEVEL = 1;
    public static final int FATAL_LEVEL = 2;
    private final int m_severity;
    private final String m_message;
    private final Object m_component;

    ValidationProblem(int level, String msg, Object obj) {
        this.m_severity = level;
        this.m_message = msg;
        this.m_component = obj;
    }

    public static String componentDescription(Object obj) {
        StringBuffer buff = new StringBuffer();
        if (obj instanceof ElementBase) {
            buff.append(ElementBase.ELEMENT_NAMES[((ElementBase)obj).type()]);
            buff.append(" element");
        } else {
            String cname = obj.getClass().getName();
            int split = cname.lastIndexOf(46);
            if (split >= 0) {
                cname = cname.substring(split + 1);
            }
            buff.append(cname);
        }
        if (obj instanceof ITrackSource) {
            buff.append(" at ");
            buff.append(ValidationException.describe(obj));
        } else {
            buff.append(" at unknown location");
        }
        return buff.toString();
    }

    ValidationProblem(String msg, Object obj) {
        this(1, msg, obj);
    }

    public Object getComponent() {
        return this.m_component;
    }

    public String getDescription() {
        if (this.m_component == null) {
            return this.m_message;
        }
        return this.m_message + "; on " + ValidationProblem.componentDescription(this.m_component);
    }

    public int getSeverity() {
        return this.m_severity;
    }
}

