/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.jcrconsole;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.jcr.Credentials;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.SimpleCredentials;
import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.exoplatform.container.StandaloneContainer;
import org.exoplatform.frameworks.jcr.cli.CliAppContext;
import org.exoplatform.services.command.impl.CommandService;
import org.exoplatform.services.jcr.RepositoryService;

public class JcrConsoleClient {
    private CliAppContext context;
    private StandaloneContainer container;
    private CommandService cservice;
    private ArrayList<String> params = new ArrayList();
    private final String PARAMETERS_KEY = "parametersss";
    private int CONSOLE_LINES_COUNT = 20;
    private int TMP_CONSOLE_LINES_COUNT;
    private boolean exit = false;
    private Catalog catalog = null;

    JcrConsoleClient() {
        this.initContext();
    }

    JcrConsoleClient(CliAppContext ctx) {
        this.context = ctx;
    }

    private void initContext() {
        try {
            if (System.getProperty("java.security.auth.login.config") == null) {
                System.setProperty("java.security.auth.login.config", Thread.currentThread().getContextClassLoader().getResource("login.conf").toString());
            }
            String confPath = Thread.currentThread().getContextClassLoader().getResource("conf/standalone/jcr-console-configuration.xml").toString();
            StandaloneContainer.addConfigurationURL((String)confPath);
            this.container = StandaloneContainer.getInstance();
            RepositoryService repService = (RepositoryService)this.container.getComponentInstanceOfType(RepositoryService.class);
            this.cservice = (CommandService)this.container.getComponentInstanceOfType(CommandService.class);
            this.catalog = this.cservice.getCatalog("CLI");
            SimpleCredentials cred = new SimpleCredentials("root", "exo".toCharArray());
            this.context = new CliAppContext(repService.getRepository(), "parametersss", (Credentials)cred);
            Node root = this.context.getSession().getRootNode();
            this.context.setCurrentItem((Item)root);
        }
        catch (Exception e) {
            this.context = null;
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        JcrConsoleClient client = new JcrConsoleClient();
        client.run(args);
    }

    private void run(String[] args) {
        System.out.println("*** Welcome to eXo JCR Console ***");
        while (!this.exit) {
            try {
                System.out.print(">");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                String input = bufferedReader.readLine();
                if (input.trim().equals("exit") || input.trim().equals("quit")) {
                    this.exit = true;
                    System.out.println("Good bye...");
                    continue;
                }
                if (input.trim().length() == 0) continue;
                this.runCommand(input);
            }
            catch (Exception e) {
                System.out.println("Invalid command");
            }
        }
        System.exit(0);
    }

    void runCommand(String input) throws Exception {
        String commandLine;
        if (input.startsWith("#") || input.length() == 0) {
            return;
        }
        String command = commandLine.substring(0, (commandLine = input).indexOf(" ") < 0 ? commandLine.length() : commandLine.indexOf(" "));
        commandLine = commandLine.substring(commandLine.indexOf(command) + command.length());
        commandLine = commandLine.trim();
        Command commandToExecute = this.catalog.getCommand(command);
        this.params = this.parseQuery(commandLine);
        this.context.put((Object)"parametersss", this.params);
        commandToExecute.execute((Context)this.context);
        String[] strings = input.split("\\|");
        this.TMP_CONSOLE_LINES_COUNT = strings.length == 2 ? new Integer(strings[1]) : this.CONSOLE_LINES_COUNT;
        String output = this.context.getOutput();
        String[] outputStrings = output.split("\n");
        int outputLinesCount = outputStrings.length;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        if (outputLinesCount > this.TMP_CONSOLE_LINES_COUNT) {
            int i = 0;
            int j = 0;
            boolean f = true;
            while (i < outputLinesCount || f) {
                if (j == this.TMP_CONSOLE_LINES_COUNT) {
                    System.out.println("Continue output? [y/n]");
                    String yesOrNo = in.readLine();
                    if (yesOrNo.equalsIgnoreCase("y")) {
                        j = 0;
                        f = false;
                        continue;
                    }
                    if (!yesOrNo.equalsIgnoreCase("n")) continue;
                    f = false;
                    break;
                }
                System.out.println(outputStrings[i]);
                ++i;
                ++j;
            }
        } else {
            System.out.print(output);
        }
    }

    private ArrayList parseQuery(String query) {
        int i = 0;
        ArrayList<String> paramsss = new ArrayList<String>();
        try {
            paramsss.clear();
            if (query.indexOf("\"") == -1) {
                while (!query.equals("")) {
                    String item = query.substring(0, query.indexOf(" ") < 0 ? query.length() : query.indexOf(" "));
                    paramsss.add(item);
                    query = query.substring(query.indexOf(item) + item.length());
                    query = query.trim();
                    ++i;
                }
            } else {
                while (!query.equals("")) {
                    String item = "";
                    item = query.startsWith("\"") ? query.substring(query.indexOf("\""), query.indexOf("\"", 1) < 0 ? query.length() : query.indexOf("\"", 1) + 1) : query.substring(0, query.indexOf(" ") < 0 ? query.length() : query.indexOf(" "));
                    if ((item = item.trim()) != null && item != "") {
                        paramsss.add(item);
                    }
                    query = query.substring(query.indexOf(item) + item.length());
                    query = query.trim();
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return paramsss;
    }
}

