/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.ooplugin.client;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.exoplatform.applications.ooplugin.XmlUtil;
import org.exoplatform.applications.ooplugin.client.DocumentApi;
import org.exoplatform.applications.ooplugin.client.ResponseDoc;
import org.exoplatform.services.log.ExoLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Multistatus
implements DocumentApi {
    private static Log LOG = ExoLogger.getLogger(Multistatus.class);
    protected ArrayList<ResponseDoc> responses = new ArrayList();

    @Override
    public boolean initFromDocument(Document document) {
        try {
            Node documentNode = XmlUtil.getChildNode(document, "multistatus");
            NodeList respNodes = documentNode.getChildNodes();
            for (int i = 0; i < respNodes.getLength(); ++i) {
                Node curResponse = respNodes.item(i);
                String localName = curResponse.getLocalName();
                String nameSpace = curResponse.getNamespaceURI();
                if (localName == null || !"DAV:".equals(nameSpace)) continue;
                ResponseDoc response = new ResponseDoc(curResponse);
                this.responses.add(response);
            }
            return true;
        }
        catch (Exception exc) {
            LOG.info((Object)("Unhandled exception. " + exc.getMessage()));
            exc.printStackTrace();
            return false;
        }
    }

    public ArrayList<ResponseDoc> getResponses() {
        return this.responses;
    }
}

