/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.ooplugin.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class TextUtils {
    public static Document getXmlFromBytes(byte[] xmlBytes) throws Exception {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlBytes);
        return builderFactory.newDocumentBuilder().parse(inputStream);
    }

    public static String UnEscape(String string, char escape) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == escape) {
                try {
                    out.write(Integer.parseInt(string.substring(i + 1, i + 3), 16));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException();
                }
                i += 2;
                continue;
            }
            out.write(c);
        }
        try {
            return new String(out.toByteArray(), "utf-8");
        }
        catch (Exception exc) {
            throw new InternalError(exc.toString());
        }
    }

    public static String getMimeType(String type) {
        if (type.equalsIgnoreCase(".odt")) {
            return "application/vnd.oasis.opendocument.text";
        }
        if (type.equalsIgnoreCase(".odp")) {
            return "application/vnd.oasis.opendocument.presentation";
        }
        if (type.equalsIgnoreCase(".ods")) {
            return "application/vnd.oasis.opendocument.spreadsheet";
        }
        if (type.equalsIgnoreCase(".doc")) {
            return "application/msword";
        }
        if (type.equalsIgnoreCase(".ppt")) {
            return "application/vnd.ms-powerpoint ";
        }
        if (type.equalsIgnoreCase(".xls")) {
            return "application/msexcel";
        }
        if (type.equalsIgnoreCase(".rtf")) {
            return "application/vnd.oasis.opendocument.spreadsheet";
        }
        return "";
    }

    public static String EncodePath(String path) throws Exception {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String[] pathElements = path.split("/");
        StringBuffer sb = new StringBuffer();
        for (String string : pathElements) {
            sb.append("/").append(URLEncoder.encode(string, "UTF-8"));
        }
        return sb.toString();
    }

    public static String DecodePath(String path) throws Exception {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String[] pathElements = path.split("/");
        StringBuffer sb = new StringBuffer();
        for (String string : pathElements) {
            sb.append("/").append(URLDecoder.decode(string, "UTF-8"));
        }
        return sb.toString();
    }

    public static String FilterFileName(String filename) {
        while (filename.startsWith(" ")) {
            filename = filename.substring(1);
        }
        filename = filename.substring(0, filename.indexOf("."));
        return filename;
    }
}

