/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.ooplugin;

import com.sun.star.awt.Rectangle;
import com.sun.star.awt.WindowClass;
import com.sun.star.awt.WindowDescriptor;
import com.sun.star.awt.XMessageBox;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.DispatchDescriptor;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XStatusListener;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XSingleComponentFactory;
import com.sun.star.lib.uno.helper.Factory;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.URL;
import org.apache.commons.logging.Log;
import org.exoplatform.applications.ooplugin.AboutDialog;
import org.exoplatform.applications.ooplugin.OpenDialog;
import org.exoplatform.applications.ooplugin.SaveDialog;
import org.exoplatform.applications.ooplugin.SearchDialog;
import org.exoplatform.applications.ooplugin.SettingsDialog;
import org.exoplatform.applications.ooplugin.WebDavConfig;
import org.exoplatform.services.log.ExoLogger;

public class AddonHandler
extends WeakBase
implements XServiceInfo,
XDispatchProvider,
XInitialization,
XDispatch {
    private static final Log log = ExoLogger.getLogger((String)"jcr.ooplugin.AddonHandler");
    public static final String MENU_OPEN = "open";
    public static final String MENU_SAVE = "save";
    public static final String MENU_SAVEAS = "saveas";
    public static final String MENU_SEARCH = "search";
    public static final String MENU_SETTINGS = "settings";
    public static final String MENU_ABOUT = "about";
    private XComponentContext xComponentContext;
    private static XFrame xFrame;
    private static XToolkit xToolkit;
    private static final String m_implementationName;
    private static WebDavConfig config;
    private static final String[] m_serviceNames;

    public AddonHandler(XComponentContext xComponentContext) {
        try {
            this.xComponentContext = xComponentContext;
            if (config == null) {
                config = new WebDavConfig();
            }
        }
        catch (Throwable thr) {
            log.info((Object)("Undandled exception: " + thr.getMessage()), thr);
        }
    }

    public static XSingleComponentFactory __getComponentFactory(String sImplementationName) {
        XSingleComponentFactory xFactory = null;
        if (sImplementationName.equals(m_implementationName)) {
            xFactory = Factory.createComponentFactory(AddonHandler.class, (String[])m_serviceNames);
        }
        return xFactory;
    }

    public static boolean __writeRegistryServiceInfo(XRegistryKey xRegistryKey) {
        try {
            return Factory.writeRegistryServiceInfo((String)m_implementationName, (String[])m_serviceNames, (XRegistryKey)xRegistryKey);
        }
        catch (Throwable thr) {
            log.info((Object)("Undandled exception: " + thr.getMessage()), thr);
            return false;
        }
    }

    public String getImplementationName() {
        return m_implementationName;
    }

    public boolean supportsService(String sService) {
        int len = m_serviceNames.length;
        for (int i = 0; i < len; ++i) {
            if (!sService.equals(m_serviceNames[i])) continue;
            return true;
        }
        return false;
    }

    public String[] getSupportedServiceNames() {
        return m_serviceNames;
    }

    public XDispatch queryDispatch(URL aURL, String sTargetFrameName, int iSearchFlags) {
        if (aURL.Protocol.compareTo("org.exoplatform.applications.ooplugin:") == 0) {
            if (aURL.Path.compareTo(MENU_OPEN) == 0) {
                return this;
            }
            if (aURL.Path.compareTo(MENU_SAVE) == 0) {
                return this;
            }
            if (aURL.Path.compareTo(MENU_SAVEAS) == 0) {
                return this;
            }
            if (aURL.Path.compareTo(MENU_SEARCH) == 0) {
                return this;
            }
            if (aURL.Path.compareTo(MENU_SETTINGS) == 0) {
                return this;
            }
            if (aURL.Path.compareTo(MENU_ABOUT) == 0) {
                return this;
            }
        }
        return null;
    }

    public XDispatch[] queryDispatches(DispatchDescriptor[] seqDescriptors) {
        log.info((Object)"public com.sun.star.frame.XDispatch[] queryDispatches(");
        int nCount = seqDescriptors.length;
        XDispatch[] seqDispatcher = new XDispatch[seqDescriptors.length];
        for (int i = 0; i < nCount; ++i) {
            seqDispatcher[i] = this.queryDispatch(seqDescriptors[i].FeatureURL, seqDescriptors[i].FrameName, seqDescriptors[i].SearchFlags);
        }
        return seqDispatcher;
    }

    public void initialize(Object[] object) throws com.sun.star.uno.Exception {
        if (object.length > 0) {
            xFrame = (XFrame)UnoRuntime.queryInterface(XFrame.class, (Object)object[0]);
        }
        xToolkit = (XToolkit)UnoRuntime.queryInterface(XToolkit.class, (Object)this.xComponentContext.getServiceManager().createInstanceWithContext("com.sun.star.awt.Toolkit", this.xComponentContext));
    }

    public void dispatch(URL aURL, PropertyValue[] aArguments) {
        try {
            if (aURL.Protocol.compareTo("org.exoplatform.applications.ooplugin:") == 0) {
                if (aURL.Path.compareTo(MENU_OPEN) == 0) {
                    OpenDialog openDialog = new OpenDialog(config, this.xComponentContext, xFrame, xToolkit);
                    openDialog.createDialog();
                    return;
                }
                if (aURL.Path.compareTo(MENU_SAVE) == 0) {
                    SaveDialog saveDialog = new SaveDialog(config, this.xComponentContext, xFrame, xToolkit, false);
                    saveDialog.createDialog();
                    return;
                }
                if (aURL.Path.compareTo(MENU_SAVEAS) == 0) {
                    SaveDialog saveDialog = new SaveDialog(config, this.xComponentContext, xFrame, xToolkit, true);
                    saveDialog.createDialog();
                    return;
                }
                if (aURL.Path.compareTo(MENU_SEARCH) == 0) {
                    SearchDialog searchDialog = new SearchDialog(config, this.xComponentContext, xFrame, xToolkit);
                    searchDialog.createDialog();
                    return;
                }
                if (aURL.Path.compareTo(MENU_SETTINGS) == 0) {
                    SettingsDialog settingsDialog = new SettingsDialog(config, this.xComponentContext, xFrame, xToolkit);
                    settingsDialog.createDialog();
                    return;
                }
                if (aURL.Path.compareTo(MENU_ABOUT) == 0) {
                    AboutDialog aboutDialog = new AboutDialog(config, this.xComponentContext, xFrame, xToolkit);
                    aboutDialog.createDialog();
                    return;
                }
            }
        }
        catch (Exception exc) {
            log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
        }
    }

    public void addStatusListener(XStatusListener xControl, URL aURL) {
    }

    public void removeStatusListener(XStatusListener xControl, URL aURL) {
    }

    public static void showMessageBox(String sTitle, String sMessage) {
        try {
            if (null != xFrame && null != xToolkit) {
                XMessageBox xMsgBox;
                WindowDescriptor aDescriptor = new WindowDescriptor();
                aDescriptor.Type = WindowClass.MODALTOP;
                aDescriptor.WindowServiceName = new String("infobox");
                aDescriptor.ParentIndex = (short)-1;
                aDescriptor.Parent = (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)xFrame.getContainerWindow());
                aDescriptor.Bounds = new Rectangle(0, 0, 300, 200);
                aDescriptor.WindowAttributes = 208;
                XWindowPeer xPeer = xToolkit.createWindow(aDescriptor);
                if (null != xPeer && null != (xMsgBox = (XMessageBox)UnoRuntime.queryInterface(XMessageBox.class, (Object)xPeer))) {
                    xMsgBox.setCaptionText(sTitle);
                    xMsgBox.setMessageText(sMessage);
                    xMsgBox.execute();
                }
            }
        }
        catch (com.sun.star.uno.Exception e) {
            log.info((Object)("Unhandled exception. " + e.getMessage()), (Throwable)e);
        }
    }

    static {
        m_implementationName = AddonHandler.class.getName();
        m_serviceNames = new String[]{"com.sun.star.frame.ProtocolHandler"};
    }
}

