/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.ooplugin;

import com.sun.star.awt.ActionEvent;
import com.sun.star.awt.XTextComponent;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.frame.XFrame;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import org.apache.commons.logging.Log;
import org.exoplatform.applications.ooplugin.PlugInDialog;
import org.exoplatform.applications.ooplugin.WebDavConfig;
import org.exoplatform.applications.ooplugin.events.ActionListener;
import org.exoplatform.applications.ooplugin.utils.WebDavUtils;
import org.exoplatform.common.http.client.HTTPConnection;
import org.exoplatform.common.http.client.HTTPResponse;
import org.exoplatform.services.log.ExoLogger;

public class SettingsDialog
extends PlugInDialog {
    private static final Log log = ExoLogger.getLogger((String)"jcr.ooplugin.PlugInDialog");
    public static final String NAME = "_SettingsDialog";
    public static final String BTN_SAVE = "btnSave";
    public static final String BTN_TEST = "btnTest";
    public static final String EDT_SERVERNAME = "edtServerName";
    public static final String EDT_PORT = "edtPort";
    public static final String EDT_SERVLET = "edtServlet";
    public static final String EDT_REPOSITORY = "edtRepository";
    public static final String EDT_WORKSPACE = "edtWorkSpace";
    public static final String EDT_USER = "edtUserName";
    public static final String EDT_PASS = "edtPassword";
    private Thread launchThread;
    private Thread enableTestButtonThread;

    public SettingsDialog(WebDavConfig config, XComponentContext xComponentContext, XFrame xFrame, XToolkit xToolkit) {
        super(config, xComponentContext, xFrame, xToolkit);
        this.dialogName = NAME;
        this.addHandler(BTN_SAVE, 1, new SaveClick());
        this.addHandler(BTN_TEST, 1, new TestClick());
        this.launchThread = new LaunchThread();
        this.launchThread.start();
    }

    private boolean isEntheredAll() {
        if ("".equals(this.getTextBoxValue(EDT_SERVERNAME))) {
            return false;
        }
        if ("".equals(this.getTextBoxValue(EDT_PORT))) {
            return false;
        }
        if ("".equals(this.getTextBoxValue(EDT_SERVLET))) {
            return false;
        }
        if ("".equals(this.getTextBoxValue(EDT_REPOSITORY))) {
            return false;
        }
        if ("".equals(this.getTextBoxValue(EDT_WORKSPACE))) {
            return false;
        }
        if ("".equals(this.getTextBoxValue(EDT_USER))) {
            return false;
        }
        return !"".equals(this.getTextBoxValue(EDT_PASS));
    }

    protected void setTextBoxValue(String componentName, String textValue) {
        XTextComponent xComboText = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)this.xControlContainer.getControl(componentName));
        xComboText.setText(textValue);
    }

    protected String getTextBoxValue(String componentName) {
        XTextComponent xComboText = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)this.xControlContainer.getControl(componentName));
        return xComboText.getText();
    }

    private class SaveClick
    extends ActionListener {
        private SaveClick() {
        }

        public void actionPerformed(ActionEvent arg0) {
            try {
                String host = SettingsDialog.this.getTextBoxValue(SettingsDialog.EDT_SERVERNAME);
                int port = new Integer(SettingsDialog.this.getTextBoxValue(SettingsDialog.EDT_PORT));
                String path = SettingsDialog.this.getTextBoxValue(SettingsDialog.EDT_SERVLET);
                String repository = SettingsDialog.this.getTextBoxValue(SettingsDialog.EDT_REPOSITORY);
                String workSpace = SettingsDialog.this.getTextBoxValue(SettingsDialog.EDT_WORKSPACE);
                String userId = SettingsDialog.this.getTextBoxValue(SettingsDialog.EDT_USER);
                String userPass = SettingsDialog.this.getTextBoxValue(SettingsDialog.EDT_PASS);
                SettingsDialog.this.config.setHost(host);
                SettingsDialog.this.config.setPort(port);
                SettingsDialog.this.config.setServlet(path);
                SettingsDialog.this.config.setRepository(repository);
                SettingsDialog.this.config.setWorkSpace(workSpace);
                SettingsDialog.this.config.setUserId(userId);
                SettingsDialog.this.config.setUserPass(userPass);
                SettingsDialog.this.config.saveConfig();
            }
            catch (Exception exc) {
                log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
                SettingsDialog.this.showMessageBox("Parameters incorrect!!!");
            }
            SettingsDialog.this.xDialog.endExecute();
        }
    }

    private class TestClick
    extends ActionListener {
        private TestClick() {
        }

        public void actionPerformed(ActionEvent arg0) {
            try {
                String host = SettingsDialog.this.getTextBoxValue(SettingsDialog.EDT_SERVERNAME);
                int port = new Integer(SettingsDialog.this.getTextBoxValue(SettingsDialog.EDT_PORT));
                String path = SettingsDialog.this.getTextBoxValue(SettingsDialog.EDT_SERVLET);
                String repository = SettingsDialog.this.getTextBoxValue(SettingsDialog.EDT_REPOSITORY);
                String workSpace = SettingsDialog.this.getTextBoxValue(SettingsDialog.EDT_WORKSPACE);
                String userId = SettingsDialog.this.getTextBoxValue(SettingsDialog.EDT_USER);
                String userPass = SettingsDialog.this.getTextBoxValue(SettingsDialog.EDT_PASS);
                WebDavConfig testConfig = SettingsDialog.this.config;
                testConfig.setHost(host);
                testConfig.setPort(port);
                testConfig.setServlet(path);
                testConfig.setRepository(repository);
                testConfig.setWorkSpace(workSpace);
                testConfig.setUserId(userId);
                testConfig.setUserPass(userPass);
                HTTPConnection connection = WebDavUtils.getAuthConnection(testConfig);
                String filePath = WebDavUtils.getFullPath(testConfig);
                HTTPResponse response = connection.Head(filePath);
                log.info((Object)"Testing connection....");
                int status = response.getStatusCode();
                if (status == 200) {
                    SettingsDialog.this.showMessageBox("Connection successful!");
                    return;
                }
            }
            catch (Exception exc) {
                log.info((Object)("Unhandled exception: " + exc.getMessage()), (Throwable)exc);
            }
            SettingsDialog.this.showMessageBox(" Can not connect to repository!");
        }
    }

    private class EnableTestButtonThread
    extends Thread {
        private EnableTestButtonThread() {
        }

        public void run() {
            try {
                while (true) {
                    Thread.sleep(100L);
                    if (SettingsDialog.this.isEntheredAll()) {
                        ((XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)SettingsDialog.this.xControlContainer.getControl(SettingsDialog.BTN_TEST))).setEnable(true);
                        ((XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)SettingsDialog.this.xControlContainer.getControl(SettingsDialog.BTN_SAVE))).setEnable(true);
                        continue;
                    }
                    ((XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)SettingsDialog.this.xControlContainer.getControl(SettingsDialog.BTN_TEST))).setEnable(false);
                    ((XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)SettingsDialog.this.xControlContainer.getControl(SettingsDialog.BTN_SAVE))).setEnable(false);
                }
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    private class LaunchThread
    extends Thread {
        private LaunchThread() {
        }

        public void run() {
            try {
                while (!SettingsDialog.this.enabled) {
                    Thread.sleep(100L);
                }
                Thread.sleep(100L);
                SettingsDialog.this.enableTestButtonThread = new EnableTestButtonThread();
                SettingsDialog.this.enableTestButtonThread.start();
                SettingsDialog.this.setTextBoxValue(SettingsDialog.EDT_SERVERNAME, SettingsDialog.this.config.getHost());
                SettingsDialog.this.setTextBoxValue(SettingsDialog.EDT_PORT, "" + SettingsDialog.this.config.getPort());
                SettingsDialog.this.setTextBoxValue(SettingsDialog.EDT_SERVLET, SettingsDialog.this.config.getServlet());
                SettingsDialog.this.setTextBoxValue(SettingsDialog.EDT_REPOSITORY, SettingsDialog.this.config.getRepository());
                SettingsDialog.this.setTextBoxValue(SettingsDialog.EDT_WORKSPACE, SettingsDialog.this.config.getWorkSpace());
                SettingsDialog.this.setTextBoxValue(SettingsDialog.EDT_USER, SettingsDialog.this.config.getUserId());
                SettingsDialog.this.setTextBoxValue(SettingsDialog.EDT_PASS, SettingsDialog.this.config.getUserPass());
            }
            catch (Exception exc) {
                log.info((Object)("Unhandled exception: " + exc.getMessage()), (Throwable)exc);
            }
        }
    }
}

