/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.ooplugin;

import com.sun.star.awt.ActionEvent;
import com.sun.star.awt.XFixedText;
import com.sun.star.awt.XListBox;
import com.sun.star.awt.XToolkit;
import com.sun.star.frame.XFrame;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.exoplatform.applications.ooplugin.PlugInDialog;
import org.exoplatform.applications.ooplugin.WebDavConfig;
import org.exoplatform.applications.ooplugin.events.ActionListener;
import org.exoplatform.frameworks.webdavclient.commands.DavReport;
import org.exoplatform.frameworks.webdavclient.documents.Multistatus;
import org.exoplatform.frameworks.webdavclient.documents.ResponseDoc;
import org.exoplatform.frameworks.webdavclient.properties.ContentLengthProp;
import org.exoplatform.frameworks.webdavclient.properties.CreationDateProp;
import org.exoplatform.frameworks.webdavclient.properties.CreatorDisplayNameProp;
import org.exoplatform.frameworks.webdavclient.properties.DisplayNameProp;
import org.exoplatform.services.log.ExoLogger;

public class ViewVersions
extends PlugInDialog {
    private static final Log log = ExoLogger.getLogger((String)"jcr.ooplugin.ViewVersions");
    private static final String DIALOG_NAME = "_ViewVersionsDialog";
    public static final String LST_VERSIONS = "lstVersions";
    public static final String LBL_TABLEHEAD = "lblTableHead";
    public static final String BTN_OPEN = "btnOpen";
    public static final int NAME_LEN = 14;
    public static final int SIZE_LEN = 24;
    public static final int CREATED_LEN = 45;
    private Thread launchThread;
    private String resourcePath = "/";
    private ArrayList<ResponseDoc> responses = new ArrayList();
    private boolean isOpened = false;

    public ViewVersions(WebDavConfig config, XComponentContext xComponentContext, XFrame xFrame, XToolkit xToolkit, String resourcePath) {
        super(config, xComponentContext, xFrame, xToolkit);
        this.dialogName = DIALOG_NAME;
        this.resourcePath = resourcePath;
        this.addHandler(LST_VERSIONS, 3, new DoSelectFileClick());
        this.addHandler(BTN_OPEN, 1, new DoSelectFileClick());
        this.launchThread = new LaunchThread();
        this.launchThread.start();
    }

    public boolean launchBeforeOpen() {
        try {
            XFixedText xLabelHead = (XFixedText)UnoRuntime.queryInterface(XFixedText.class, (Object)this.xControlContainer.getControl(LBL_TABLEHEAD));
            String headerValue = "Version Name";
            while (headerValue.length() < 14) {
                headerValue = headerValue + " ";
            }
            headerValue = headerValue + "Size";
            while (headerValue.length() < 24) {
                headerValue = headerValue + " ";
            }
            headerValue = headerValue + "Created";
            while (headerValue.length() < 45) {
                headerValue = headerValue + " ";
            }
            headerValue = headerValue + "Owner";
            xLabelHead.setText(headerValue);
        }
        catch (Exception exc) {
            log.info((Object)("Unhandled exception: " + exc.getMessage()), (Throwable)exc);
        }
        return true;
    }

    public boolean createDialogEx() throws com.sun.star.uno.Exception {
        super.createDialog();
        return this.isOpened;
    }

    private boolean doReport() throws Exception {
        DavReport davReport = new DavReport(this.config.getContext());
        davReport.setResourcePath(this.resourcePath);
        davReport.setRequiredProperty("displayname");
        davReport.setRequiredProperty("getcontentlength");
        davReport.setRequiredProperty("creationdate");
        davReport.setRequiredProperty("creator-displayname");
        davReport.setDepth(1);
        int status = davReport.execute();
        if (status != 207) {
            this.showMessageBox("Can't open version list. ErrorCode: " + status);
            return false;
        }
        Multistatus multistatus = davReport.getMultistatus();
        this.responses = multistatus.getResponses();
        Collections.sort(this.responses, new VersionComparer());
        XListBox xListBox = (XListBox)UnoRuntime.queryInterface(XListBox.class, (Object)this.xControlContainer.getControl(LST_VERSIONS));
        xListBox.removeItems((short)0, xListBox.getItemCount());
        for (int i = this.responses.size() - 1; i >= 0; --i) {
            ResponseDoc curResponse = this.responses.get(i);
            xListBox.addItem(this.formatLine(curResponse), (short)0);
        }
        return true;
    }

    private String formatLine(ResponseDoc response) {
        DisplayNameProp displayNameProperty = (DisplayNameProp)response.getProperty("displayname");
        ContentLengthProp contentLengthProperty = (ContentLengthProp)response.getProperty("getcontentlength");
        CreationDateProp creationDateProperty = (CreationDateProp)response.getProperty("creationdate");
        CreatorDisplayNameProp creatorDisplayName = (CreatorDisplayNameProp)response.getProperty("creator-displayname");
        String lineStr = displayNameProperty.getDisplayName();
        while (lineStr.length() < 14) {
            lineStr = lineStr + " ";
        }
        if (contentLengthProperty != null) {
            lineStr = lineStr + contentLengthProperty.getContentLength();
        }
        while (lineStr.length() < 24) {
            lineStr = lineStr + " ";
        }
        if (creationDateProperty != null) {
            lineStr = lineStr + creationDateProperty.getCreationDate();
        }
        while (lineStr.length() < 45) {
            lineStr = lineStr + " ";
        }
        if (creatorDisplayName != null) {
            lineStr = lineStr + creatorDisplayName.getCreatorDisplayName();
        }
        return lineStr;
    }

    protected void doOpenVersion() {
        try {
            XListBox xListBox = (XListBox)UnoRuntime.queryInterface(XListBox.class, (Object)this.xControlContainer.getControl(LST_VERSIONS));
            short selectedItem = xListBox.getSelectedItemPos();
            if (selectedItem < 0) {
                return;
            }
            ResponseDoc response = this.responses.get(selectedItem);
            String href = response.getHref();
            this.doOpenRemoteFile(href);
            this.isOpened = true;
            this.xDialog.endExecute();
        }
        catch (Exception exc) {
            log.info((Object)"Unhandled exception.", (Throwable)exc);
            this.showMessageBox("Can't open selected version.");
        }
    }

    private class DoSelectFileClick
    extends ActionListener {
        private DoSelectFileClick() {
        }

        public void actionPerformed(ActionEvent arg0) {
            ViewVersions.this.doOpenVersion();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class VersionComparer
    implements Comparator<ResponseDoc> {
        VersionComparer() {
        }

        @Override
        public int compare(ResponseDoc resp1, ResponseDoc resp2) {
            CreationDateProp creationDate1 = (CreationDateProp)resp1.getProperty("creationdate");
            CreationDateProp creationDate2 = (CreationDateProp)resp2.getProperty("creationdate");
            if (!creationDate2.getCreationDate().equals(creationDate1.getCreationDate())) {
                return creationDate2.getCreationDate().compareToIgnoreCase(creationDate1.getCreationDate());
            }
            DisplayNameProp displayName1 = (DisplayNameProp)resp1.getProperty("displayname");
            DisplayNameProp displayName2 = (DisplayNameProp)resp2.getProperty("displayname");
            return displayName2.getDisplayName().compareToIgnoreCase(displayName1.getDisplayName());
        }
    }

    private class LaunchThread
    extends Thread {
        private LaunchThread() {
        }

        public void run() {
            try {
                while (!ViewVersions.this.enabled) {
                    Thread.sleep(100L);
                }
                Thread.sleep(100L);
                ViewVersions.this.doReport();
            }
            catch (Exception exc) {
                log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
            }
        }
    }
}

