/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.ooplugin.config;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.exoplatform.applications.ooplugin.XmlUtil;
import org.exoplatform.applications.ooplugin.config.FilterType;
import org.exoplatform.applications.ooplugin.config.XmlConfig;
import org.exoplatform.services.log.ExoLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterListLoader
extends XmlConfig {
    private static final Log log = ExoLogger.getLogger((String)"jcr.ooplugin.FilterListLoader");
    public static final String FILTERLIST_CONFIG = "/config/filterlist.xml";
    public static final String XML_FILTERLIST = "filter-list";
    public static final String XML_FILTERGROUP = "filter-group";
    public static final String XML_DOCUMENTNAME = "document-name";
    public static final String XML_FILTERS = "filters";
    private ArrayList<FilterType> loadedFilters = new ArrayList();

    public FilterListLoader() {
        try {
            Document document = this.getDocumentFromResource(FILTERLIST_CONFIG);
            Node rootNode = this.getChildNode(document, XML_FILTERLIST);
            NodeList fileTypes = rootNode.getChildNodes();
            for (int i = 0; i < fileTypes.getLength(); ++i) {
                Node fileType = fileTypes.item(i);
                if (fileType.getLocalName() == null || !XML_FILTERGROUP.equals(fileType.getLocalName())) continue;
                this.readFilterGroup(fileType);
            }
        }
        catch (Exception exc) {
            log.info((Object)"Unhandled exception ", (Throwable)exc);
        }
    }

    protected void readFilterGroup(Node groopNode) throws Exception {
        Node documentNameNode = XmlUtil.getChildNode(groopNode, XML_DOCUMENTNAME);
        String documentName = documentNameNode.getTextContent();
        Node filtersNode = XmlUtil.getChildNode(groopNode, XML_FILTERS);
        NodeList filters = filtersNode.getChildNodes();
        for (int i = 0; i < filters.getLength(); ++i) {
            Node filterNode = filters.item(i);
            if (filterNode.getLocalName() == null) continue;
            FilterType filter = new FilterType(filterNode, documentName);
            this.loadedFilters.add(filter);
        }
    }

    public ArrayList<FilterType> getFilterTypes(String groupName) {
        ArrayList<FilterType> types = new ArrayList<FilterType>();
        for (int i = 0; i < this.loadedFilters.size(); ++i) {
            FilterType curType = this.loadedFilters.get(i);
            if (!groupName.equals(curType.getDocumentName())) continue;
            types.add(curType);
        }
        return types;
    }

    public ArrayList<FilterType> getAllFilters() {
        return this.loadedFilters;
    }
}

