/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.repoload;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Node;
import org.exoplatform.applications.repoload.DataUploader;

public class DataUploaderAPI
extends DataUploader {
    protected boolean setFile;

    public DataUploaderAPI(String[] args) {
        super(args);
    }

    public void uploadDataAPI() throws Exception {
        int[] tree = this.getTree((String)this.mapConfig.get("-tree"));
        this.log.info((Object)">>>>>>>>>>>---------- Upload data ----------<<<<<<<<<<<<");
        this.sName = "node";
        this.sFile = "file";
        this.date = Calendar.getInstance();
        this.setFile = !this.sVdfile.equals("");
        this.countNodes = 0;
        long start = System.currentTimeMillis();
        for (int i = 1; i <= tree[0]; ++i) {
            try {
                Node nodeData_L1 = this.rootTestNode.addNode(this.sName + i, "nt:folder");
                for (int j = 1; j <= tree[1]; ++j) {
                    Node nodeData_L2 = nodeData_L1.addNode(this.sName + j, "nt:folder");
                    long localStart = System.currentTimeMillis();
                    for (int k = 1; k <= tree[2]; ++k) {
                        Node nodeData_L3 = nodeData_L2.addNode(this.sName + k, "nt:folder");
                        for (int index = 1; index <= tree[3]; ++index) {
                            this.addNode_file(this.sFile + index, nodeData_L3, this.date);
                            ++this.countNodes;
                        }
                        this.session.save();
                        this.log.info((Object)("Node " + i + " - " + j + " - " + k + " - " + "[1..." + tree[3] + "] add"));
                    }
                    long localEnd = System.currentTimeMillis();
                    this.log.info((Object)("\tThe time of adding of " + tree[2] * tree[3] + " nodes: " + (double)(localEnd - localStart) / 1000.0 + " sec"));
                    this.log.info((Object)("\tTotal adding time " + this.countNodes + " nodes: " + (double)(localEnd - start) / 1000.0 + " sec"));
                }
                continue;
            }
            catch (Exception e) {
                this.connection.rollback();
                this.log.error((Object)">>>>>>>>>>>---------- Upload data Exception ----------<<<<<<<<<<<<", (Throwable)e);
            }
        }
        long end = System.currentTimeMillis();
        this.log.info((Object)("The time of the adding of " + this.countNodes + " nodes: " + (double)(end - start) / 1000.0 + " sec"));
    }

    protected void addNode_file(String name, Node parentNode, Calendar ddate) throws Exception {
        Node nodeFile = parentNode.addNode(name, "nt:file");
        Node contentNode = nodeFile.addNode("jcr:content", "nt:resource");
        if (this.setFile) {
            contentNode.setProperty("jcr:data", (InputStream)new FileInputStream(this.sVdfile));
        } else {
            contentNode.setProperty("jcr:data", (InputStream)new ByteArrayInputStream("".getBytes()));
        }
        contentNode.setProperty("jcr:mimeType", this.sMimeType);
        contentNode.setProperty("jcr:lastModified", ddate);
    }
}

