/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.repoload;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Calendar;
import org.exoplatform.applications.repoload.DataUploader;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.storage.WorkspaceDataContainerBase;

public class DataUploaderTh
extends DataUploader
implements Runnable {
    private int nodeNumber;
    private long start = 0L;
    private long end = 0L;
    private long uploadTime = 0L;
    private WorkspaceDataContainerBase wsDataContainer;

    public DataUploaderTh(String[] args, WorkspaceDataContainerBase wsDataContainer, NodeImpl parentNode, int nodeNumber) {
        super(args);
        this.nodeNumber = nodeNumber;
        this.workspaceDataContainer = wsDataContainer;
        this.rootTestNode = parentNode;
        try {
            this.connection = this.getConnection();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.sConf = (String)this.mapConfig.get("-conf");
        this.sRepository = (String)this.mapConfig.get("-repo");
        this.sWorkspace = (String)this.mapConfig.get("-ws");
        this.sRoot = (String)this.mapConfig.get("-root");
        this.sVdfile = (String)this.mapConfig.get("-vdfile");
        this.sReadTree = (String)this.mapConfig.get("-readtree");
        try {
            this.fileData = new TransientValueData((InputStream)new FileInputStream(this.sVdfile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void run() {
        int[] tree = this.getTree((String)this.mapConfig.get("-tree"));
        System.out.println(">>>>>>>>>>>---------- Upload data ----------<<<<<<<<<<<<");
        this.sName = "folder";
        this.sFile = "file";
        this.date = Calendar.getInstance();
        this.countNodes = 1 * tree[1] * tree[2] * tree[3];
        this.start = System.currentTimeMillis();
        int i = this.nodeNumber;
        try {
            TransientNodeData nodeData_L1 = this.addNode(this.connection, this.sName + i, i, this.rootTestNode, this.date);
            for (int j = 1; j <= tree[1]; ++j) {
                TransientNodeData nodeData_L2 = this.addNode(this.connection, this.sName + j, j, nodeData_L1, this.date);
                for (int k = 1; k <= tree[2]; ++k) {
                    TransientNodeData nodeData_L3 = this.addNode(this.connection, this.sName + k, k, nodeData_L2, this.date);
                    for (int index = 1; index <= tree[3]; ++index) {
                        this.addNode_file(this.connection, this.sFile + index, index, nodeData_L3, this.date, this.fileData);
                    }
                    this.connection.commit();
                    this.connection = this.getConnection();
                    System.out.println("Node " + i + " - " + j + " - " + k + " - " + "[1..." + tree[3] + "] add");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.connection.rollback();
            }
            catch (Exception e1) {
                e1.printStackTrace();
                System.out.println("Error: Rollback Exception");
            }
            System.out.println(">>>>>>>>>>>---------- Upload data Exception ----------<<<<<<<<<<<<");
        }
        this.end = System.currentTimeMillis();
        this.uploadTime = this.end - this.start;
        System.out.println("The time of the adding of " + this.countNodes + " nodes: " + (double)this.uploadTime / 1000.0 + " sec");
    }
}

