/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.dataflow.TransientItemData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SessionChangesLog
extends PlainChangesLogImpl {
    protected Map<Object, ItemState> index = new HashMap<Object, ItemState>();
    protected Map<String, Map<String, ItemState>> lastChildNodeStates = new HashMap<String, Map<String, ItemState>>();
    protected Map<String, Map<String, ItemState>> lastChildPropertyStates = new HashMap<String, Map<String, ItemState>>();
    protected Map<String, Integer> childNodesCount = new HashMap<String, Integer>();

    public SessionChangesLog(String sessionId) {
        super(sessionId);
    }

    public SessionChangesLog(List<ItemState> items, String sessionId) {
        super(items, sessionId);
        for (ItemState change : items) {
            this.addItem(change);
        }
    }

    @Override
    public PlainChangesLog add(ItemState change) {
        super.add(change);
        this.addItem(change);
        return this;
    }

    @Override
    public PlainChangesLog addAll(List<ItemState> changes) {
        super.addAll(changes);
        for (ItemState change : changes) {
            this.addItem(change);
        }
        return this;
    }

    @Override
    public void clear() {
        super.clear();
        this.index.clear();
        this.lastChildNodeStates.clear();
        this.lastChildPropertyStates.clear();
        this.childNodesCount.clear();
    }

    public void remove(QPath rootPath) {
        for (int i = this.items.size() - 1; i >= 0; --i) {
            Map<String, ItemState> children;
            Integer childCount;
            ItemState item = (ItemState)this.items.get(i);
            QPath qPath = item.getData().getQPath();
            if (!qPath.isDescendantOf(rootPath) && !item.getAncestorToSave().isDescendantOf(rootPath) && !item.getAncestorToSave().equals(rootPath) && !qPath.equals(rootPath)) continue;
            this.items.remove(i);
            this.index.remove(item.getData().getIdentifier());
            this.index.remove(item.getData().getQPath());
            this.index.remove(new ParentIDQPathBasedKey(item));
            this.index.remove(new IDStateBasedKey(item.getData().getIdentifier(), item.getState()));
            this.childNodesCount.remove(item.getData().getIdentifier());
            this.lastChildNodeStates.remove(item.getData().getIdentifier());
            this.lastChildPropertyStates.remove(item.getData().getIdentifier());
            if (item.isNode() && item.isPersisted() && (childCount = this.childNodesCount.get(item.getData().getParentIdentifier())) != null) {
                if (item.isDeleted()) {
                    childCount = childCount + 1;
                } else if (item.isAdded()) {
                    childCount = childCount - 1;
                }
                this.childNodesCount.put(item.getData().getParentIdentifier(), childCount);
            }
            if (item.getData().isNode()) {
                children = this.lastChildNodeStates.get(item.getData().getParentIdentifier());
                if (children == null) continue;
                children.remove(item.getData().getIdentifier());
                continue;
            }
            children = this.lastChildPropertyStates.get(item.getData().getParentIdentifier());
            if (children == null) continue;
            children.remove(item.getData().getIdentifier());
        }
    }

    public List<ItemState> getDescendantsChanges(String rootIdentifier) {
        ArrayList<ItemState> changesList = new ArrayList<ItemState>();
        this.traverseChangesByIdentifier(rootIdentifier, changesList);
        return changesList;
    }

    private void traverseChangesByIdentifier(String identifier, List<ItemState> changesList) {
        for (ItemState item : this.items) {
            if (item.getData().getIdentifier().equals(identifier)) {
                changesList.add(item);
                continue;
            }
            if (!item.getData().getParentIdentifier().equals(identifier)) continue;
            this.traverseChangesByIdentifier(item.getData().getIdentifier(), changesList);
        }
    }

    public void eraseEventFire(String identifier) {
        for (ItemState item : this.items) {
            if (item.getData().getIdentifier().equals(identifier)) {
                item.eraseEventFire();
                continue;
            }
            if (!item.getData().getParentIdentifier().equals(identifier)) continue;
            this.eraseEventFire(item.getData().getIdentifier());
        }
    }

    public List<ItemState> getDescendantsChanges(QPath rootPath) {
        ArrayList<ItemState> list = new ArrayList<ItemState>();
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((ItemState)this.items.get(i)).isDescendantOf(rootPath)) continue;
            list.add((ItemState)this.items.get(i));
        }
        return list;
    }

    public List<ItemState> getItemStates(String itemIdentifier) {
        ArrayList<ItemState> states = new ArrayList<ItemState>();
        for (ItemState state : this.getAllStates()) {
            if (!state.getData().getIdentifier().equals(itemIdentifier)) continue;
            states.add(state);
        }
        return states;
    }

    public PlainChangesLog pushLog(QPath rootPath) {
        PlainChangesLogImpl cLog = new PlainChangesLogImpl(this.sessionId);
        if (rootPath.equals(Constants.ROOT_PATH)) {
            cLog.addAll(this.items);
            this.clear();
        } else {
            cLog.addAll(this.getDescendantsChanges(rootPath));
            this.remove(rootPath);
        }
        return cLog;
    }

    public ItemState getItemState(NodeData parentData, QPathEntry name) throws IllegalPathException {
        return this.index.get(new ParentIDQPathBasedKey(parentData.getIdentifier(), name));
    }

    public ItemState getItemState(String itemIdentifier) {
        return this.index.get(itemIdentifier);
    }

    public ItemState getItemState(QPath itemPath) {
        return this.index.get(itemPath);
    }

    public ItemState getItemState(String itemIdentifier, int state) {
        return this.index.get(new IDStateBasedKey(itemIdentifier, state));
    }

    public List<ItemState> getChildrenChanges(String rootIdentifier) {
        ArrayList<ItemState> list = new ArrayList<ItemState>();
        for (int i = 0; i < this.items.size(); ++i) {
            ItemData item = ((ItemState)this.items.get(i)).getData();
            if (!item.getParentIdentifier().equals(rootIdentifier) && !item.getIdentifier().equals(rootIdentifier)) continue;
            list.add((ItemState)this.items.get(i));
        }
        return list;
    }

    public int getChildNodesCount(String rootIdentifier) {
        Integer childCount = this.childNodesCount.get(rootIdentifier);
        return childCount == null ? 0 : childCount;
    }

    public Collection<ItemState> getLastChildrenStates(ItemData rootData, boolean forNodes) {
        Map<String, ItemState> children = forNodes ? this.lastChildNodeStates.get(rootData.getIdentifier()) : this.lastChildPropertyStates.get(rootData.getIdentifier());
        return children == null ? new ArrayList() : children.values();
    }

    public Collection<ItemState> getLastModifyStates(NodeData rootData) {
        HashMap changes = new HashMap();
        for (int i = 0; i < this.items.size(); ++i) {
            TransientItemData item = (TransientItemData)((ItemState)this.items.get(i)).getData();
            if (item.getIdentifier().equals(rootData.getIdentifier())) {
                if (((ItemState)this.items.get(i)).isAdded()) {
                    return new ArrayList<ItemState>();
                }
                if (((ItemState)this.items.get(i)).isDeleted()) continue;
                changes.put(item.getIdentifier(), this.items.get(i));
                continue;
            }
            if (!item.getParentIdentifier().equals(rootData.getIdentifier())) continue;
            changes.put(item.getIdentifier(), this.items.get(i));
        }
        return changes.values();
    }

    public ItemState[] findRenamed(QPath deletedPath) throws IllegalPathException {
        List<ItemState> allStates = this.getAllStates();
        for (int i = allStates.size() - 1; i >= 0; --i) {
            ItemState state = allStates.get(i);
            if (state.getState() != 4 || state.isPersisted() || !deletedPath.isDescendantOf(state.getData().getQPath()) && !deletedPath.equals(state.getData().getQPath())) continue;
            try {
                ItemState delete = state;
                ItemState rename = allStates.get(i + 1);
                if (rename.getState() != 32 || !rename.isPersisted() || !rename.getData().getIdentifier().equals(delete.getData().getIdentifier())) continue;
                for (int bi = allStates.size() - 1; bi >= i + 2; --bi) {
                    state = allStates.get(bi);
                    if (state.getState() != 32 || !state.isPersisted() || !state.getData().getIdentifier().equals(rename.getData().getIdentifier())) continue;
                    rename = state;
                    delete = allStates.get(i - 1);
                    if (!delete.getData().getIdentifier().equals(rename.getData().getIdentifier())) continue;
                    return new ItemState[]{delete, rename};
                }
                return new ItemState[]{delete, rename};
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
        return null;
    }

    public ItemState findItemState(QPath rootPath, Boolean isPersisted, Boolean orAncestor, int ... states) throws IllegalPathException {
        List<ItemState> allStates = this.getAllStates();
        for (int i = allStates.size() - 1; i >= 0; --i) {
            ItemState istate = allStates.get(i);
            boolean byState = false;
            if (states != null) {
                for (int state : states) {
                    if (istate.getState() != state) continue;
                    byState = true;
                    break;
                }
            } else {
                byState = true;
            }
            if (!byState || isPersisted != null && istate.isPersisted() != isPersisted.booleanValue() || orAncestor != null && orAncestor.booleanValue() && !rootPath.isDescendantOf(istate.getData().getQPath()) && !rootPath.equals(istate.getData().getQPath())) continue;
            return istate;
        }
        return null;
    }

    public ItemState findItemState(String id, Boolean isPersisted, int ... states) throws IllegalPathException {
        List<ItemState> allStates = this.getAllStates();
        for (int i = allStates.size() - 1; i >= 0; --i) {
            ItemState istate = allStates.get(i);
            boolean byState = false;
            if (states != null) {
                for (int state : states) {
                    if (istate.getState() != state) continue;
                    byState = true;
                    break;
                }
            } else {
                byState = true;
            }
            if (!byState || isPersisted != null && istate.isPersisted() != isPersisted.booleanValue() || !istate.getData().getIdentifier().equals(id)) continue;
            return istate;
        }
        return null;
    }

    private void addItem(ItemState item) {
        Map<String, ItemState> children;
        this.index.put(item.getData().getIdentifier(), item);
        this.index.put(item.getData().getQPath(), item);
        this.index.put(new ParentIDQPathBasedKey(item), item);
        this.index.put(new IDStateBasedKey(item.getData().getIdentifier(), item.getState()), item);
        if (item.getData().isNode()) {
            children = this.lastChildNodeStates.get(item.getData().getParentIdentifier());
            if (children == null) {
                children = new HashMap<String, ItemState>();
                this.lastChildNodeStates.put(item.getData().getParentIdentifier(), children);
            }
            children.put(item.getData().getIdentifier(), item);
        } else {
            children = this.lastChildPropertyStates.get(item.getData().getParentIdentifier());
            if (children == null) {
                children = new HashMap<String, ItemState>();
                this.lastChildPropertyStates.put(item.getData().getParentIdentifier(), children);
            }
            children.put(item.getData().getIdentifier(), item);
        }
        if (item.isNode() && item.isPersisted()) {
            Integer childCount = this.childNodesCount.get(item.getData().getParentIdentifier());
            if (childCount == null) {
                childCount = 0;
            }
            if (item.isDeleted()) {
                childCount = childCount - 1;
            } else if (item.isAdded()) {
                childCount = childCount + 1;
            }
            this.childNodesCount.put(item.getData().getParentIdentifier(), childCount);
        }
    }

    private class ParentIDQPathBasedKey {
        private final QPathEntry name;
        private final String parentIdentifier;

        ParentIDQPathBasedKey(ItemState item) {
            this.name = item.getData().getQPath().getEntries()[item.getData().getQPath().getEntries().length - 1];
            this.parentIdentifier = item.getData().getParentIdentifier();
        }

        ParentIDQPathBasedKey(String parentIdentifier, QPathEntry name) {
            this.name = name;
            this.parentIdentifier = parentIdentifier;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.name.getName().hashCode();
            result = 31 * result + this.name.getNamespace().hashCode();
            result = 31 * result + this.name.getIndex();
            result = 31 * result + (this.parentIdentifier == null ? 0 : this.parentIdentifier.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ParentIDQPathBasedKey other = (ParentIDQPathBasedKey)obj;
            if (this.name == null ? other.name != null : !this.name.getName().equals(other.name.getName()) || !this.name.getNamespace().equals(other.name.getNamespace()) || this.name.getIndex() != other.name.getIndex()) {
                return false;
            }
            return !(this.parentIdentifier == null ? other.parentIdentifier != null : !this.parentIdentifier.equals(other.parentIdentifier));
        }
    }

    private class IDStateBasedKey {
        private final String identifier;
        private final int state;

        IDStateBasedKey(String identifier, int state) {
            this.identifier = identifier;
            this.state = state;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.identifier.hashCode();
            result = 31 * result + this.state;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IDStateBasedKey other = (IDStateBasedKey)obj;
            if (this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier)) {
                return false;
            }
            return this.state == other.state;
        }
    }
}

