/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.exoplatform.services.cache.CacheListener;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.services.jcr.config.CacheEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.WorkspaceStorageCache;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheQPath;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class WorkspaceStorageCacheImpl
implements WorkspaceStorageCache {
    public static int MAX_CACHE_SIZE = 200;
    public static long MAX_CACHE_LIVETIME = 600L;
    protected static Log log = ExoLogger.getLogger((String)"jcr.WorkspaceStorageCacheImpl");
    protected Log info = ExoLogger.getLogger((String)"jcr.WorkspaceStorageCacheImplINFO");
    private final ExoCache cache;
    private final WeakHashMap<String, List<NodeData>> nodesCache;
    private final WeakHashMap<String, List<PropertyData>> propertiesCache;
    private final String name;
    private boolean enabled;
    private Timer debugInformer;

    public WorkspaceStorageCacheImpl(CacheService cacheService, WorkspaceEntry wsConfig) throws Exception {
        this.name = "jcr." + wsConfig.getUniqueName();
        this.cache = cacheService.getCacheInstance(this.name);
        CacheEntry cacheConfig = wsConfig.getCache();
        if (cacheConfig != null) {
            long liveTime;
            int maxSize;
            this.enabled = cacheConfig.isEnabled();
            try {
                maxSize = cacheConfig.getParameterInteger("max-size");
            }
            catch (RepositoryConfigurationException e) {
                maxSize = cacheConfig.getParameterInteger("maxSize");
            }
            this.cache.setMaxSize(maxSize);
            this.nodesCache = new WeakHashMap(maxSize);
            this.propertiesCache = new WeakHashMap(maxSize);
            try {
                liveTime = cacheConfig.getParameterTime("live-time");
            }
            catch (RepositoryConfigurationException e) {
                liveTime = cacheConfig.getParameterTime("liveTime");
            }
            this.cache.setLiveTime(liveTime);
        } else {
            this.cache.setMaxSize(MAX_CACHE_SIZE);
            this.cache.setLiveTime(MAX_CACHE_LIVETIME);
            this.nodesCache = new WeakHashMap();
            this.propertiesCache = new WeakHashMap();
            this.enabled = true;
        }
        this.cache.addCacheListener((CacheListener)new ExpiredListener());
        if (this.info.isDebugEnabled()) {
            this.debugInformer = new Timer(this.name);
            TimerTask informerTask = new TimerTask(){

                public void run() {
                    try {
                        int childNodes = 0;
                        try {
                            for (Map.Entry ne : WorkspaceStorageCacheImpl.this.nodesCache.entrySet()) {
                                childNodes += ((List)ne.getValue()).size();
                            }
                        }
                        catch (ConcurrentModificationException e) {
                            childNodes = -1;
                        }
                        int childProperties = 0;
                        try {
                            for (Map.Entry pe : WorkspaceStorageCacheImpl.this.propertiesCache.entrySet()) {
                                childProperties += ((List)pe.getValue()).size();
                            }
                        }
                        catch (ConcurrentModificationException e) {
                            childProperties = -1;
                        }
                        WorkspaceStorageCacheImpl.this.info.info((Object)("C " + WorkspaceStorageCacheImpl.this.cache.getCacheSize() + ", CN " + WorkspaceStorageCacheImpl.this.nodesCache.size() + "/" + (childNodes < 0 ? "?" : Integer.valueOf(childNodes)) + ", CP " + WorkspaceStorageCacheImpl.this.propertiesCache.size() + "/" + (childProperties < 0 ? "?" : Integer.valueOf(childProperties))));
                    }
                    catch (Throwable e) {
                        WorkspaceStorageCacheImpl.this.info.error((Object)("Debug informer task error " + e));
                    }
                }
            };
            Calendar firstTime = Calendar.getInstance();
            firstTime.add(13, 5);
            this.debugInformer.schedule(informerTask, firstTime.getTime(), 10000L);
        }
    }

    @Override
    public long getSize() {
        return this.cache.getCacheSize();
    }

    @Override
    public ItemData get(String identifier) {
        if (!this.enabled) {
            return null;
        }
        try {
            return this.getItem(identifier);
        }
        catch (Exception e) {
            log.error((Object)("GET operation fails. Item ID=" + identifier + ". Error " + e + ". NULL returned."), (Throwable)e);
            return null;
        }
    }

    @Override
    public ItemData get(String parentId, QPathEntry name) {
        if (!this.enabled) {
            return null;
        }
        try {
            return this.getItem(parentId, name);
        }
        catch (Exception e) {
            log.error((Object)("GET operation fails. Parent ID=" + parentId + " name " + (name != null ? name.getAsString() : name) + ". Error " + e + ". NULL returned."), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(ItemData data) {
        block24: {
            try {
                if (!this.enabled || data == null) break block24;
                this.putItem(data);
                if (data.isNode()) {
                    List<NodeData> cachedParentChilds = this.nodesCache.get(data.getParentIdentifier());
                    if (cachedParentChilds == null) break block24;
                    NodeData nodeData = (NodeData)data;
                    int orderNumber = nodeData.getOrderNumber();
                    List<NodeData> list = cachedParentChilds;
                    synchronized (list) {
                        int index = cachedParentChilds.indexOf(nodeData);
                        if (index >= 0) {
                            if (orderNumber != cachedParentChilds.get(index).getOrderNumber()) {
                                ArrayList<NodeData> newChilds = new ArrayList<NodeData>(cachedParentChilds.size());
                                for (int ci = 0; ci < cachedParentChilds.size(); ++ci) {
                                    if (index == ci) {
                                        newChilds.add(nodeData);
                                        continue;
                                    }
                                    newChilds.add(cachedParentChilds.get(ci));
                                }
                                this.nodesCache.put(data.getParentIdentifier(), newChilds);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)(this.name + ", put()    update child node  " + nodeData.getIdentifier() + "  order #" + orderNumber));
                                }
                            } else {
                                cachedParentChilds.set(index, nodeData);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)(this.name + ", put()    update child node  " + nodeData.getIdentifier() + "  at index #" + index));
                                }
                            }
                        } else {
                            ArrayList<NodeData> newChilds = new ArrayList<NodeData>(cachedParentChilds.size() + 1);
                            for (int ci = 0; ci < cachedParentChilds.size(); ++ci) {
                                newChilds.add(cachedParentChilds.get(ci));
                            }
                            newChilds.add(nodeData);
                            this.nodesCache.put(data.getParentIdentifier(), newChilds);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)(this.name + ", put()    add child node  " + nodeData.getIdentifier()));
                            }
                        }
                        break block24;
                    }
                }
                List<PropertyData> cachedParentChilds = this.propertiesCache.get(data.getParentIdentifier());
                if (cachedParentChilds == null) break block24;
                List<PropertyData> list = cachedParentChilds;
                synchronized (list) {
                    int index = cachedParentChilds.indexOf(data);
                    if (index >= 0) {
                        cachedParentChilds.set(index, (PropertyData)data);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(this.name + ", put()    update child property  " + data.getIdentifier() + "  at index #" + index));
                        }
                    } else {
                        ArrayList<PropertyData> newChilds = new ArrayList<PropertyData>(cachedParentChilds.size() + 1);
                        for (int ci = 0; ci < cachedParentChilds.size(); ++ci) {
                            newChilds.add(cachedParentChilds.get(ci));
                        }
                        newChilds.add((PropertyData)data);
                        this.propertiesCache.put(data.getParentIdentifier(), newChilds);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(this.name + ", put()    add child property  " + data.getIdentifier()));
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)(this.name + ", Error put item data in cache: " + (data != null ? data.getQPath().getAsString() : "[null]")), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildProperties(NodeData parentData, List<PropertyData> childItems) {
        if (this.enabled && parentData != null && childItems != null) {
            String logInfo = null;
            if (log.isDebugEnabled()) {
                logInfo = "parent:   " + parentData.getQPath().getAsString() + "    " + parentData.getIdentifier() + " " + childItems.size();
                log.debug((Object)(this.name + ", addChildProperties() >>> " + logInfo));
            }
            String parentIdentifier = parentData.getIdentifier();
            String operName = "";
            try {
                List<PropertyData> cp;
                operName = "removing parent";
                this.removeDeep(parentData, false);
                operName = "caching parent";
                this.putItem(parentData);
                List<PropertyData> list = cp = childItems;
                synchronized (list) {
                    WeakHashMap<String, List<PropertyData>> weakHashMap = this.propertiesCache;
                    synchronized (weakHashMap) {
                        operName = "removing child properties";
                        this.removeChildProperties(parentIdentifier);
                        operName = "caching child properties list";
                        this.propertiesCache.put(parentIdentifier, cp);
                    }
                    operName = "caching child properties";
                    this.putItems(cp);
                }
            }
            catch (Exception e) {
                log.error((Object)(this.name + ", Error in addChildProperties() " + operName + ": parent " + (parentData != null ? parentData.getQPath().getAsString() : "[null]")), (Throwable)e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.name + ", addChildProperties() <<< " + logInfo));
            }
        }
    }

    @Override
    public void addChildPropertiesList(NodeData parentData, List<PropertyData> childItems) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildNodes(NodeData parentData, List<NodeData> childItems) {
        if (this.enabled && parentData != null && childItems != null) {
            String logInfo = null;
            if (log.isDebugEnabled()) {
                logInfo = "parent:   " + parentData.getQPath().getAsString() + "    " + parentData.getIdentifier() + " " + childItems.size();
                log.debug((Object)(this.name + ", addChildNodes() >>> " + logInfo));
            }
            String parentIdentifier = parentData.getIdentifier();
            String operName = "";
            try {
                List<NodeData> cn;
                operName = "removing parent";
                this.removeDeep(parentData, false);
                operName = "caching parent";
                this.putItem(parentData);
                List<NodeData> list = cn = childItems;
                synchronized (list) {
                    WeakHashMap<String, List<NodeData>> weakHashMap = this.nodesCache;
                    synchronized (weakHashMap) {
                        operName = "removing child nodes";
                        List<NodeData> removedChildNodes = this.removeChildNodes(parentIdentifier, false);
                        if (removedChildNodes != null && removedChildNodes.size() > 0) {
                            operName = "search for stale child nodes not contains in the new list of childs";
                            ArrayList<NodeData> forRemove = new ArrayList<NodeData>();
                            for (NodeData removedChildNode : removedChildNodes) {
                                if (cn.contains(removedChildNode)) continue;
                                forRemove.add(removedChildNode);
                            }
                            if (forRemove.size() > 0) {
                                operName = "removing stale child nodes not contains in the new list of childs";
                                WeakHashMap<String, List<PropertyData>> weakHashMap2 = this.propertiesCache;
                                synchronized (weakHashMap2) {
                                    for (NodeData removedChildNode : forRemove) {
                                        this.removeDeep(removedChildNode, true);
                                    }
                                }
                            }
                        }
                        operName = "caching child nodes list";
                        this.nodesCache.put(parentIdentifier, cn);
                    }
                    operName = "caching child nodes";
                    this.putItems(cn);
                }
            }
            catch (Exception e) {
                log.error((Object)(this.name + ", Error in addChildNodes() " + operName + ": parent " + (parentData != null ? parentData.getQPath().getAsString() : "[null]")), (Throwable)e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.name + ", addChildNodes() <<< " + logInfo));
            }
        }
    }

    protected void putItem(ItemData data) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.name + ", putItem()    " + data.getQPath().getAsString() + "    " + data.getIdentifier() + "  --  " + data));
        }
        this.cache.put((Serializable)((Object)data.getIdentifier()), (Object)data);
        this.cache.put((Serializable)new CacheQPath(data.getParentIdentifier(), data.getQPath()), (Object)data);
    }

    protected ItemData getItem(String identifier) throws Exception {
        ItemData c = (ItemData)this.cache.get((Serializable)((Object)identifier));
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.name + ", getItem() " + identifier + " --> " + (c != null ? c.getQPath().getAsString() + " parent:" + c.getParentIdentifier() : "[null]")));
        }
        return c;
    }

    protected ItemData getItem(String parentUuid, QPathEntry qname) throws Exception {
        ItemData c = (ItemData)this.cache.get((Serializable)new CacheQPath(parentUuid, qname));
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.name + ", getItem() " + (c != null ? c.getQPath().getAsString() : "[null]") + " --> " + (c != null ? c.getIdentifier() + " parent:" + c.getParentIdentifier() : "[null]")));
        }
        return c;
    }

    protected void putItems(List<? extends ItemData> itemsList) throws Exception {
        LinkedHashMap<Object, ItemData> subMap = new LinkedHashMap<Object, ItemData>();
        for (ItemData itemData : itemsList) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.name + ", putItems()    " + itemData.getQPath().getAsString() + "    " + itemData.getIdentifier() + "  --  " + itemData));
            }
            subMap.put(itemData.getIdentifier(), itemData);
            subMap.put(new CacheQPath(itemData.getParentIdentifier(), itemData.getQPath()), itemData);
        }
        this.cache.putMap(subMap);
    }

    @Override
    public List<NodeData> getChildNodes(NodeData parentData) {
        if (!this.enabled) {
            return null;
        }
        try {
            List<NodeData> cn = this.nodesCache.get(parentData.getIdentifier());
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.name + ", getChildNodes() " + parentData.getQPath().getAsString() + " " + parentData.getIdentifier()));
                StringBuffer blog = new StringBuffer();
                if (cn != null) {
                    blog.append("\n");
                    for (NodeData nd : cn) {
                        blog.append("\t\t" + nd.getQPath().getAsString() + " " + nd.getIdentifier() + "\n");
                    }
                    log.debug((Object)("\t-->" + blog.toString()));
                } else {
                    log.debug((Object)"\t--> null");
                }
            }
            return cn;
        }
        catch (Exception e) {
            log.error((Object)(this.name + ", Error in getChildNodes() parentData: " + (parentData != null ? parentData.getQPath().getAsString() : "[null]")), (Throwable)e);
            return null;
        }
    }

    @Override
    public List<PropertyData> getChildProperties(NodeData parentData) {
        if (this.enabled && parentData != null) {
            try {
                List<PropertyData> cp = this.propertiesCache.get(parentData.getIdentifier());
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.name + ", getChildProperties() " + parentData.getQPath().getAsString() + " " + parentData.getIdentifier()));
                    StringBuffer blog = new StringBuffer();
                    if (cp != null) {
                        blog.append("\n");
                        for (PropertyData pd : cp) {
                            blog.append("\t\t" + pd.getQPath().getAsString() + " " + pd.getIdentifier() + "\n");
                        }
                        log.debug((Object)("\t--> " + blog.toString()));
                    } else {
                        log.debug((Object)"\t--> null");
                    }
                }
                return cp;
            }
            catch (Exception e) {
                log.error((Object)(this.name + ", Error in getChildProperties() parentData: " + (parentData != null ? parentData.getQPath().getAsString() : "[null]")), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public List<PropertyData> listChildProperties(NodeData parentData) {
        return this.getChildProperties(parentData);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setMaxSize(int maxSize) {
        this.cache.setMaxSize(maxSize);
    }

    public void setLiveTime(long liveTime) {
        this.cache.setLiveTime(liveTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadProperty(PropertyData property) throws Exception {
        try {
            block4: {
                try {
                    ItemData parent = (ItemData)this.cache.get((Serializable)((Object)property.getParentIdentifier()));
                    if (parent == null) break block4;
                    this.removeDeep(parent, false);
                }
                catch (Exception e) {
                    log.error((Object)("unloadProperty operation (remove of parent) fails. Parent ID=" + property.getParentIdentifier() + ". Error " + e), (Throwable)e);
                    Object var4_5 = null;
                    this.remove(property);
                }
            }
            Object var4_4 = null;
            this.remove(property);
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.remove(property);
            throw throwable;
        }
    }

    private boolean needReload(ItemData data) {
        return data.getQPath().getName().equals((Object)Constants.JCR_MIXINTYPES) || data.getQPath().getName().equals((Object)Constants.EXO_PERMISSIONS) || data.getQPath().getName().equals((Object)Constants.EXO_OWNER);
    }

    @Override
    public synchronized void onSaveItems(ItemStateChangesLog changesLog) {
        if (!this.enabled) {
            return;
        }
        List<ItemState> itemStates = changesLog.getAllStates();
        for (int i = 0; i < itemStates.size(); ++i) {
            ItemState state = itemStates.get(i);
            ItemData data = state.getData();
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.name + ", onSaveItems() " + ItemState.nameFromValue(state.getState()) + " " + data.getQPath().getAsString() + " " + data.getIdentifier() + " parent:" + data.getParentIdentifier()));
            }
            try {
                if (state.isAdded()) {
                    if (!data.isNode() && this.needReload(data)) {
                        this.unloadProperty((PropertyData)data);
                    }
                    this.put(data);
                    continue;
                }
                if (state.isUpdated()) {
                    if (data.isNode()) {
                        this.unloadNode((NodeData)data);
                    } else if (this.needReload(data)) {
                        this.unloadProperty((PropertyData)data);
                    }
                    this.put(data);
                    continue;
                }
                if (state.isDeleted()) {
                    if (!data.isNode() && this.needReload(data)) {
                        this.unloadProperty((PropertyData)data);
                        continue;
                    }
                    this.remove(data);
                    continue;
                }
                if (!state.isRenamed()) continue;
                if (data.isNode()) {
                    this.unloadNode((NodeData)data);
                } else if (this.needReload(data)) {
                    this.unloadProperty((PropertyData)data);
                }
                this.put(data);
                continue;
            }
            catch (Exception e) {
                log.error((Object)(this.name + ", Error process onSaveItems action for item data: " + (data != null ? data.getQPath().getAsString() : "[null]")), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadNode(NodeData item) throws Exception {
        ItemData parent = (ItemData)this.cache.get((Serializable)((Object)item.getParentIdentifier()));
        if (parent != null) {
            if (item.isNode()) {
                WeakHashMap<String, List<NodeData>> weakHashMap = this.nodesCache;
                synchronized (weakHashMap) {
                    WeakHashMap<String, List<PropertyData>> weakHashMap2 = this.propertiesCache;
                    synchronized (weakHashMap2) {
                        if (this.removeChildNodes(parent.getIdentifier(), true) == null) {
                            this.removeDeep(item, true);
                        }
                    }
                }
                this.removeSuccessors(item);
            } else {
                WeakHashMap<String, List<PropertyData>> weakHashMap = this.propertiesCache;
                synchronized (weakHashMap) {
                    this.removeChildProperties(parent.getIdentifier());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(ItemData data) {
        block14: {
            if (!this.enabled) {
                return;
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.name + ", remove() " + data.getQPath().getAsString() + " " + data.getIdentifier()));
                }
                if (data.isNode()) {
                    WeakHashMap<String, List<PropertyData>> weakHashMap = this.propertiesCache;
                    synchronized (weakHashMap) {
                        WeakHashMap<String, List<NodeData>> weakHashMap2 = this.nodesCache;
                        synchronized (weakHashMap2) {
                            this.removeDeep(data, true);
                        }
                    }
                    this.removeSuccessors((NodeData)data);
                    break block14;
                }
                WeakHashMap<String, List<PropertyData>> weakHashMap = this.propertiesCache;
                synchronized (weakHashMap) {
                    this.removeDeep(data, true);
                }
            }
            catch (Exception e) {
                log.error((Object)(this.name + ", Error remove item data from cache: " + (data != null ? data.getQPath().getAsString() : "[null]")), (Throwable)e);
            }
        }
    }

    protected ItemData removeDeep(ItemData item, boolean forceDeep) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.name + ", removeDeep(" + forceDeep + ") >>> item " + item.getQPath().getAsString() + " " + item.getIdentifier()));
        }
        if (forceDeep) {
            this.removeRelations(item);
        }
        this.cache.remove((Serializable)((Object)item.getIdentifier()));
        ItemData itemData = (ItemData)this.cache.remove((Serializable)new CacheQPath(item.getParentIdentifier(), item.getQPath()));
        if (itemData != null && !itemData.getIdentifier().equals(item.getIdentifier())) {
            this.removeDeep(itemData, forceDeep);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.name + ", removeDeep(" + forceDeep + ") <<< item " + item.getQPath().getAsString() + " " + item.getIdentifier()));
        }
        return itemData;
    }

    protected void removeRelations(ItemData item) {
        try {
            if (item.isNode()) {
                if (this.removeChildNodes(item.getIdentifier(), true) != null && log.isDebugEnabled()) {
                    log.debug((Object)(this.name + ", removeRelations() removeChildNodes() " + item.getIdentifier()));
                }
                if (this.removeChildProperties(item.getIdentifier()) != null && log.isDebugEnabled()) {
                    log.debug((Object)(this.name + ", removeRelations() removeChildProperties() " + item.getIdentifier()));
                }
                if (this.removeChildNode(item.getParentIdentifier(), item.getIdentifier()) != null && log.isDebugEnabled()) {
                    log.debug((Object)(this.name + ", removeRelations() removeChildNode(parentIdentifier, childIdentifier) " + item.getParentIdentifier() + " " + item.getIdentifier()));
                }
            } else if (this.removeChildProperty(item.getParentIdentifier(), item.getIdentifier()) != null && log.isDebugEnabled()) {
                log.debug((Object)(this.name + ", removeRelations() removeChildProperty(parentIdentifier, childIdentifier) " + item.getParentIdentifier() + " " + item.getIdentifier()));
            }
        }
        catch (Exception e) {
            log.error((Object)(this.name + ", Error in removeRelations() item: " + (item != null ? item.getQPath().getAsString() : "[null]")), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<NodeData> removeChildNodes(String parentIdentifier, boolean forceDeep) throws Exception {
        List<NodeData> childNodes = this.nodesCache.remove(parentIdentifier);
        if (childNodes != null) {
            List<NodeData> list = childNodes;
            synchronized (list) {
                for (NodeData cn : childNodes) {
                    this.removeDeep(cn, forceDeep);
                }
            }
        }
        return childNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PropertyData> removeChildProperties(String parentIdentifier) throws Exception {
        List<PropertyData> childProperties = this.propertiesCache.remove(parentIdentifier);
        if (childProperties != null) {
            List<PropertyData> list = childProperties;
            synchronized (list) {
                for (PropertyData cp : childProperties) {
                    this.removeDeep(cp, false);
                }
            }
        }
        return childProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertyData removeChildProperty(String parentIdentifier, String childIdentifier) throws Exception {
        List<PropertyData> childProperties = this.propertiesCache.get(parentIdentifier);
        if (childProperties != null) {
            List<PropertyData> list = childProperties;
            synchronized (list) {
                Iterator<PropertyData> i = childProperties.iterator();
                while (i.hasNext()) {
                    PropertyData cn = i.next();
                    if (!cn.getIdentifier().equals(childIdentifier)) continue;
                    i.remove();
                    break;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeData removeChildNode(String parentIdentifier, String childIdentifier) throws Exception {
        List<NodeData> childNodes = this.nodesCache.get(parentIdentifier);
        if (childNodes != null) {
            List<NodeData> list = childNodes;
            synchronized (list) {
                Iterator<NodeData> i = childNodes.iterator();
                while (i.hasNext()) {
                    NodeData cn = i.next();
                    if (!cn.getIdentifier().equals(childIdentifier)) continue;
                    i.remove();
                    break;
                }
            }
        }
        return null;
    }

    protected void removeItem(String itemPath) {
        ItemRemoveSelector remover = new ItemRemoveSelector(itemPath);
        try {
            this.cache.select((CachedObjectSelector)remover);
        }
        catch (Exception e) {
            log.error((Object)(this.name + ", removeSuccessors() " + itemPath), (Throwable)e);
        }
    }

    protected void removeSuccessors(NodeData parent) {
        ByParentRemoveSelector remover = new ByParentRemoveSelector(parent);
        try {
            this.cache.select((CachedObjectSelector)remover);
        }
        catch (Exception e) {
            log.error((Object)(this.name + ", removeSuccessors() " + parent.getQPath().getAsString()), (Throwable)e);
        }
    }

    protected class ExpiredListener
    implements CacheListener {
        protected ExpiredListener() {
        }

        public void onExpire(ExoCache cache, Serializable key, Object obj) throws Exception {
            if (obj == null) {
                return;
            }
            ItemData item = (ItemData)obj;
            if (item.isNode()) {
                if (WorkspaceStorageCacheImpl.this.removeChildNodes(item.getIdentifier(), false) != null && log.isDebugEnabled()) {
                    log.debug((Object)(WorkspaceStorageCacheImpl.this.name + ", onExpire() removeChildNodes() " + item.getIdentifier()));
                }
                if (WorkspaceStorageCacheImpl.this.removeChildProperties(item.getIdentifier()) != null && log.isDebugEnabled()) {
                    log.debug((Object)(WorkspaceStorageCacheImpl.this.name + ", onExpire() removeChildProperties() " + item.getIdentifier()));
                }
            } else if (WorkspaceStorageCacheImpl.this.removeChildProperties(item.getParentIdentifier()) != null && log.isDebugEnabled()) {
                log.debug((Object)(WorkspaceStorageCacheImpl.this.name + ", onExpire() parent.removeChildProperties() " + item.getParentIdentifier()));
            }
        }

        public void onClearCache(ExoCache cache) throws Exception {
        }

        public void onGet(ExoCache cache, Serializable key, Object obj) throws Exception {
        }

        public void onPut(ExoCache cache, Serializable key, Object obj) throws Exception {
        }

        public void onRemove(ExoCache cache, Serializable key, Object obj) throws Exception {
        }
    }

    protected class ItemRemoveSelector
    implements CachedObjectSelector {
        private final String itemPath;

        protected ItemRemoveSelector(String itemPath) {
            this.itemPath = itemPath;
        }

        public void onSelect(ExoCache exoCache, Serializable key, ObjectCacheInfo value) throws Exception {
            try {
                ItemData removed = (ItemData)exoCache.remove(key);
                if (removed != null) {
                    exoCache.remove((Serializable)((Object)removed.getIdentifier()));
                }
            }
            catch (Exception e) {
                log.error((Object)(WorkspaceStorageCacheImpl.this.name + ", ItemRemoveSelector.onSelect() " + this.itemPath + " key: " + key), (Throwable)e);
            }
        }

        public boolean select(Serializable key, ObjectCacheInfo value) {
            return ((String)((Object)key)).equals(this.itemPath);
        }
    }

    @Deprecated
    protected class ByPathRemoveSelector
    implements CachedObjectSelector {
        private final String parentPath;

        protected ByPathRemoveSelector(String parentPath) {
            this.parentPath = parentPath;
        }

        public void onSelect(ExoCache exoCache, Serializable key, ObjectCacheInfo value) throws Exception {
            try {
                ItemData removed = (ItemData)exoCache.remove(key);
                if (removed != null) {
                    exoCache.remove((Serializable)((Object)removed.getIdentifier()));
                }
            }
            catch (Exception e) {
                log.error((Object)(WorkspaceStorageCacheImpl.this.name + ", ByPathRemoveSelector.onSelect() " + this.parentPath + " key: " + key), (Throwable)e);
            }
        }

        public boolean select(Serializable key, ObjectCacheInfo value) {
            return ((String)((Object)key)).startsWith(this.parentPath);
        }
    }

    protected class ByParentRemoveSelector
    implements CachedObjectSelector {
        private final NodeData parent;

        protected ByParentRemoveSelector(NodeData parent) {
            this.parent = parent;
        }

        public void onSelect(ExoCache exoCache, Serializable key, ObjectCacheInfo value) throws Exception {
            try {
                ItemData removed = (ItemData)exoCache.remove(key);
                if (removed != null && key instanceof CacheQPath) {
                    exoCache.remove((Serializable)((Object)removed.getIdentifier()));
                }
            }
            catch (Exception e) {
                log.error((Object)(WorkspaceStorageCacheImpl.this.name + ", ByParentRemoveSelector.onSelect() " + this.parent.getIdentifier() + ": " + this.parent.getQPath().getAsString() + " key: " + key), (Throwable)e);
            }
        }

        public boolean select(Serializable key, ObjectCacheInfo value) {
            String id;
            CacheQPath path;
            return key instanceof CacheQPath ? (path = (CacheQPath)key).getQPath().isDescendantOf(this.parent.getQPath()) : (id = (String)((Object)key)).equals(this.parent.getIdentifier());
        }
    }
}

