/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.access.AccessManager;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.ItemImpl;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.PropertyImpl;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.version.ChildVersionRemoveVisitor;
import org.exoplatform.services.jcr.impl.core.version.VersionHistoryImpl;
import org.exoplatform.services.jcr.impl.core.version.VersionImpl;
import org.exoplatform.services.jcr.impl.dataflow.ItemDataMoveVisitor;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.LocalWorkspaceDataManagerStub;
import org.exoplatform.services.jcr.impl.dataflow.session.SessionChangesLog;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableDataManager;
import org.exoplatform.services.jcr.impl.dataflow.session.WorkspaceStorageDataManagerProxy;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionDataManager
implements ItemDataConsumer {
    public static final int MERGE_NODES = 1;
    public static final int MERGE_PROPS = 2;
    public static final int MERGE_ITEMS = 3;
    protected static Log log = ExoLogger.getLogger((String)"jcr.SessionDataManager");
    protected final SessionImpl session;
    protected final ItemReferencePool itemsPool;
    protected final List<ItemImpl> invalidated = new ArrayList<ItemImpl>();
    private final SessionChangesLog changesLog;
    protected final SessionItemFactory itemFactory;
    protected final AccessManager accessManager;
    protected final TransactionableDataManager transactionableManager;

    public SessionDataManager(SessionImpl session, LocalWorkspaceDataManagerStub dataManager) throws RepositoryException {
        this.session = session;
        this.changesLog = new SessionChangesLog(session.getId());
        this.itemsPool = new ItemReferencePool();
        this.itemFactory = new SessionItemFactory();
        this.accessManager = session.getAccessManager();
        this.transactionableManager = new TransactionableDataManager(dataManager, session);
    }

    public WorkspaceStorageDataManagerProxy getWorkspaceDataManager() {
        return this.transactionableManager.getStorageDataManager();
    }

    public String dump() {
        String d = "\nChanges:";
        d = d + this.changesLog.dump();
        d = d + "\nCache:";
        d = d + this.itemsPool.dump();
        return d;
    }

    public TransactionableDataManager getTransactManager() {
        return this.transactionableManager;
    }

    public ItemData getItemData(QPath path) throws RepositoryException {
        NodeData parent = (NodeData)this.getItemData("00exo0jcr0root0uuid0000000000000");
        if (path.equals(Constants.ROOT_PATH)) {
            return parent;
        }
        QPathEntry[] relPathEntries = path.getRelPath(path.getDepth());
        return this.getItemData(parent, relPathEntries);
    }

    public ItemData getItemData(NodeData parent, QPathEntry[] relPathEntries) throws RepositoryException {
        ItemData item = parent;
        for (int i = 0; i < relPathEntries.length && (item = this.getItemData(parent, relPathEntries[i])) != null; ++i) {
            if (item.isNode()) {
                parent = (NodeData)item;
                continue;
            }
            if (i >= relPathEntries.length - 1) continue;
            throw new IllegalPathException("Path can not contains a property as the intermediate element");
        }
        return item;
    }

    @Override
    public ItemData getItemData(NodeData parent, QPathEntry name) throws RepositoryException {
        if (name.getName().equals("..") && name.getNamespace().equals("")) {
            return this.getItemData(parent.getParentIdentifier());
        }
        ItemData data = null;
        ItemState state = this.changesLog.getItemState(parent, name);
        if (state == null) {
            data = this.transactionableManager.getItemData(parent, name);
        } else if (!state.isDeleted()) {
            data = state.getData();
        }
        return data;
    }

    @Override
    public ItemData getItemData(String identifier) throws RepositoryException {
        ItemData data = null;
        ItemState state = this.changesLog.getItemState(identifier);
        if (state == null) {
            data = this.transactionableManager.getItemData(identifier);
        } else if (!state.isDeleted()) {
            data = state.getData();
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemImpl getItem(NodeData parent, QPathEntry name, boolean pool) throws RepositoryException {
        ItemImpl item;
        long start;
        block10: {
            ItemData itemData;
            block9: {
                ItemImpl itemImpl;
                start = System.currentTimeMillis();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getItem(" + parent.getQPath().getAsString() + " + " + name.getAsString() + " ) >>>>>"));
                }
                item = null;
                try {
                    itemData = this.getItemData(parent, name);
                    if (itemData != null) break block9;
                    itemImpl = null;
                    Object var10_10 = null;
                }
                catch (Throwable throwable) {
                    block11: {
                        Object var10_13 = null;
                        if (!log.isDebugEnabled()) break block11;
                        log.debug((Object)("getItem(" + parent.getQPath().getAsString() + " + " + name.getAsString() + ") --> " + (item != null ? item.getPath() : "null") + " <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
                    }
                    throw throwable;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getItem(" + parent.getQPath().getAsString() + " + " + name.getAsString() + ") --> " + (item != null ? item.getPath() : "null") + " <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
                }
                return itemImpl;
            }
            item = this.itemFactory.createItem(itemData);
            this.session.getActionHandler().postRead(item);
            if (!item.hasPermission("read")) {
                throw new AccessDeniedException("Access denied " + QPath.makeChildPath(parent.getQPath(), name).getAsString() + " for " + this.session.getUserID() + " (get item by path)");
            }
            if (!pool) break block10;
            ItemImpl itemImpl = this.itemsPool.get(item);
            Object var10_11 = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)("getItem(" + parent.getQPath().getAsString() + " + " + name.getAsString() + ") --> " + (item != null ? item.getPath() : "null") + " <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
            }
            return itemImpl;
        }
        ItemImpl itemImpl = item;
        Object var10_12 = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getItem(" + parent.getQPath().getAsString() + " + " + name.getAsString() + ") --> " + (item != null ? item.getPath() : "null") + " <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
        }
        return itemImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemImpl getItem(NodeData parent, QPathEntry[] relPath, boolean pool) throws RepositoryException {
        ItemImpl itemImpl;
        ItemImpl item;
        long start;
        block15: {
            ItemData itemData;
            block14: {
                start = System.currentTimeMillis();
                if (log.isDebugEnabled()) {
                    String debugPath = "";
                    for (QPathEntry rp : relPath) {
                        debugPath = debugPath + rp.getAsString();
                    }
                    log.debug((Object)("getItem(" + parent.getQPath().getAsString() + " + " + debugPath + " ) >>>>>"));
                }
                item = null;
                itemData = this.getItemData(parent, relPath);
                if (itemData != null) break block14;
                ItemImpl itemImpl2 = null;
                Object var12_13 = null;
                if (log.isDebugEnabled()) {
                    String debugPath = "";
                    for (QPathEntry rp : relPath) {
                        debugPath = debugPath + rp.getAsString();
                    }
                    log.debug((Object)("getItem(" + parent.getQPath().getAsString() + " + " + debugPath + ") --> " + (item != null ? item.getPath() : "null") + " <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
                }
                return itemImpl2;
            }
            item = this.itemFactory.createItem(itemData);
            this.session.getActionHandler().postRead(item);
            if (!item.hasPermission("read")) {
                throw new AccessDeniedException("Access denied " + this.session.getLocationFactory().createJCRPath(QPath.makeChildPath(parent.getQPath(), relPath)).getAsString(false) + " for " + this.session.getUserID() + " (get item by path)");
            }
            if (!pool) break block15;
            ItemImpl itemImpl3 = this.itemsPool.get(item);
            Object var12_14 = null;
            if (log.isDebugEnabled()) {
                String debugPath = "";
                for (QPathEntry rp : relPath) {
                    debugPath = debugPath + rp.getAsString();
                }
                log.debug((Object)("getItem(" + parent.getQPath().getAsString() + " + " + debugPath + ") --> " + (item != null ? item.getPath() : "null") + " <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
            }
            return itemImpl3;
        }
        try {
            itemImpl = item;
            Object var12_15 = null;
        }
        catch (Throwable throwable) {
            block16: {
                Object var12_16 = null;
                if (!log.isDebugEnabled()) break block16;
                String debugPath = "";
                for (QPathEntry rp : relPath) {
                    debugPath = debugPath + rp.getAsString();
                }
                log.debug((Object)("getItem(" + parent.getQPath().getAsString() + " + " + debugPath + ") --> " + (item != null ? item.getPath() : "null") + " <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
            }
            throw throwable;
        }
        if (log.isDebugEnabled()) {
            String debugPath = "";
            for (QPathEntry rp : relPath) {
                debugPath = debugPath + rp.getAsString();
            }
            log.debug((Object)("getItem(" + parent.getQPath().getAsString() + " + " + debugPath + ") --> " + (item != null ? item.getPath() : "null") + " <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
        }
        return itemImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemImpl getItem(QPath path, boolean pool) throws RepositoryException {
        ItemImpl item;
        long start;
        block10: {
            ItemData itemData;
            block9: {
                ItemImpl itemImpl;
                start = System.currentTimeMillis();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getItem(" + path.getAsString() + " ) >>>>>"));
                }
                item = null;
                try {
                    itemData = this.getItemData(path);
                    if (itemData != null) break block9;
                    itemImpl = null;
                    Object var9_9 = null;
                }
                catch (Throwable throwable) {
                    block11: {
                        Object var9_12 = null;
                        if (!log.isDebugEnabled()) break block11;
                        log.debug((Object)("getItem(" + path.getAsString() + ") --> " + (item != null ? item.getPath() : "null") + " <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
                    }
                    throw throwable;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getItem(" + path.getAsString() + ") --> " + (item != null ? item.getPath() : "null") + " <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
                }
                return itemImpl;
            }
            item = this.itemFactory.createItem(itemData);
            this.session.getActionHandler().postRead(item);
            if (!item.hasPermission("read")) {
                throw new AccessDeniedException("Access denied " + path.getAsString() + " for " + this.session.getUserID() + " (get item by path)");
            }
            if (!pool) break block10;
            ItemImpl itemImpl = this.itemsPool.get(item);
            Object var9_10 = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)("getItem(" + path.getAsString() + ") --> " + (item != null ? item.getPath() : "null") + " <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
            }
            return itemImpl;
        }
        ItemImpl itemImpl = item;
        Object var9_11 = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getItem(" + path.getAsString() + ") --> " + (item != null ? item.getPath() : "null") + " <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
        }
        return itemImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemImpl getItemByIdentifier(String identifier, boolean pool) throws RepositoryException {
        ItemImpl item;
        long start;
        block10: {
            ItemData itemData;
            block9: {
                ItemImpl itemImpl;
                start = System.currentTimeMillis();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getItemByIdentifier(" + identifier + " ) >>>>>"));
                }
                item = null;
                try {
                    itemData = this.getItemData(identifier);
                    if (itemData != null) break block9;
                    itemImpl = null;
                    Object var9_9 = null;
                }
                catch (Throwable throwable) {
                    block11: {
                        Object var9_12 = null;
                        if (!log.isDebugEnabled()) break block11;
                        log.debug((Object)("getItemByIdentifier(" + identifier + ") --> " + (item != null ? item.getPath() : "null") + "  <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
                    }
                    throw throwable;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getItemByIdentifier(" + identifier + ") --> " + (item != null ? item.getPath() : "null") + "  <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
                }
                return itemImpl;
            }
            item = this.itemFactory.createItem(itemData);
            this.session.getActionHandler().postRead(item);
            if (!item.hasPermission("read")) {
                throw new AccessDeniedException("Access denied, item with id : " + item.getPath() + " (get item by id), user " + this.session.getUserID() + " has no privileges on reading");
            }
            if (!pool) break block10;
            ItemImpl itemImpl = this.itemsPool.get(item);
            Object var9_10 = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)("getItemByIdentifier(" + identifier + ") --> " + (item != null ? item.getPath() : "null") + "  <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
            }
            return itemImpl;
        }
        ItemImpl itemImpl = item;
        Object var9_11 = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getItemByIdentifier(" + identifier + ") --> " + (item != null ? item.getPath() : "null") + "  <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
        }
        return itemImpl;
    }

    public boolean hasPendingChanges(QPath path) {
        return this.changesLog.getDescendantsChanges(path).size() > 0;
    }

    public boolean isNew(String identifier) {
        ItemState lastState = this.changesLog.getItemState(identifier);
        if (lastState == null || lastState.isDeleted()) {
            return false;
        }
        return this.changesLog.getItemState(identifier, 1) != null;
    }

    public boolean isModified(ItemData item) {
        if (item.isNode()) {
            Collection<ItemState> nodeChanges = this.changesLog.getLastModifyStates((NodeData)item);
            return nodeChanges.size() > 0;
        }
        List<ItemState> states = this.changesLog.getItemStates(item.getIdentifier());
        if (states.size() > 0) {
            ItemState lastState = states.get(states.size() - 1);
            return !lastState.isAdded() && !lastState.isDeleted();
        }
        return false;
    }

    public List<PropertyImpl> getReferences(String identifier) throws RepositoryException {
        ArrayList<PropertyImpl> refs = new ArrayList<PropertyImpl>();
        for (PropertyData data : this.transactionableManager.getReferencesData(identifier, true)) {
            NodeData parent = (NodeData)this.getItemData(data.getParentIdentifier());
            if (!this.accessManager.hasPermission(parent.getACL(), new String[]{"read"}, this.session.getUserState().getIdentity())) continue;
            PropertyImpl item = null;
            ItemState state = this.changesLog.getItemState(data.getIdentifier());
            if (state != null) {
                if (state.isDeleted()) continue;
                item = (PropertyImpl)this.itemFactory.createItem(state.getData());
            } else {
                item = (PropertyImpl)this.itemFactory.createItem(data);
            }
            refs.add(item);
            this.session.getActionHandler().postRead(item);
        }
        return refs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NodeImpl> getChildNodes(NodeData parent, boolean pool) throws RepositoryException, AccessDeniedException {
        ArrayList<NodeImpl> arrayList;
        long start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("getChildNodes(" + parent.getQPath().getAsString() + ") >>>>>"));
        }
        try {
            ArrayList<NodeImpl> nodes = new ArrayList<NodeImpl>();
            List<NodeData> nodeDatas = this.getChildNodesData(parent);
            for (NodeData data : nodeDatas) {
                NodeImpl item = this.itemFactory.createNode(data);
                this.session.getActionHandler().postRead(item);
                if (!this.accessManager.hasPermission(data.getACL(), new String[]{"read"}, this.session.getUserState().getIdentity())) continue;
                if (pool) {
                    item = (NodeImpl)this.itemsPool.get(item);
                }
                nodes.add(item);
            }
            arrayList = nodes;
            Object var11_9 = null;
        }
        catch (Throwable throwable) {
            block6: {
                Object var11_10 = null;
                if (!log.isDebugEnabled()) break block6;
                log.debug((Object)("getChildNodes(" + parent.getQPath().getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
            }
            throw throwable;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getChildNodes(" + parent.getQPath().getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PropertyImpl> getChildProperties(NodeData parent, boolean pool) throws RepositoryException, AccessDeniedException {
        ArrayList<PropertyImpl> arrayList;
        long start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("getChildProperties(" + parent.getQPath().getAsString() + ") >>>>>"));
        }
        try {
            ArrayList<PropertyImpl> props = new ArrayList<PropertyImpl>();
            for (PropertyData data : this.getChildPropertiesData(parent)) {
                ItemImpl item = this.itemFactory.createItem(data);
                this.session.getActionHandler().postRead(item);
                if (!this.accessManager.hasPermission(parent.getACL(), new String[]{"read"}, this.session.getUserState().getIdentity())) continue;
                if (pool) {
                    item = this.itemsPool.get(item);
                }
                props.add((PropertyImpl)item);
            }
            arrayList = props;
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            block6: {
                Object var10_9 = null;
                if (!log.isDebugEnabled()) break block6;
                log.debug((Object)("getChildProperties(" + parent.getQPath().getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
            }
            throw throwable;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getChildProperties(" + parent.getQPath().getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NodeData> getChildNodesData(NodeData parent) throws RepositoryException {
        List<? extends ItemData> list;
        long start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("getChildNodesData(" + parent.getQPath().getAsString() + ") >>>>>"));
        }
        try {
            list = this.merge(parent, this.transactionableManager, false, 1);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            block4: {
                Object var6_5 = null;
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)("getChildNodesData(" + parent.getQPath().getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
            }
            throw throwable;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getChildNodesData(" + parent.getQPath().getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
        }
        return list;
    }

    @Override
    public int getChildNodesCount(NodeData parent) throws RepositoryException {
        int childsCount = this.transactionableManager.getChildNodesCount(parent) + this.changesLog.getChildNodesCount(parent.getIdentifier());
        if (childsCount < 0) {
            throw new InvalidItemStateException("Node's child nodes were changed in another Session " + parent.getQPath().getAsString());
        }
        return childsCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> getChildPropertiesData(NodeData parent) throws RepositoryException {
        List<? extends ItemData> list;
        long start = 0L;
        if (log.isDebugEnabled()) {
            start = System.currentTimeMillis();
            log.debug((Object)("getChildPropertiesData(" + parent.getQPath().getAsString() + ") >>>>>"));
        }
        try {
            list = this.merge(parent, this.transactionableManager, false, 2);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            block4: {
                Object var6_5 = null;
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)("getChildPropertiesData(" + parent.getQPath().getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
            }
            throw throwable;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getChildPropertiesData(" + parent.getQPath().getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> listChildPropertiesData(NodeData parent) throws RepositoryException {
        List<? extends ItemData> list;
        long start = 0L;
        if (log.isDebugEnabled()) {
            start = System.currentTimeMillis();
            log.debug((Object)("listChildPropertiesData(" + parent.getQPath().getAsString() + ") >>>>>"));
        }
        try {
            list = this.mergeList(parent, this.transactionableManager, false, 2);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            block4: {
                Object var6_5 = null;
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)("listChildPropertiesData(" + parent.getQPath().getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
            }
            throw throwable;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("listChildPropertiesData(" + parent.getQPath().getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessControlList getACL(QPath path) throws RepositoryException {
        NodeData parent;
        long start;
        block11: {
            AccessControlList accessControlList;
            block10: {
                start = System.currentTimeMillis();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getACL(" + path.getAsString() + " ) >>>>>"));
                }
                parent = (NodeData)this.getItemData("00exo0jcr0root0uuid0000000000000");
                if (!path.equals(Constants.ROOT_PATH)) break block10;
                AccessControlList accessControlList2 = parent.getACL();
                Object var9_6 = null;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getACL(" + path.getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
                }
                return accessControlList2;
            }
            try {
                ItemData item = null;
                QPathEntry[] relPathEntries = path.getRelPath(path.getDepth());
                for (int i = 0; i < relPathEntries.length && (item = this.getItemData(parent, relPathEntries[i])) != null; ++i) {
                    if (item.isNode()) {
                        parent = (NodeData)item;
                        continue;
                    }
                    if (i >= relPathEntries.length - 1) continue;
                    throw new IllegalPathException("Get ACL. Path can not contains a property as the intermediate element");
                }
                if (item == null || !item.isNode()) break block11;
                accessControlList = ((NodeData)item).getACL();
                Object var9_7 = null;
            }
            catch (Throwable throwable) {
                block12: {
                    Object var9_9 = null;
                    if (!log.isDebugEnabled()) break block12;
                    log.debug((Object)("getACL(" + path.getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
                }
                throw throwable;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("getACL(" + path.getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
            }
            return accessControlList;
        }
        AccessControlList accessControlList = parent.getACL();
        Object var9_8 = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getACL(" + path.getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
        }
        return accessControlList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessControlList getACL(NodeData parent, QPathEntry name) throws RepositoryException {
        long start;
        block6: {
            AccessControlList accessControlList;
            start = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug((Object)("getACL(" + parent.getQPath().getAsString() + " + " + name.getAsString() + " ) >>>>>"));
            }
            try {
                ItemData item = this.getItemData(parent, name);
                if (item == null || !item.isNode()) break block6;
                accessControlList = ((NodeData)item).getACL();
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var8_9 = null;
                    if (!log.isDebugEnabled()) break block7;
                    log.debug((Object)("getACL(" + parent.getQPath().getAsString() + " + " + name.getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
                }
                throw throwable;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("getACL(" + parent.getQPath().getAsString() + " + " + name.getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
            }
            return accessControlList;
        }
        AccessControlList accessControlList = parent.getACL();
        Object var8_8 = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getACL(" + parent.getQPath().getAsString() + " + " + name.getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
        }
        return accessControlList;
    }

    void reloadPool(ItemData fromItem) throws RepositoryException {
        Collection<ItemImpl> pooledItems = this.itemsPool.getAll();
        for (ItemImpl item : pooledItems) {
            if (!item.getInternalPath().isDescendantOf(fromItem.getQPath()) && !item.getInternalPath().equals(fromItem.getQPath())) continue;
            ItemData ri = this.getItemData(item.getInternalIdentifier());
            if (ri != null) {
                this.itemsPool.reload(ri);
            } else {
                item.invalidate();
            }
            this.invalidated.add(item);
        }
    }

    public void rename(NodeData srcData, ItemDataMoveVisitor initializer) throws RepositoryException {
        srcData.accept(initializer);
        this.changesLog.addAll(initializer.getAllStates());
        this.reloadPool(srcData);
    }

    public void delete(ItemData itemData) throws RepositoryException {
        this.delete(itemData, itemData.getQPath());
    }

    public void delete(ItemData itemData, QPath ancestorToSave) throws RepositoryException {
        List<? extends ItemData> list = this.mergeList(itemData, this.transactionableManager, true, 3);
        ArrayList<ItemState> deletes = new ArrayList<ItemState>();
        boolean fireEvent = !this.isNew(itemData.getIdentifier());
        NodeTypeManagerImpl ntManager = this.session.getWorkspace().getNodeTypeManager();
        boolean checkRemoveChildVersionStorages = false;
        if (itemData.isNode()) {
            checkRemoveChildVersionStorages = !ntManager.isNodeType(Constants.NT_VERSIONHISTORY, ((NodeData)itemData).getPrimaryTypeName());
        }
        boolean rootAdded = false;
        for (ItemData itemData2 : list) {
            ItemImpl pooled;
            if (itemData2.equals(itemData)) {
                rootAdded = true;
            }
            deletes.add(new ItemState(itemData2, 4, fireEvent, ancestorToSave, false));
            if (checkRemoveChildVersionStorages && !itemData2.isNode() && Constants.JCR_VERSIONHISTORY.equals((Object)itemData2.getQPath().getName())) {
                try {
                    PropertyData vhPropertyData = (PropertyData)this.getItemData(itemData2.getIdentifier());
                    this.removeVersionHistory(new String(vhPropertyData.getValues().get(0).getAsByteArray()), null, ancestorToSave);
                }
                catch (IllegalStateException e) {
                    throw new RepositoryException(e.getLocalizedMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    throw new RepositoryException(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if ((pooled = this.itemsPool.remove(itemData2.getIdentifier())) == null) continue;
            pooled.invalidate();
            this.invalidated.add(pooled);
        }
        if (!rootAdded) {
            deletes.add(new ItemState(itemData, 4, fireEvent, ancestorToSave, false));
            ItemImpl pooled = this.itemsPool.remove(itemData.getIdentifier());
            if (pooled != null) {
                pooled.invalidate();
                this.invalidated.add(pooled);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("deleted top item: " + itemData.getQPath().getAsString()));
            }
        }
        Collections.sort(deletes, new PathSorter());
        if (!fireEvent) {
            this.changesLog.eraseEventFire(itemData.getIdentifier());
        }
        this.changesLog.addAll(deletes);
        if (itemData.isNode()) {
            this.changesLog.addAll(this.reindexSameNameSiblings((NodeData)itemData, this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeVersionHistory(String vhID, QPath containingHistory, QPath ancestorToSave) throws RepositoryException, ConstraintViolationException, VersionException {
        NodeData vhnode = (NodeData)this.getItemData(vhID);
        if (vhnode == null) {
            ItemState vhState = this.changesLog.getItemState(vhID);
            if (vhState == null || !vhState.isDeleted()) throw new RepositoryException("Version history is not found. UUID: " + vhID + ". Context item (ancestor to save) " + ancestorToSave.getAsString());
            return;
        }
        RepositoryImpl rep = (RepositoryImpl)this.session.getRepository();
        for (String wsName : rep.getWorkspaceNames()) {
            Object var14_14;
            SessionImpl wsSession = this.session.getWorkspace().getName().equals(wsName) ? this.session : rep.getSystemSession(wsName);
            try {
                for (PropertyData sref : wsSession.getTransientNodesManager().getReferencesData(vhID, false)) {
                    if (sref.getQPath().isDescendantOf(Constants.JCR_VERSION_STORAGE_PATH)) {
                        if (sref.getQPath().isDescendantOf(vhnode.getQPath())) continue;
                        if (containingHistory != null) {
                            if (sref.getQPath().isDescendantOf(containingHistory)) continue;
                        }
                        var14_14 = null;
                        if (wsSession == this.session) return;
                        wsSession.logout();
                        return;
                    }
                    if (wsSession == this.session) continue;
                }
            }
            catch (Throwable throwable) {
                var14_14 = null;
                if (wsSession == this.session) throw throwable;
                wsSession.logout();
                throw throwable;
            }
            {
                var14_14 = null;
                if (wsSession == this.session) return;
                wsSession.logout();
                return;
            }
            var14_14 = null;
            if (wsSession == this.session) continue;
            wsSession.logout();
            {
            }
        }
        ChildVersionRemoveVisitor cvremover = new ChildVersionRemoveVisitor(this.session, vhnode.getQPath(), ancestorToSave);
        vhnode.accept(cvremover);
        this.delete(vhnode, ancestorToSave);
    }

    protected List<ItemState> reindexSameNameSiblings(NodeData cause, ItemDataConsumer dataManager) throws RepositoryException {
        ArrayList<ItemState> changes = new ArrayList<ItemState>();
        NodeData parentNodeData = (NodeData)dataManager.getItemData(cause.getParentIdentifier());
        TransientNodeData nextSibling = (TransientNodeData)dataManager.getItemData(parentNodeData, new QPathEntry(cause.getQPath().getName(), cause.getQPath().getIndex() + 1));
        String reindexedId = null;
        while (nextSibling != null && !nextSibling.getIdentifier().equals(cause.getIdentifier()) && !nextSibling.getIdentifier().equals(reindexedId)) {
            TransientNodeData reindexed = nextSibling.cloneAsSibling(nextSibling.getQPath().getIndex() - 1);
            reindexedId = reindexed.getIdentifier();
            ItemState reindexedState = ItemState.createUpdatedState(reindexed);
            changes.add(reindexedState);
            this.itemsPool.reload(reindexed);
            nextSibling = (TransientNodeData)dataManager.getItemData(parentNodeData, new QPathEntry(nextSibling.getQPath().getName(), nextSibling.getQPath().getIndex() + 1));
        }
        return changes;
    }

    public ItemImpl update(ItemState itemState, boolean pool) throws RepositoryException {
        if (itemState.isDeleted()) {
            throw new RepositoryException("Illegal state DELETED. Use delete(...) method");
        }
        this.changesLog.add(itemState);
        ItemImpl item = this.itemFactory.createItem(itemState.getData());
        if (pool) {
            item = this.itemsPool.get(item);
        }
        return item;
    }

    public void commit(QPath path) throws RepositoryException, AccessDeniedException, ReferentialIntegrityException, InvalidItemStateException, ItemExistsException {
        this.validate(path);
        PlainChangesLog cLog = this.changesLog.pushLog(path);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" ----- commit -------- \n" + cLog.dump()));
        }
        try {
            this.transactionableManager.save(cLog);
            this.invalidated.clear();
        }
        catch (AccessDeniedException e) {
            this.remainChangesBack(cLog);
            throw new AccessDeniedException((Throwable)e);
        }
        catch (InvalidItemStateException e) {
            this.remainChangesBack(cLog);
            throw new InvalidItemStateException((Throwable)e);
        }
        catch (ItemExistsException e) {
            this.remainChangesBack(cLog);
            throw new ItemExistsException((Throwable)e);
        }
        catch (ReferentialIntegrityException e) {
            this.remainChangesBack(cLog);
            throw new ReferentialIntegrityException((Throwable)e);
        }
        catch (RepositoryException e) {
            this.remainChangesBack(cLog);
            throw new RepositoryException((Throwable)e);
        }
    }

    private void remainChangesBack(PlainChangesLog cLog) {
        this.changesLog.addAll(cLog.getAllStates());
        if (log.isDebugEnabled()) {
            log.debug((Object)(" ----- rollback ----- \n" + cLog.dump()));
        }
    }

    @Override
    public List<PropertyData> getReferencesData(String identifier, boolean skipVersionStorage) throws RepositoryException {
        List<PropertyData> persisted = this.transactionableManager.getReferencesData(identifier, skipVersionStorage);
        ArrayList<PropertyData> sessionTransient = new ArrayList<PropertyData>();
        for (PropertyData p : persisted) {
            sessionTransient.add(p);
        }
        return sessionTransient;
    }

    private void validate(QPath path) throws RepositoryException, AccessDeniedException, ReferentialIntegrityException {
        List<ItemState> changes = this.changesLog.getAllStates();
        for (ItemState itemState : changes) {
            if (itemState.isInternallyCreated()) {
                if (!itemState.isMixinChanged() || !itemState.isDescendantOf(path) || ((NodeData)itemState.getData()).getACL().getPermissionsSize() >= 1) continue;
                throw new RepositoryException("Node " + itemState.getData().getQPath().getAsString() + " has wrong formed ACL.");
            }
            if (itemState.isDescendantOf(path)) {
                this.validateAccessPermissions(itemState);
                this.validateMandatoryItem(itemState);
            }
            if (!path.isDescendantOf(itemState.getAncestorToSave())) continue;
            throw new ConstraintViolationException(path.getAsString() + " is the same or descendant of either Session.move()'s destination or source node only " + path.getAsString());
        }
    }

    @Deprecated
    private void validateAclSize(ItemState changedItem) throws RepositoryException {
        NodeData node;
        if (changedItem.getData().isNode()) {
            node = (NodeData)changedItem.getData();
        } else {
            node = (NodeData)this.getItemData(changedItem.getData().getParentIdentifier());
            if (node == null) {
                return;
            }
        }
        if (node.getACL().getPermissionsSize() < 1) {
            throw new RepositoryException("Node " + node.getQPath().getAsString() + " has wrong formed ACL.");
        }
    }

    private void validateAccessPermissions(ItemState changedItem) throws RepositoryException, AccessDeniedException {
        NodeData parent = (NodeData)this.getItemData(changedItem.getData().getParentIdentifier());
        if (parent != null) {
            if (changedItem.isDeleted()) {
                if (!this.accessManager.hasPermission(parent.getACL(), new String[]{"remove"}, this.session.getUserState().getIdentity())) {
                    throw new AccessDeniedException("Access denied: REMOVE " + changedItem.getData().getQPath().getAsString() + " for: " + this.session.getUserID() + " item owner " + parent.getACL().getOwner());
                }
            } else if (changedItem.getData().isNode()) {
                if (changedItem.isAdded() && !this.accessManager.hasPermission(parent.getACL(), new String[]{"add_node"}, this.session.getUserState().getIdentity())) {
                    throw new AccessDeniedException("Access denied: ADD_NODE " + changedItem.getData().getQPath().getAsString() + " for: " + this.session.getUserID() + " item owner " + parent.getACL().getOwner());
                }
            } else if ((changedItem.isAdded() || changedItem.isUpdated()) && !this.accessManager.hasPermission(parent.getACL(), new String[]{"set_property"}, this.session.getUserState().getIdentity())) {
                throw new AccessDeniedException("Access denied: SET_PROPERTY " + changedItem.getData().getQPath().getAsString() + " for: " + this.session.getUserID() + " item owner " + parent.getACL().getOwner());
            }
        }
    }

    private void validateMandatoryItem(ItemState changedItem) throws ConstraintViolationException, AccessDeniedException {
        if (changedItem.getData().isNode() && changedItem.isAdded() && !this.changesLog.getItemState(changedItem.getData().getQPath()).isDeleted() && !this.changesLog.getItemState(changedItem.getData().getIdentifier()).isDeleted()) {
            NodeData nData = (NodeData)changedItem.getData();
            try {
                NodeImpl node = this.itemFactory.createNode(nData);
                node.validateMandatoryChildren();
            }
            catch (ConstraintViolationException e) {
                throw e;
            }
            catch (AccessDeniedException e) {
                throw e;
            }
            catch (RepositoryException e) {
                log.warn((Object)("Unexpected exception. Probable wrong data. Exception message:" + e.getLocalizedMessage()));
            }
        }
    }

    void rollback(ItemData item) throws InvalidItemStateException, RepositoryException {
        PlainChangesLog slog = this.changesLog.pushLog(item.getQPath());
        SessionChangesLog changes = new SessionChangesLog(slog.getAllStates(), this.session.getId());
        String exceptions = "";
        Iterator<ItemImpl> removedIter = this.invalidated.iterator();
        while (removedIter.hasNext()) {
            ItemData persisted;
            ItemImpl removed = removedIter.next();
            QPath removedPath = removed.getLocation().getInternalPath();
            ItemState rstate = changes.getItemState(removedPath);
            if (rstate == null) {
                exceptions = exceptions + "Can't find removed item " + removed.getLocation().getAsString(false) + " in changes for rollback.\n";
                continue;
            }
            if (rstate.getState() == 32 && (rstate = changes.findItemState(rstate.getData().getIdentifier(), (Boolean)false, 4)) == null) {
                exceptions = exceptions + "Can't find removed item (of move operation) " + removed.getLocation().getAsString(false) + " in changes for rollback.\n";
                continue;
            }
            NodeData parent = (NodeData)this.transactionableManager.getItemData(rstate.getData().getParentIdentifier());
            if (parent != null && (persisted = this.transactionableManager.getItemData(parent, rstate.getData().getQPath().getEntries()[rstate.getData().getQPath().getEntries().length - 1])) != null) {
                removed.loadData(persisted);
            }
            removedIter.remove();
        }
        if (exceptions.length() > 0 && log.isDebugEnabled()) {
            log.warn((Object)exceptions);
        }
    }

    void refresh(ItemData item) throws InvalidItemStateException, RepositoryException {
        if (!this.isModified(item) && this.itemsPool.contains(item.getIdentifier())) {
            NodeData parent;
            ItemData persisted = this.transactionableManager.getItemData(item.getIdentifier());
            if (persisted == null && (parent = (NodeData)this.transactionableManager.getItemData(item.getParentIdentifier())) != null) {
                QPathEntry[] path = item.getQPath().getEntries();
                persisted = this.transactionableManager.getItemData(parent, path[path.length - 1]);
            }
            if (persisted != null) {
                this.itemsPool.reload(item.getIdentifier(), persisted);
                for (ItemImpl pooled : this.itemsPool.getDescendats(persisted.getQPath())) {
                    NodeData parent2;
                    persisted = this.transactionableManager.getItemData(pooled.getInternalIdentifier());
                    if (persisted == null && (parent2 = (NodeData)this.transactionableManager.getItemData(pooled.getParentIdentifier())) != null) {
                        QPathEntry[] path = pooled.getData().getQPath().getEntries();
                        persisted = this.transactionableManager.getItemData(parent2, path[path.length - 1]);
                    }
                    if (persisted == null) continue;
                    this.itemsPool.reload(pooled.getInternalIdentifier(), persisted);
                }
            } else {
                throw new InvalidItemStateException("An item is transient only or removed (either by this session or another) " + this.session.getLocationFactory().createJCRPath(item.getQPath()).getAsString(false));
            }
        }
    }

    protected ItemReferencePool getItemsPool() {
        return this.itemsPool;
    }

    protected SessionChangesLog getChangesLog() {
        return this.changesLog;
    }

    protected List<? extends ItemData> merge(ItemData rootData, DataManager dataManager, boolean deep, int action) throws RepositoryException {
        LinkedHashMap<String, ItemData> descendants = new LinkedHashMap<String, ItemData>();
        this.traverseStoredDescendants(rootData, dataManager, false, action, descendants, false);
        ArrayList<ItemState> transientDescendants = new ArrayList<ItemState>();
        this.traverseTransientDescendants(rootData, false, action, transientDescendants);
        for (ItemState state : transientDescendants) {
            ItemData data = state.getData();
            if (!state.isDeleted()) {
                descendants.put(data.getIdentifier(), data);
                continue;
            }
            descendants.remove(data.getIdentifier());
        }
        ArrayList<? extends ItemData> retval = new ArrayList<ItemData>();
        Collection desc = descendants.values();
        for (ItemData itemData : desc) {
            retval.add(itemData);
            if (!deep) continue;
            retval.addAll(this.merge(itemData, dataManager, true, action));
        }
        return retval;
    }

    protected List<? extends ItemData> mergeList(ItemData rootData, DataManager dataManager, boolean deep, int action) throws RepositoryException {
        LinkedHashMap<String, ItemData> descendants = new LinkedHashMap<String, ItemData>();
        this.traverseStoredDescendants(rootData, dataManager, false, action, descendants, true);
        ArrayList<ItemState> transientDescendants = new ArrayList<ItemState>();
        this.traverseTransientDescendants(rootData, false, action, transientDescendants);
        for (ItemState state : transientDescendants) {
            ItemData data = state.getData();
            if (!state.isDeleted()) {
                descendants.put(data.getIdentifier(), data);
                continue;
            }
            descendants.remove(data.getIdentifier());
        }
        ArrayList<? extends ItemData> retval = new ArrayList<ItemData>();
        Collection desc = descendants.values();
        for (ItemData itemData : desc) {
            retval.add(itemData);
            if (!deep) continue;
            retval.addAll(this.mergeList(itemData, dataManager, true, action));
        }
        return retval;
    }

    private void traverseStoredDescendants(ItemData parent, DataManager dataManager, boolean deep, int action, Map<String, ItemData> ret, boolean listOnly) throws RepositoryException {
        if (parent.isNode()) {
            if (action != 2) {
                List<NodeData> childNodes = dataManager.getChildNodesData((NodeData)parent);
                for (NodeData childNode : childNodes) {
                    ret.put(childNode.getIdentifier(), childNode);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Traverse stored (N) " + childNode.getQPath().getAsString()));
                    }
                    if (!deep) continue;
                    this.traverseStoredDescendants(childNode, dataManager, deep, action, ret, listOnly);
                }
            }
            if (action != 1) {
                List<PropertyData> childProps = listOnly ? dataManager.listChildPropertiesData((NodeData)parent) : dataManager.getChildPropertiesData((NodeData)parent);
                for (PropertyData childProp : childProps) {
                    ret.put(childProp.getIdentifier(), childProp);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Traverse stored (P) " + childProp.getQPath().getAsString()));
                }
            }
        }
    }

    private void traverseTransientDescendants(ItemData parent, boolean deep, int action, List<ItemState> ret) throws RepositoryException {
        if (parent.isNode()) {
            if (action != 2) {
                Collection<ItemState> childNodes = this.changesLog.getLastChildrenStates(parent, true);
                for (ItemState childNode : childNodes) {
                    ret.add(childNode);
                    if (!deep) continue;
                    this.traverseTransientDescendants(childNode.getData(), deep, action, ret);
                }
            }
            if (action != 1) {
                Collection<ItemState> childProps = this.changesLog.getLastChildrenStates(parent, false);
                for (ItemState childProp : childProps) {
                    ret.add(childProp);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PathSorter
    implements Comparator<ItemState> {
        private PathSorter() {
        }

        @Override
        public int compare(ItemState i1, ItemState i2) {
            return -i1.getData().getQPath().compareTo(i2.getData().getQPath());
        }
    }

    private class SessionItemFactory {
        private SessionItemFactory() {
        }

        private ItemImpl createItem(ItemData data) throws RepositoryException {
            if (data.isNode()) {
                return this.createNode((NodeData)data);
            }
            return this.createProperty(data);
        }

        private NodeImpl createNode(NodeData data) throws RepositoryException {
            NodeImpl node = new NodeImpl(data, SessionDataManager.this.session);
            if (node.isNodeType(Constants.NT_VERSION)) {
                return new VersionImpl(data, SessionDataManager.this.session);
            }
            if (node.isNodeType(Constants.NT_VERSIONHISTORY)) {
                return new VersionHistoryImpl(data, SessionDataManager.this.session);
            }
            return node;
        }

        private PropertyImpl createProperty(ItemData data) throws RepositoryException {
            return new PropertyImpl(data, SessionDataManager.this.session);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class ItemReferencePool {
        private WeakHashMap<String, ItemImpl> items = new WeakHashMap();

        ItemReferencePool() {
        }

        ItemImpl remove(String identifier) {
            return this.items.remove(identifier);
        }

        Collection<ItemImpl> getAll() {
            return this.items.values();
        }

        int size() {
            return this.items.size();
        }

        boolean contains(String identifier) {
            return this.items.containsKey(identifier);
        }

        ItemImpl get(ItemImpl newItem) throws RepositoryException {
            String identifier = newItem.getInternalIdentifier();
            ItemImpl item = this.items.get(identifier);
            if (item == null) {
                this.items.put(identifier, newItem);
                return newItem;
            }
            item.loadData(newItem.getData());
            return item;
        }

        ItemImpl reload(ItemData itemData) throws RepositoryException {
            return this.reload(itemData.getIdentifier(), itemData);
        }

        ItemImpl reload(String identifier, ItemData newItemData) throws RepositoryException {
            ItemImpl item = this.items.get(identifier);
            if (item != null) {
                item.loadData(newItemData);
                return item;
            }
            return null;
        }

        @Deprecated
        List<NodeImpl> getNodes(List<NodeImpl> nodes) throws RepositoryException {
            ArrayList<NodeImpl> children = new ArrayList<NodeImpl>();
            for (NodeImpl node : nodes) {
                String id = node.getInternalIdentifier();
                NodeImpl pooled = (NodeImpl)this.items.get(id);
                if (pooled == null) {
                    this.items.put(id, node);
                    children.add(node);
                    continue;
                }
                pooled.loadData(node.getData());
                children.add(pooled);
            }
            return children;
        }

        @Deprecated
        List<PropertyImpl> getProperties(List<PropertyImpl> props) throws RepositoryException {
            ArrayList<PropertyImpl> children = new ArrayList<PropertyImpl>();
            for (PropertyImpl prop : props) {
                String id = prop.getInternalIdentifier();
                PropertyImpl pooled = (PropertyImpl)this.items.get(id);
                if (pooled == null) {
                    this.items.put(id, prop);
                    children.add(prop);
                    continue;
                }
                pooled.loadData(prop.getData());
                children.add(pooled);
            }
            return children;
        }

        List<ItemImpl> getDescendats(QPath parentPath) {
            ArrayList<ItemImpl> desc = new ArrayList<ItemImpl>();
            Collection<ItemImpl> snapshort = this.items.values();
            for (ItemImpl pitem : snapshort) {
                if (!pitem.getData().getQPath().isDescendantOf(parentPath)) continue;
                desc.add(pitem);
            }
            return desc;
        }

        String dump() {
            String str = "Items Pool: \n";
            for (ItemImpl item : this.items.values()) {
                str = str + (item.isNode() ? "Node\t\t" : "Property\t") + "\t" + item.isValid() + "\t" + item.isNew() + "\t" + item.getInternalIdentifier() + "\t" + item.getPath() + "\n";
            }
            return str;
        }
    }
}

