/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListener;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.dataflow.TransientItemData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ReadOnlyWorkspaceException;
import org.exoplatform.services.jcr.impl.storage.SystemDataContainerHolder;
import org.exoplatform.services.jcr.storage.WorkspaceDataContainer;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkspacePersistentDataManager
implements DataManager {
    protected final Log log = ExoLogger.getLogger((String)"jcr.WorkspacePersistentDataManager");
    protected WorkspaceDataContainer dataContainer;
    protected WorkspaceDataContainer systemDataContainer;
    protected List<ItemsPersistenceListener> listeners;

    public WorkspacePersistentDataManager(WorkspaceDataContainer dataContainer, SystemDataContainerHolder systemDataContainerHolder) {
        this.dataContainer = dataContainer;
        this.listeners = new ArrayList<ItemsPersistenceListener>();
        this.systemDataContainer = systemDataContainerHolder.getContainer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(ItemStateChangesLog changesLog) throws RepositoryException {
        Object systemConnection;
        Object thisConnection;
        HashSet<QPath> addedNodes;
        block16: {
            if (this.dataContainer.isReadOnly()) {
                throw new ReadOnlyWorkspaceException("Workspace container '" + this.dataContainer.getName() + "' is read-only.");
            }
            List<ItemState> changes = changesLog.getAllStates();
            addedNodes = new HashSet<QPath>();
            thisConnection = null;
            systemConnection = null;
            try {
                for (ItemState itemState : changes) {
                    if (!itemState.isPersisted()) continue;
                    long start = System.currentTimeMillis();
                    TransientItemData data = (TransientItemData)itemState.getData();
                    Object conn = null;
                    conn = this.isSystemDescendant(data.getQPath()) ? (systemConnection == null ? (systemConnection = this.systemDataContainer != this.dataContainer ? (this.systemDataContainer.equals(this.dataContainer) && thisConnection != null ? this.systemDataContainer.reuseConnection((WorkspaceStorageConnection)thisConnection) : this.systemDataContainer.openConnection()) : (thisConnection == null ? this.dataContainer.openConnection() : thisConnection)) : systemConnection) : (thisConnection == null ? (thisConnection = this.systemDataContainer != this.dataContainer ? (this.dataContainer.equals(this.systemDataContainer) && systemConnection != null ? this.dataContainer.reuseConnection((WorkspaceStorageConnection)systemConnection) : this.dataContainer.openConnection()) : (systemConnection == null ? this.dataContainer.openConnection() : systemConnection)) : thisConnection);
                    data.increasePersistedVersion();
                    if (itemState.isAdded()) {
                        this.doAdd(data, (WorkspaceStorageConnection)conn, addedNodes);
                    } else if (itemState.isUpdated()) {
                        this.doUpdate(data, (WorkspaceStorageConnection)conn);
                    } else if (itemState.isDeleted()) {
                        this.doDelete(data, (WorkspaceStorageConnection)conn);
                    } else if (itemState.isRenamed()) {
                        this.doRename(data, (WorkspaceStorageConnection)conn, addedNodes);
                    }
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)(ItemState.nameFromValue(itemState.getState()) + " " + (System.currentTimeMillis() - start) + "ms, " + data.getQPath().getAsString()));
                }
                if (thisConnection != null) {
                    thisConnection.commit();
                }
                if (systemConnection != null && !systemConnection.equals(thisConnection)) {
                    systemConnection.commit();
                }
                Object var13_11 = null;
                if (thisConnection == null || !thisConnection.isOpened()) break block16;
            }
            catch (Throwable throwable) {
                Object var13_12 = null;
                if (thisConnection != null && thisConnection.isOpened()) {
                    thisConnection.rollback();
                }
                if (systemConnection != null && !systemConnection.equals(thisConnection) && systemConnection.isOpened()) {
                    systemConnection.rollback();
                }
                addedNodes.clear();
                throw throwable;
            }
            thisConnection.rollback();
        }
        if (systemConnection != null && !systemConnection.equals(thisConnection) && systemConnection.isOpened()) {
            systemConnection.rollback();
        }
        addedNodes.clear();
        this.notifySaveItems(changesLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemData getItemData(String identifier) throws RepositoryException {
        ItemData itemData;
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        ItemData result = null;
        try {
            itemData = result = con.getItemData(identifier);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            block3: {
                Object var6_6 = null;
                con.close();
                if (!this.log.isDebugEnabled()) break block3;
                this.log.debug((Object)("GET " + identifier + " => " + (result != null ? result.getQPath().getAsString() : null)));
            }
            throw throwable;
        }
        con.close();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("GET " + identifier + " => " + (result != null ? result.getQPath().getAsString() : null)));
        }
        return itemData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemData getItemData(NodeData parentData, QPathEntry name) throws RepositoryException {
        ItemData itemData;
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        ItemData result = null;
        try {
            itemData = result = con.getItemData(parentData, name);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            block3: {
                Object var7_7 = null;
                con.close();
                if (!this.log.isDebugEnabled()) break block3;
                this.log.debug((Object)("GET " + parentData.getQPath().getAsString() + name.getAsString(true) + " => " + (result != null ? result.getQPath().getAsString() : null)));
            }
            throw throwable;
        }
        con.close();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("GET " + parentData.getQPath().getAsString() + name.getAsString(true) + " => " + (result != null ? result.getQPath().getAsString() : null)));
        }
        return itemData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> getReferencesData(String identifier, boolean skipVersionStorage) throws RepositoryException {
        ArrayList<PropertyData> arrayList;
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        ArrayList<PropertyData> refProps = new ArrayList<PropertyData>();
        try {
            List<PropertyData> allRefs = con.getReferencesData(identifier);
            for (int i = 0; i < allRefs.size(); ++i) {
                PropertyData ref = allRefs.get(i);
                if (skipVersionStorage) {
                    if (ref.getQPath().isDescendantOf(Constants.JCR_VERSION_STORAGE_PATH)) continue;
                    refProps.add(ref);
                    continue;
                }
                refProps.add(ref);
            }
            arrayList = refProps;
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            block5: {
                Object var9_10 = null;
                con.close();
                if (!this.log.isDebugEnabled()) break block5;
                this.log.debug((Object)("GET REF " + identifier + " => " + (refProps != null ? Integer.valueOf(refProps.size()) : null)));
            }
            throw throwable;
        }
        con.close();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("GET REF " + identifier + " => " + (refProps != null ? Integer.valueOf(refProps.size()) : null)));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NodeData> getChildNodesData(NodeData nodeData) throws RepositoryException {
        List<NodeData> list;
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        List<NodeData> result = null;
        try {
            list = result = con.getChildNodesData(nodeData);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            block3: {
                Object var6_6 = null;
                con.close();
                if (!this.log.isDebugEnabled()) break block3;
                this.log.debug((Object)("GET CN " + nodeData.getQPath().getAsString() + " => " + (result != null ? Integer.valueOf(result.size()) : null)));
            }
            throw throwable;
        }
        con.close();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("GET CN " + nodeData.getQPath().getAsString() + " => " + (result != null ? Integer.valueOf(result.size()) : null)));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> getChildPropertiesData(NodeData nodeData) throws RepositoryException {
        List<PropertyData> list;
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        List<PropertyData> result = null;
        try {
            list = result = con.getChildPropertiesData(nodeData);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            block3: {
                Object var6_6 = null;
                con.close();
                if (!this.log.isDebugEnabled()) break block3;
                this.log.debug((Object)("GET CP " + nodeData.getQPath().getAsString() + " => " + (result != null ? Integer.valueOf(result.size()) : null)));
            }
            throw throwable;
        }
        con.close();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("GET CP " + nodeData.getQPath().getAsString() + " => " + (result != null ? Integer.valueOf(result.size()) : null)));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> listChildPropertiesData(NodeData nodeData) throws RepositoryException {
        List<PropertyData> list;
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        List<PropertyData> result = null;
        try {
            list = result = con.listChildPropertiesData(nodeData);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            block3: {
                Object var6_6 = null;
                con.close();
                if (!this.log.isDebugEnabled()) break block3;
                this.log.debug((Object)("GET CP LIST " + nodeData.getQPath().getAsString() + " => " + (result != null ? Integer.valueOf(result.size()) : null)));
            }
            throw throwable;
        }
        con.close();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("GET CP LIST " + nodeData.getQPath().getAsString() + " => " + (result != null ? Integer.valueOf(result.size()) : null)));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSameNameSibling(NodeData node, WorkspaceStorageConnection con, Set<QPath> addedNodes) throws RepositoryException {
        if (node.getQPath().getIndex() > 1) {
            QPathEntry[] path = node.getQPath().getEntries();
            QPathEntry[] siblingPath = new QPathEntry[path.length];
            int li = path.length - 1;
            System.arraycopy(path, 0, siblingPath, 0, li);
            siblingPath[li] = new QPathEntry(path[li], path[li].getIndex() - 1);
            if (addedNodes.contains(new QPath(siblingPath))) {
                return;
            }
            WorkspaceStorageConnection acon = this.dataContainer.openConnection();
            try {
                NodeData parent = (NodeData)acon.getItemData(node.getParentIdentifier());
                QPathEntry myName = node.getQPath().getEntries()[node.getQPath().getEntries().length - 1];
                ItemData sibling = acon.getItemData(parent, new QPathEntry(myName.getNamespace(), myName.getName(), myName.getIndex() - 1));
                if (sibling == null || !sibling.isNode()) {
                    throw new InvalidItemStateException("Node can't be saved " + node.getQPath().getAsString() + ". No same-name sibling exists with index " + (myName.getIndex() - 1) + ".");
                }
                Object var12_11 = null;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                acon.rollback();
                throw throwable;
            }
            acon.rollback();
            {
            }
        }
    }

    protected void doDelete(TransientItemData item, WorkspaceStorageConnection con) throws RepositoryException, InvalidItemStateException {
        if (item.isNode()) {
            con.delete((NodeData)((Object)item));
        } else {
            con.delete((PropertyData)((Object)item));
        }
    }

    protected void doUpdate(TransientItemData item, WorkspaceStorageConnection con) throws RepositoryException, InvalidItemStateException {
        if (item.isNode()) {
            con.update((NodeData)((Object)item));
        } else {
            con.update((PropertyData)((Object)item));
        }
    }

    protected void doAdd(TransientItemData item, WorkspaceStorageConnection con, Set<QPath> addedNodes) throws RepositoryException, InvalidItemStateException {
        if (item.isNode()) {
            NodeData node = (NodeData)((Object)item);
            this.checkSameNameSibling(node, con, addedNodes);
            addedNodes.add(node.getQPath());
            con.add(node);
        } else {
            con.add((PropertyData)((Object)item));
        }
    }

    protected void doRename(TransientItemData item, WorkspaceStorageConnection con, Set<QPath> addedNodes) throws RepositoryException, InvalidItemStateException {
        NodeData node = (NodeData)((Object)item);
        this.checkSameNameSibling(node, con, addedNodes);
        addedNodes.add(node.getQPath());
        con.rename(node);
    }

    public Calendar getCurrentTime() {
        return this.dataContainer.getCurrentTime();
    }

    public void addItemPersistenceListener(ItemsPersistenceListener listener) {
        this.listeners.add(listener);
        this.log.info((Object)("Workspace Data manager of '" + this.dataContainer.getName() + "' registered listener: " + listener));
    }

    protected void notifySaveItems(ItemStateChangesLog changesLog) {
        for (ItemsPersistenceListener listener : this.listeners) {
            listener.onSaveItems(changesLog);
        }
    }

    private boolean isSystemDescendant(QPath path) {
        return path.isDescendantOf(Constants.JCR_SYSTEM_PATH) || path.equals(Constants.JCR_SYSTEM_PATH);
    }
}

