/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;

class MultiScorer
extends Scorer {
    private final Scorer[] scorers;
    private final int[] starts;
    private int current = 0;
    private boolean hasNext = true;

    MultiScorer(Similarity similarity, Scorer[] scorers, int[] starts) {
        super(similarity);
        this.scorers = scorers;
        this.starts = starts;
    }

    public boolean next() throws IOException {
        while (this.hasNext) {
            if (this.scorers[this.current].next()) {
                return true;
            }
            if (++this.current < this.scorers.length) continue;
            this.hasNext = false;
        }
        return this.hasNext;
    }

    public int doc() {
        return this.scorers[this.current].doc() + this.starts[this.current];
    }

    public float score() throws IOException {
        return this.scorers[this.current].score();
    }

    public boolean skipTo(int target) throws IOException {
        this.current = this.scorerIndex(target);
        if (this.scorers[this.current].skipTo(target - this.starts[this.current])) {
            return true;
        }
        if (++this.current < this.scorers.length) {
            return this.next();
        }
        this.hasNext = false;
        return false;
    }

    public Explanation explain(int doc) throws IOException {
        int scorerIndex = this.scorerIndex(doc);
        return this.scorers[scorerIndex].explain(doc - this.starts[scorerIndex]);
    }

    private int scorerIndex(int n) {
        int lo = 0;
        int hi = this.scorers.length - 1;
        while (hi >= lo) {
            int mid = lo + hi >> 1;
            int midValue = this.starts[mid];
            if (n < midValue) {
                hi = mid - 1;
                continue;
            }
            if (n > midValue) {
                lo = mid + 1;
                continue;
            }
            while (mid + 1 < this.scorers.length && this.starts[mid + 1] == midValue) {
                ++mid;
            }
            return mid;
        }
        return hi;
    }
}

