/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.util;

import java.text.ParseException;
import java.util.Calendar;
import java.util.TimeZone;
import javax.jcr.ValueFormatException;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.services.log.ExoLogger;

public class JCRDateFormat {
    public static Log log = ExoLogger.getLogger((String)"jcr.JCRDateFormat");
    protected static final String[] JCR_FORMATS = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSTZD", "yyyy-MM-dd'T'HH:mm:ss.SSSZ"};
    protected static final String CALENDAR_FIELDS_DELIMITER = ";";
    protected static final String CALENDAR_FIELDS_SEPARATOR = "--";

    public static String format(Calendar date) {
        return ISO8601.format((Calendar)date);
    }

    public static Calendar parse(String dateString) throws ValueFormatException {
        try {
            return ISO8601.parseEx((String)dateString);
        }
        catch (ParseException e) {
            throw new ValueFormatException("Can not parse date from [" + dateString + "]", (Throwable)e);
        }
        catch (NumberFormatException e) {
            throw new ValueFormatException("Can not parse date from [" + dateString + "]", (Throwable)e);
        }
    }

    public Calendar deserialize(String serString) throws ValueFormatException {
        String[] parts = serString.split(CALENDAR_FIELDS_SEPARATOR);
        if (parts.length == 2) {
            Calendar isoCalendar = null;
            try {
                isoCalendar = ISO8601.parse((String)parts[0], (String[])JCR_FORMATS);
                String[] calendarFields = parts[1].split(CALENDAR_FIELDS_DELIMITER);
                if (calendarFields.length == 4) {
                    try {
                        isoCalendar.setLenient(Boolean.parseBoolean(calendarFields[0]));
                        isoCalendar.setFirstDayOfWeek(Integer.parseInt(calendarFields[1]));
                        isoCalendar.setMinimalDaysInFirstWeek(Integer.parseInt(calendarFields[2]));
                        isoCalendar.setTimeZone(TimeZone.getTimeZone(calendarFields[3]));
                    }
                    catch (Exception e) {
                        log.warn((Object)("Can't parse serialized fields for the calendar [" + parts[1] + "] but calendar has [" + isoCalendar.getTime() + "]"), (Throwable)e);
                    }
                } else {
                    log.warn((Object)("Fields of the calendar is not serialized properly [" + parts[1] + "] but calendar has [" + isoCalendar.getTime() + "]"));
                }
            }
            catch (ParseException e) {
                throw new ValueFormatException((Throwable)e);
            }
            return isoCalendar;
        }
        throw new ValueFormatException("Can't deserialize calendar string [" + serString + "]");
    }

    public byte[] serialize(Calendar date) {
        String calendarString = CALENDAR_FIELDS_SEPARATOR + date.isLenient() + CALENDAR_FIELDS_DELIMITER + date.getFirstDayOfWeek() + CALENDAR_FIELDS_DELIMITER + date.getMinimalDaysInFirstWeek() + CALENDAR_FIELDS_DELIMITER + date.getTimeZone().getID();
        return (JCRDateFormat.format(date) + calendarString).getBytes();
    }
}

