/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel;

import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterIOException;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSStream;
import org.pdfbox.cos.COSString;
import org.pdfbox.encryption.DocumentEncryption;
import org.pdfbox.encryption.PDFEncryption;
import org.pdfbox.exceptions.COSVisitorException;
import org.pdfbox.exceptions.CryptographyException;
import org.pdfbox.exceptions.InvalidPasswordException;
import org.pdfbox.pdfparser.PDFParser;
import org.pdfbox.pdfwriter.COSWriter;
import org.pdfbox.pdmodel.PDDocumentCatalog;
import org.pdfbox.pdmodel.PDDocumentInformation;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.PDPageNode;
import org.pdfbox.pdmodel.common.PDRectangle;
import org.pdfbox.pdmodel.common.PDStream;
import org.pdfbox.pdmodel.encryption.PDEncryptionDictionary;
import org.pdfbox.pdmodel.encryption.PDEncryptionManager;
import org.pdfbox.pdmodel.encryption.PDStandardEncryption;

public class PDDocument
implements Pageable {
    private COSDocument document;
    private boolean encryptOnSave = false;
    private String encryptUserPassword = null;
    private String encryptOwnerPassword = null;
    private PDDocumentInformation documentInformation;
    private PDDocumentCatalog documentCatalog;
    private PDEncryptionDictionary encParameters = null;
    private boolean decryptedWithOwnerPassword = false;

    public PDDocument() throws IOException {
        this.document = new COSDocument();
        COSDictionary trailer = new COSDictionary();
        this.document.setTrailer(trailer);
        COSDictionary rootDictionary = new COSDictionary();
        trailer.setItem(COSName.ROOT, (COSBase)rootDictionary);
        rootDictionary.setItem(COSName.TYPE, (COSBase)COSName.CATALOG);
        rootDictionary.setItem(COSName.VERSION, (COSBase)COSName.getPDFName("1.4"));
        COSDictionary pages = new COSDictionary();
        rootDictionary.setItem(COSName.PAGES, (COSBase)pages);
        pages.setItem(COSName.TYPE, (COSBase)COSName.PAGES);
        COSArray kidsArray = new COSArray();
        pages.setItem(COSName.KIDS, (COSBase)kidsArray);
        pages.setItem(COSName.COUNT, (COSBase)new COSInteger(0));
    }

    public void addPage(PDPage page) {
        PDPageNode rootPages = this.getDocumentCatalog().getPages();
        rootPages.getKids().add(page);
        page.setParent(rootPages);
        rootPages.updateCount();
    }

    public boolean removePage(PDPage page) {
        PDPageNode parent = page.getParent();
        boolean retval = parent.getKids().remove(page);
        if (retval) {
            this.getDocumentCatalog().getPages().updateCount();
        }
        return retval;
    }

    public boolean removePage(int pageNumber) {
        boolean removed = false;
        List allPages = this.getDocumentCatalog().getAllPages();
        if (allPages.size() > pageNumber) {
            PDPage page = (PDPage)allPages.get(pageNumber);
            removed = this.removePage(page);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDPage importPage(PDPage page) throws IOException {
        OutputStream os;
        PDPage importedPage;
        block6: {
            importedPage = new PDPage(new COSDictionary(page.getCOSDictionary()));
            InputStream is = null;
            os = null;
            try {
                PDStream src = page.getContents();
                PDStream dest = new PDStream(new COSStream(src.getStream(), this.document.getScratchFile()));
                importedPage.setContents(dest);
                os = dest.createOutputStream();
                byte[] buf = new byte[10240];
                int amountRead = 0;
                is = src.createInputStream();
                while ((amountRead = is.read(buf, 0, 10240)) > -1) {
                    os.write(buf, 0, amountRead);
                }
                this.addPage(importedPage);
                Object var10_9 = null;
                if (is == null) break block6;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
                throw throwable;
            }
            is.close();
        }
        if (os != null) {
            os.close();
        }
        return importedPage;
    }

    public PDDocument(COSDocument doc) {
        this.document = doc;
    }

    public COSDocument getDocument() {
        return this.document;
    }

    public PDDocumentInformation getDocumentInformation() {
        if (this.documentInformation == null) {
            COSDictionary trailer = this.document.getTrailer();
            COSDictionary infoDic = (COSDictionary)trailer.getDictionaryObject(COSName.INFO);
            if (infoDic == null) {
                infoDic = new COSDictionary();
                trailer.setItem(COSName.INFO, (COSBase)infoDic);
            }
            this.documentInformation = new PDDocumentInformation(infoDic);
        }
        return this.documentInformation;
    }

    public void setDocumentInformation(PDDocumentInformation info) {
        this.documentInformation = info;
        this.document.getTrailer().setItem(COSName.INFO, (COSBase)info.getDictionary());
    }

    public PDDocumentCatalog getDocumentCatalog() {
        if (this.documentCatalog == null) {
            COSDictionary trailer = this.document.getTrailer();
            COSDictionary infoDic = (COSDictionary)trailer.getDictionaryObject(COSName.ROOT);
            this.documentCatalog = infoDic == null ? new PDDocumentCatalog(this) : new PDDocumentCatalog(this, infoDic);
        }
        return this.documentCatalog;
    }

    public boolean isEncrypted() {
        return this.document.isEncrypted();
    }

    public PDEncryptionDictionary getEncryptionDictionary() throws IOException {
        if (this.encParameters == null) {
            this.encParameters = PDEncryptionManager.getEncryptionDictionary(this.document.getEncryptionDictionary());
        }
        return this.encParameters;
    }

    public void setEncryptionDictionary(PDEncryptionDictionary encDictionary) throws IOException {
        this.encParameters = encDictionary;
    }

    public boolean isUserPassword(String password) throws IOException, CryptographyException {
        boolean retval = false;
        if (password == null) {
            password = "";
        }
        PDFEncryption encryptor = new PDFEncryption();
        PDEncryptionDictionary encryptionDictionary = this.getEncryptionDictionary();
        if (encryptionDictionary == null) {
            throw new IOException("Error: Document is not encrypted");
        }
        if (!(encryptionDictionary instanceof PDStandardEncryption)) {
            throw new IOException("Error: Encyption dictionary is not 'Standard'" + encryptionDictionary.getClass().getName());
        }
        COSString documentID = (COSString)this.document.getDocumentID().get(0);
        PDStandardEncryption standard = (PDStandardEncryption)encryptionDictionary;
        retval = encryptor.isUserPassword(password.getBytes(), standard.getUserKey(), standard.getOwnerKey(), standard.getPermissions(), documentID.getBytes(), standard.getRevision(), standard.getLength() / 8);
        return retval;
    }

    public boolean isOwnerPassword(String password) throws IOException, CryptographyException {
        boolean retval = false;
        if (password == null) {
            password = "";
        }
        PDFEncryption encryptor = new PDFEncryption();
        PDEncryptionDictionary encryptionDictionary = this.getEncryptionDictionary();
        if (encryptionDictionary == null) {
            throw new IOException("Error: Document is not encrypted");
        }
        if (!(encryptionDictionary instanceof PDStandardEncryption)) {
            throw new IOException("Error: Encyption dictionary is not 'Standard'" + encryptionDictionary.getClass().getName());
        }
        COSString documentID = (COSString)this.document.getDocumentID().get(0);
        PDStandardEncryption standard = (PDStandardEncryption)encryptionDictionary;
        retval = encryptor.isOwnerPassword(password.getBytes(), standard.getUserKey(), standard.getOwnerKey(), standard.getPermissions(), documentID.getBytes(), standard.getRevision(), standard.getLength() / 8);
        return retval;
    }

    public void decrypt(String password) throws CryptographyException, IOException, InvalidPasswordException {
        this.decryptedWithOwnerPassword = this.isOwnerPassword(password);
        DocumentEncryption decryptor = new DocumentEncryption(this);
        decryptor.decryptDocument(password);
        this.document.dereferenceObjectStreams();
    }

    public boolean wasDecryptedWithOwnerPassword() {
        return this.decryptedWithOwnerPassword;
    }

    public void encrypt(String ownerPassword, String userPassword) throws CryptographyException, IOException {
        this.encryptOnSave = true;
        this.encryptOwnerPassword = ownerPassword;
        this.encryptUserPassword = userPassword;
    }

    public String getOwnerPasswordForEncryption() {
        return this.encryptOwnerPassword;
    }

    public String getUserPasswordForEncryption() {
        return this.encryptUserPassword;
    }

    public boolean willEncryptWhenSaving() {
        return this.encryptOnSave;
    }

    public void clearWillEncryptWhenSaving() {
        this.encryptOnSave = false;
    }

    public static PDDocument load(String filename) throws IOException {
        return PDDocument.load(new BufferedInputStream(new FileInputStream(filename)));
    }

    public static PDDocument load(File file) throws IOException {
        return PDDocument.load(new BufferedInputStream(new FileInputStream(file)));
    }

    public static PDDocument load(InputStream input) throws IOException {
        PDFParser parser = new PDFParser(input);
        parser.parse();
        return parser.getPDDocument();
    }

    public void save(String fileName) throws IOException, COSVisitorException {
        this.save(new FileOutputStream(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(OutputStream output) throws IOException, COSVisitorException {
        this.getDocumentCatalog().getPages().updateCount();
        COSWriter writer = null;
        try {
            writer = new COSWriter(output);
            writer.write(this);
            writer.close();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public int getPageCount() {
        return this.getNumberOfPages();
    }

    public int getNumberOfPages() {
        PDDocumentCatalog cat = this.getDocumentCatalog();
        return (int)cat.getPages().getCount();
    }

    public PageFormat getPageFormat(int pageIndex) {
        PDPage page = (PDPage)this.getDocumentCatalog().getAllPages().get(pageIndex);
        PDRectangle mediaBox = page.findMediaBox();
        PageFormat format = new PageFormat();
        Paper paper = new Paper();
        paper.setImageableArea(0.0, 0.0, mediaBox.getWidth(), mediaBox.getHeight());
        paper.setSize(mediaBox.getWidth(), mediaBox.getHeight());
        format.setPaper(paper);
        return format;
    }

    public Printable getPrintable(int pageIndex) {
        return (Printable)this.getDocumentCatalog().getAllPages().get(pageIndex);
    }

    public void print() throws PrinterException {
        PDStandardEncryption stdEncryption;
        PDEncryptionDictionary encDictionary = null;
        try {
            encDictionary = this.getEncryptionDictionary();
        }
        catch (IOException io) {
            throw new PrinterIOException(io);
        }
        if (encDictionary instanceof PDStandardEncryption && !this.wasDecryptedWithOwnerPassword() && !(stdEncryption = (PDStandardEncryption)encDictionary).canPrint()) {
            throw new PrinterException("You do not have permission to print this document.");
        }
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPageable(this);
        if (printJob.printDialog()) {
            printJob.print();
        }
    }

    public void close() throws IOException {
        this.document.close();
    }
}

