/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterIOException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.cos.COSStream;
import org.pdfbox.pdfviewer.PageDrawer;
import org.pdfbox.pdmodel.PDPageNode;
import org.pdfbox.pdmodel.PDResources;
import org.pdfbox.pdmodel.common.COSArrayList;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.pdmodel.common.PDMetadata;
import org.pdfbox.pdmodel.common.PDRectangle;
import org.pdfbox.pdmodel.common.PDStream;
import org.pdfbox.pdmodel.interactive.action.PDPageAdditionalActions;
import org.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.pdfbox.pdmodel.interactive.pagenavigation.PDThreadBead;

public class PDPage
implements COSObjectable,
Printable {
    private COSDictionary page;
    public static final PDRectangle PAGE_SIZE_LETTER = new PDRectangle(612.0f, 792.0f);

    public PDPage() {
        this.page = new COSDictionary();
        this.page.setItem(COSName.TYPE, (COSBase)COSName.PAGE);
        this.setMediaBox(PAGE_SIZE_LETTER);
    }

    public PDPage(COSDictionary pageDic) {
        this.page = pageDic;
    }

    public COSBase getCOSObject() {
        return this.page;
    }

    public COSDictionary getCOSDictionary() {
        return this.page;
    }

    public PDPageNode getParent() {
        PDPageNode parent = null;
        COSDictionary parentDic = (COSDictionary)this.page.getDictionaryObject(COSName.PARENT);
        if (parentDic != null) {
            parent = new PDPageNode(parentDic);
        }
        return parent;
    }

    public void setParent(PDPageNode parent) {
        this.page.setItem(COSName.PARENT, (COSBase)parent.getDictionary());
    }

    public void updateLastModified() {
        this.page.setDate("LastModified", (Calendar)new GregorianCalendar());
    }

    public Calendar getLastModified() throws IOException {
        return this.page.getDate("LastModified");
    }

    public PDResources getResources() {
        PDResources retval = null;
        COSDictionary resources = (COSDictionary)this.page.getDictionaryObject(COSName.RESOURCES);
        if (resources != null) {
            retval = new PDResources(resources);
        }
        return retval;
    }

    public PDResources findResources() {
        PDResources retval = this.getResources();
        PDPageNode parent = this.getParent();
        if (retval == null && parent != null) {
            retval = parent.findResources();
        }
        return retval;
    }

    public void setResources(PDResources resources) {
        this.page.setItem(COSName.RESOURCES, (COSObjectable)resources);
    }

    public PDRectangle getMediaBox() {
        PDRectangle retval = null;
        COSArray array = (COSArray)this.page.getDictionaryObject(COSName.MEDIA_BOX);
        if (array != null) {
            retval = new PDRectangle(array);
        }
        return retval;
    }

    public PDRectangle findMediaBox() {
        PDRectangle retval = this.getMediaBox();
        PDPageNode parent = this.getParent();
        if (retval == null && parent != null) {
            retval = parent.findMediaBox();
        }
        return retval;
    }

    public void setMediaBox(PDRectangle mediaBox) {
        if (mediaBox == null) {
            this.page.removeItem(COSName.MEDIA_BOX);
        } else {
            this.page.setItem(COSName.MEDIA_BOX, (COSBase)mediaBox.getCOSArray());
        }
    }

    public PDRectangle getCropBox() {
        PDRectangle retval = null;
        COSArray array = (COSArray)this.page.getDictionaryObject(COSName.CROP_BOX);
        if (array != null) {
            retval = new PDRectangle(array);
        }
        return retval;
    }

    public PDRectangle findCropBox() {
        PDRectangle retval = this.getCropBox();
        PDPageNode parent = this.getParent();
        if (retval == null && parent != null) {
            retval = this.findParentCropBox(parent);
        }
        if (retval == null) {
            retval = this.findMediaBox();
        }
        return retval;
    }

    private PDRectangle findParentCropBox(PDPageNode node) {
        PDRectangle rect = node.getCropBox();
        PDPageNode parent = node.getParent();
        if (rect == null && parent != null) {
            rect = this.findParentCropBox(parent);
        }
        return rect;
    }

    public void setCropBox(PDRectangle cropBox) {
        if (cropBox == null) {
            this.page.removeItem(COSName.CROP_BOX);
        } else {
            this.page.setItem(COSName.CROP_BOX, (COSBase)cropBox.getCOSArray());
        }
    }

    public PDRectangle getBleedBox() {
        PDRectangle retval = null;
        COSArray array = (COSArray)this.page.getDictionaryObject(COSName.BLEED_BOX);
        retval = array != null ? new PDRectangle(array) : this.findCropBox();
        return retval;
    }

    public void setBleedBox(PDRectangle bleedBox) {
        if (bleedBox == null) {
            this.page.removeItem(COSName.BLEED_BOX);
        } else {
            this.page.setItem(COSName.BLEED_BOX, (COSBase)bleedBox.getCOSArray());
        }
    }

    public PDRectangle getTrimBox() {
        PDRectangle retval = null;
        COSArray array = (COSArray)this.page.getDictionaryObject(COSName.TRIM_BOX);
        retval = array != null ? new PDRectangle(array) : this.findCropBox();
        return retval;
    }

    public void setTrimBox(PDRectangle trimBox) {
        if (trimBox == null) {
            this.page.removeItem(COSName.TRIM_BOX);
        } else {
            this.page.setItem(COSName.TRIM_BOX, (COSBase)trimBox.getCOSArray());
        }
    }

    public PDRectangle getArtBox() {
        PDRectangle retval = null;
        COSArray array = (COSArray)this.page.getDictionaryObject(COSName.ART_BOX);
        retval = array != null ? new PDRectangle(array) : this.findCropBox();
        return retval;
    }

    public void setArtBox(PDRectangle artBox) {
        if (artBox == null) {
            this.page.removeItem(COSName.ART_BOX);
        } else {
            this.page.setItem(COSName.ART_BOX, (COSBase)artBox.getCOSArray());
        }
    }

    public Integer getRotation() {
        Integer retval = null;
        COSNumber value = (COSNumber)this.page.getDictionaryObject(COSName.ROTATE);
        if (value != null) {
            retval = new Integer(value.intValue());
        }
        return retval;
    }

    public int findRotation() {
        int retval = 0;
        Integer rotation = this.getRotation();
        if (rotation != null) {
            retval = rotation;
        } else {
            PDPageNode parent = this.getParent();
            if (parent != null) {
                retval = parent.findRotation();
            }
        }
        return retval;
    }

    public void setRotation(int rotation) {
        this.page.setItem(COSName.ROTATE, (COSBase)new COSInteger(rotation));
    }

    public PDStream getContents() throws IOException {
        return PDStream.createFromCOS(this.page.getDictionaryObject(COSName.CONTENTS));
    }

    public void setContents(PDStream contents) {
        this.page.setItem(COSName.CONTENTS, (COSObjectable)contents);
    }

    public List getThreadBeads() {
        COSArray beads = (COSArray)this.page.getDictionaryObject(COSName.B);
        if (beads == null) {
            beads = new COSArray();
        }
        ArrayList<PDThreadBead> pdObjects = new ArrayList<PDThreadBead>();
        for (int i = 0; i < beads.size(); ++i) {
            COSDictionary beadDic = (COSDictionary)beads.getObject(i);
            PDThreadBead bead = null;
            if (beadDic != null) {
                bead = new PDThreadBead(beadDic);
            }
            pdObjects.add(bead);
        }
        return new COSArrayList(pdObjects, beads);
    }

    public void setThreadBeads(List beads) {
        this.page.setItem(COSName.B, (COSBase)COSArrayList.converterToCOSArray(beads));
    }

    public PDMetadata getMetadata() {
        PDMetadata retval = null;
        COSStream stream = (COSStream)this.page.getDictionaryObject(COSName.METADATA);
        if (stream != null) {
            retval = new PDMetadata(stream);
        }
        return retval;
    }

    public void setMetadata(PDMetadata meta) {
        this.page.setItem(COSName.METADATA, (COSObjectable)meta);
    }

    public BufferedImage convertToImage() throws IOException {
        int scaling = 2;
        int rotation = this.findRotation();
        PDRectangle mBox = this.findMediaBox();
        int width = (int)mBox.getWidth();
        int height = (int)mBox.getHeight();
        if (rotation == 90 || rotation == 270) {
            int tmp = width;
            width = height;
            height = tmp;
        }
        Dimension pageDimension = new Dimension(width, height);
        BufferedImage retval = new BufferedImage(width * scaling, height * scaling, 13);
        Graphics2D graphics = (Graphics2D)retval.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, width * scaling, height * scaling);
        graphics.scale(scaling, scaling);
        PageDrawer drawer = new PageDrawer();
        drawer.drawPage(graphics, this, pageDimension);
        return retval;
    }

    public PDPageAdditionalActions getActions() {
        COSDictionary addAct = (COSDictionary)this.page.getDictionaryObject(COSName.AA);
        if (addAct == null) {
            addAct = new COSDictionary();
            this.page.setItem(COSName.AA, (COSBase)addAct);
        }
        return new PDPageAdditionalActions(addAct);
    }

    public void setActions(PDPageAdditionalActions actions) {
        this.page.setItem(COSName.AA, (COSObjectable)actions);
    }

    public List getAnnotations() throws IOException {
        COSArrayList retval = null;
        COSArray annots = (COSArray)this.page.getDictionaryObject(COSName.ANNOTS);
        if (annots == null) {
            annots = new COSArray();
            this.page.setItem(COSName.ANNOTS, (COSBase)annots);
            retval = new COSArrayList(new ArrayList(), annots);
        } else {
            ArrayList<PDAnnotation> actuals = new ArrayList<PDAnnotation>();
            for (int i = 0; i < annots.size(); ++i) {
                COSBase item = annots.getObject(i);
                actuals.add(PDAnnotation.createAnnotation(item));
            }
            retval = new COSArrayList(actuals, annots);
        }
        return retval;
    }

    public void setAnnotations(List annots) {
        this.page.setItem(COSName.ANNOTS, (COSBase)COSArrayList.converterToCOSArray(annots));
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        int retval = 1;
        if (pageIndex == 0) {
            try {
                retval = 0;
                PageDrawer drawer = new PageDrawer();
                PDRectangle pageSize = this.findMediaBox();
                Paper paper = new Paper();
                paper.setImageableArea(0.0, 0.0, pageSize.getWidth(), pageSize.getHeight());
                pageFormat.setPaper(paper);
                drawer.drawPage(graphics, this, pageSize.createDimension());
            }
            catch (IOException io) {
                throw new PrinterIOException(io);
            }
        }
        return retval;
    }

    public boolean equals(Object other) {
        return other instanceof PDPage && ((PDPage)other).getCOSObject() == this.getCOSObject();
    }

    public int hashCode() {
        return this.getCOSDictionary().hashCode();
    }
}

