/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core;

import org.jmock.core.Constraint;
import org.jmock.core.VerifyingTestCase;
import org.jmock.core.constraint.And;
import org.jmock.core.constraint.IsAnything;
import org.jmock.core.constraint.IsCloseTo;
import org.jmock.core.constraint.IsEqual;
import org.jmock.core.constraint.IsInstanceOf;
import org.jmock.core.constraint.IsNot;
import org.jmock.core.constraint.IsNull;
import org.jmock.core.constraint.IsSame;
import org.jmock.core.constraint.Or;
import org.jmock.core.constraint.StringContains;
import org.jmock.util.Dummy;

public abstract class MockObjectSupportTestCase
extends VerifyingTestCase {
    public static final Constraint ANYTHING = new IsAnything();
    public static final Constraint NULL = new IsNull();
    public static final Constraint NOT_NULL = new IsNot(NULL);

    public MockObjectSupportTestCase() {
    }

    public MockObjectSupportTestCase(String string) {
        super(string);
    }

    public IsEqual eq(Object object) {
        return new IsEqual(object);
    }

    public IsEqual eq(boolean bl) {
        return this.eq(new Boolean(bl));
    }

    public IsEqual eq(byte by) {
        return this.eq(new Byte(by));
    }

    public IsEqual eq(short s) {
        return this.eq(new Short(s));
    }

    public IsEqual eq(char c) {
        return this.eq(new Character(c));
    }

    public IsEqual eq(int n) {
        return this.eq(new Integer(n));
    }

    public IsEqual eq(long l) {
        return this.eq(new Long(l));
    }

    public IsEqual eq(float f) {
        return this.eq(new Float(f));
    }

    public IsEqual eq(double d) {
        return this.eq(new Double(d));
    }

    public IsCloseTo eq(double d, double d2) {
        return new IsCloseTo(d, d2);
    }

    public IsSame same(Object object) {
        return new IsSame(object);
    }

    public IsInstanceOf isA(Class clazz) {
        return new IsInstanceOf(clazz);
    }

    public StringContains stringContains(String string) {
        return new StringContains(string);
    }

    public IsNot not(Constraint constraint) {
        return new IsNot(constraint);
    }

    public And and(Constraint constraint, Constraint constraint2) {
        return new And(constraint, constraint2);
    }

    public Or or(Constraint constraint, Constraint constraint2) {
        return new Or(constraint, constraint2);
    }

    public Object newDummy(Class clazz) {
        return Dummy.newDummy(clazz);
    }

    public Object newDummy(Class clazz, String string) {
        return Dummy.newDummy(clazz, string);
    }

    public Object newDummy(String string) {
        return Dummy.newDummy(string);
    }
}

