/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.expectation;

import junit.framework.Assert;
import org.jmock.expectation.AbstractExpectation;

public class ExpectationCounter
extends AbstractExpectation {
    private int myExpectedCalls = 0;
    private int myActualCalls = 0;

    public ExpectationCounter(String string) {
        super(string);
    }

    public void clearActual() {
        this.myActualCalls = 0;
    }

    public void inc() {
        ++this.myActualCalls;
        if (this.shouldCheckImmediately()) {
            Assert.assertTrue((String)(this.myName + " should not be called more than " + this.myExpectedCalls + " times"), (this.myActualCalls <= this.myExpectedCalls ? 1 : 0) != 0);
        }
    }

    public void setExpected(int n) {
        this.myExpectedCalls = n;
        this.setHasExpectations();
    }

    public void setExpectNothing() {
        this.myExpectedCalls = 0;
        this.setHasExpectations();
    }

    public void verify() {
        this.assertEquals("did not receive the expected Count.", this.myExpectedCalls, this.myActualCalls);
    }
}

