/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jibx.binding.model.EmptyList;

public class MultipleValueMap {
    private final HashMap m_backingMap = new HashMap();
    private int m_valueCount;
    private Object m_lastKey;
    private Object m_lastValue;

    private Object getMapped(Object key) {
        if (key != this.m_lastKey) {
            this.m_lastKey = key;
            this.m_lastValue = this.m_backingMap.get(key);
        }
        return this.m_lastValue;
    }

    public void clear() {
        this.m_backingMap.clear();
        this.m_valueCount = 0;
    }

    public int getCount(Object key) {
        Object obj = this.getMapped(key);
        if (obj instanceof MultipleValueList) {
            return ((MultipleValueList)obj).size();
        }
        if (obj == null) {
            return 0;
        }
        return 1;
    }

    public Object get(Object key, int index) {
        Object obj = this.getMapped(key);
        if (obj instanceof MultipleValueList) {
            return ((MultipleValueList)obj).get(index);
        }
        if (obj == null) {
            throw new IndexOutOfBoundsException("No value present for key");
        }
        if (index == 0) {
            return obj;
        }
        throw new IndexOutOfBoundsException("Only one value present for key");
    }

    public void add(Object key, Object value) {
        this.getMapped(key);
        if (this.m_lastValue == null) {
            this.m_backingMap.put(key, value);
            this.m_lastValue = value;
        } else if (this.m_lastValue instanceof MultipleValueList) {
            ((MultipleValueList)this.m_lastValue).add(value);
        } else {
            MultipleValueList list = new MultipleValueList();
            list.add(this.m_lastValue);
            list.add(value);
            this.m_backingMap.put(key, list);
            this.m_lastValue = list;
        }
        ++this.m_valueCount;
    }

    public ArrayList get(Object key) {
        Object obj = this.m_backingMap.get(key);
        if (obj instanceof MultipleValueList) {
            return (MultipleValueList)obj;
        }
        if (obj == null) {
            return EmptyList.INSTANCE;
        }
        MultipleValueList list = new MultipleValueList();
        list.add(obj);
        return list;
    }

    public ArrayList extract(Object key) {
        ArrayList result = this.get(key);
        this.m_backingMap.remove(key);
        return result;
    }

    public int keySize() {
        return this.m_backingMap.size();
    }

    public int valueSize() {
        return this.m_valueCount;
    }

    public Iterator multipleIterator() {
        return new MultipleIterator();
    }

    public boolean containsKey(Object key) {
        return this.m_backingMap.containsKey(key);
    }

    public boolean isEmpty() {
        return this.m_backingMap.isEmpty();
    }

    public Set keySet() {
        return this.m_backingMap.keySet();
    }

    public class MultipleIterator
    implements Iterator {
        private boolean m_isConsumed;
        private Object m_currentKey;
        private Iterator m_keyIterator;

        protected MultipleIterator() {
            this.m_keyIterator = MultipleValueMap.this.keySet().iterator();
            this.m_isConsumed = true;
        }

        private void advance() {
            if (this.m_isConsumed) {
                this.m_isConsumed = false;
                this.m_currentKey = null;
                while (this.m_keyIterator.hasNext()) {
                    Object key = this.m_keyIterator.next();
                    if (MultipleValueMap.this.getCount(key) <= 1) continue;
                    this.m_currentKey = key;
                    break;
                }
            }
        }

        public boolean hasNext() {
            this.advance();
            return this.m_currentKey != null;
        }

        public Object next() {
            this.advance();
            if (this.m_currentKey == null) {
                throw new NoSuchElementException("Past end of list");
            }
            this.m_isConsumed = true;
            return this.m_currentKey;
        }

        public void remove() {
            this.m_keyIterator.remove();
        }
    }

    private static class MultipleValueList
    extends ArrayList {
    }
}

