/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security;

public final class MembershipEntry {
    public static final String ANY_TYPE = "*";
    private String membershipType;
    private String group;

    public MembershipEntry(String group) {
        this(group, null);
    }

    public MembershipEntry(String group, String membershipType) {
        String string = this.membershipType = membershipType != null ? membershipType : ANY_TYPE;
        if (group == null) {
            throw new NullPointerException("Group is null");
        }
        this.group = group;
    }

    public String getMembershipType() {
        return this.membershipType;
    }

    public String getGroup() {
        return this.group;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MembershipEntry)) {
            return false;
        }
        MembershipEntry me = (MembershipEntry)obj;
        if (this.membershipType.equals(ANY_TYPE) || me.membershipType.equals(ANY_TYPE)) {
            return this.group.equals(me.group);
        }
        return this.group.equals(me.group) && this.membershipType.equals(me.membershipType);
    }

    public static MembershipEntry parse(String identityStr) {
        if (identityStr.indexOf(":") != -1) {
            String membershipName = identityStr.substring(0, identityStr.indexOf(":"));
            String groupName = identityStr.substring(identityStr.indexOf(":") + 1);
            return new MembershipEntry(groupName, membershipName);
        }
        return null;
    }
}

